/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameState;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.PrizeFeature;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.steam.Steam;
import org.lwjgl.util.ReadableColor;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Puppytron;
import puppytron.Res;
import puppytron.entities.EnemyBullet;
import puppytron.entities.Player;
import puppytron.entities.Saucer;
import puppytron.features.GidrahFeature;

public class PuppytronGameState
extends GameState {
    private static final long serialVersionUID = 1L;
    private static final int APPLET_MAX_LEVEL = 1;
    private static int randomGidrahOffset;
    private int score;
    private int powerupScore;
    private int POWERUP_SCORE = 1000;
    private int POWERUP_DELAY_RATE = 100;
    private int powerupDelay;
    private final ArrayList<Entity> entities = new ArrayList();
    private int tick;
    private int totalTicks;
    private int saucerTick;
    private int level;
    private int phase;
    private int waitTick;
    private Player player;
    private int nextBot;
    boolean usingMouse;
    private int smartbombs;

    public void init() {
        GameScreen.beginGame(this);
        this.powerupScore = this.POWERUP_SCORE;
        this.powerupDelay = 0;
        this.setTick(0);
        this.setLevel(1);
        this.setPhase(1);
        this.entities.clear();
        GidrahFeature.resetNumGidrahs();
        EnemyBullet.reset();
        this.player = new Player();
        this.player.spawn(GameScreen.getInstance());
        GameScreen.initBackground();
        this.doInitMessages("PREPARE TO DIE", "Hit ESC to save game and quit");
        PrizeFeature prize = MiniGame.getPrize();
        if (prize != null) {
            prize.redeem();
            MiniGame.setPrize(null);
        }
    }

    private void doInitMessages(String big, String small) {
        LabelEffect newLevelEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), big, ReadableColor.WHITE, ReadableColor.RED, 40, 160);
        newLevelEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
        newLevelEffect.setVisible(true);
        newLevelEffect.spawn((Screen)GameScreen.getInstance());
        LabelEffect hintEffect = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), small, ReadableColor.WHITE, ReadableColor.RED, 40, 160);
        hintEffect.setDelay(30);
        hintEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 40));
        hintEffect.setVisible(true);
        hintEffect.spawn((Screen)GameScreen.getInstance());
    }

    public void reinit() {
        GameScreen.beginGame(this);
        this.doInitMessages("RESUMING GAME", "Hit ESC to save game and quit");
        for (Entity entity : this.entities) {
            entity.respawn(GameScreen.getInstance());
        }
        GameScreen.initBackground();
        if (this.player == null || !this.player.isActive()) {
            MiniGame.endGame();
        }
    }

    void tick() {
        switch (this.getPhase()) {
            case 0: {
                if (GidrahFeature.getNumGidrahs() > 0) break;
                if (this.waitTick == 0) {
                    int levelsToBoss;
                    this.setLevel(this.getLevel() + 1);
                    this.maybeSetBestLevel();
                    LabelEffect newLevelEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), GameScreen.isAssaultLevel() ? "ASSAULT LEVEL" : "LEVEL " + GameScreen.getLevel(), ReadableColor.WHITE, ReadableColor.BLUE, 180, 60);
                    newLevelEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 40));
                    newLevelEffect.setVisible(true);
                    newLevelEffect.setSound(Res.getBreatherBuffer());
                    newLevelEffect.spawn((Screen)GameScreen.getInstance());
                    if (this.getLevel() < GameScreen.getInstance().progressDisplay.getTotalBars()) {
                        GameScreen.getInstance().setVisible("progress", true);
                        GameScreen.getInstance().getArea("progress").setAlpha(192);
                        GameScreen.getInstance().progressInstance = GameScreen.getInstance().progressDisplay.spawn((Screen)GameScreen.getInstance());
                        GameScreen.getInstance().progressInstance.setUsed(this.getLevel() - 1);
                        GameScreen.getInstance().progressInstance.setAlpha(192);
                        GameScreen.getInstance().onResized();
                    }
                    this.player.incMultipler();
                    this.player.updateAccumulatedMultiplier();
                    if (this.player.getMultiplier() > 1) {
                        LabelEffect multiplierEffect = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "x" + this.player.getMultiplier() + " MULTIPLIER ACTIVE", ReadableColor.WHITE, ReadableColor.BLUE, 180, 60);
                        multiplierEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 20));
                        multiplierEffect.setVisible(true);
                        multiplierEffect.setDelay(120);
                        multiplierEffect.setSound(Res.getBonusIncreased(this.player.getMultiplier()));
                        multiplierEffect.spawn((Screen)GameScreen.getInstance());
                    }
                    int nextBossLevel = (1 + this.getLevel() / 10) * 10;
                    if (!(this.getLevel() < nextBossLevel - 3 && this.getLevel() % 10 != 0 || (levelsToBoss = nextBossLevel - this.getLevel()) >= 3 && levelsToBoss != 10 || this.getLevel() > 40)) {
                        LabelEffect multiplierEffect = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), levelsToBoss == 10 ? String.valueOf(GameScreen.BOSS_NAMES[this.getLevel() / 10 - 1]) + " AWAITS" : String.valueOf(levelsToBoss) + " LEVELS" + (levelsToBoss == 1 ? "" : "s") + " UNTIL " + GameScreen.BOSS_NAMES[this.getLevel() / 10], ReadableColor.WHITE, ReadableColor.BLUE, 180, 60);
                        multiplierEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 20));
                        multiplierEffect.setVisible(true);
                        multiplierEffect.setDelay(160);
                        multiplierEffect.spawn((Screen)GameScreen.getInstance());
                    }
                    GameScreen.initLevel();
                }
                ++this.waitTick;
                if (this.waitTick != 240) break;
                this.setPhase(1);
            }
            case 1: {
                int ld;
                this.setTick(this.getTick() + 1);
                if (this.getTick() < 96 && GameScreen.getInstance().getArea("progress").isVisible()) {
                    GameScreen.getInstance().getArea("progress").setAlpha(192 - this.getTick() * 2);
                    if (GameScreen.getInstance().progressInstance != null) {
                        GameScreen.getInstance().progressInstance.setAlpha(192 - this.getTick() * 2);
                    }
                } else if (this.getTick() == 96 && GameScreen.getInstance().getArea("progress").isVisible()) {
                    GameScreen.getInstance().setVisible("progress", false);
                    if (GameScreen.getInstance().progressInstance != null) {
                        GameScreen.getInstance().progressInstance.cleanup();
                        GameScreen.getInstance().progressInstance = null;
                    }
                }
                ++this.totalTicks;
                if (GameScreen.isAssaultLevel()) {
                    if (this.getTick() < 275) {
                        int botsMinimum = (int)(20.0f + 0.15f * (float)this.getLevel());
                        if (this.usingMouse) {
                            botsMinimum = (int)((float)botsMinimum * 1.5f);
                        }
                        GidrahFeature.createAssault(this.getLevel() / 5 / 2, botsMinimum - GidrahFeature.getNumGidrahs());
                    }
                } else {
                    int minGidrahs;
                    --this.nextBot;
                    int n = minGidrahs = this.usingMouse ? 2 : 1;
                    if (this.nextBot <= 0 || GidrahFeature.getNumGidrahs() < minGidrahs) {
                        int diff = this.player.getAccumulatedMultiplier() / 4 + GameScreen.getLevel() * 2 + (12 - this.player.getRepeatRate()) * 1;
                        if (this.player.isBouncy()) {
                            diff += 2;
                        }
                        if (this.player.isThreeWay()) {
                            diff += 2;
                        }
                        if (GameScreen.getLevel() > 1 && this.usingMouse) {
                            diff = (int)((float)diff * 1.25f);
                        }
                        int minRate = this.usingMouse ? 22 : 30;
                        this.nextBot = Math.max(minRate, 70 - diff);
                        GidrahFeature.createGidrah();
                    }
                }
                if (this.getLevel() >= 3) {
                    ++this.saucerTick;
                    int saucerSpawn = Math.max(1000, 3000 - 50 * this.getLevel());
                    if (this.saucerTick > saucerSpawn) {
                        this.saucerTick = 0;
                        Saucer saucer = new Saucer();
                        saucer.spawn(GameScreen.getInstance());
                    }
                }
                int n = ld = GameScreen.isAssaultLevel() ? 550 : 2200;
                if (this.getTick() != ld) break;
                if (!Game.isRegistered() && Game.getConfiguration().getMaxLevel() > 0 && this.level > Game.getConfiguration().getMaxLevel()) {
                    this.expireDemo();
                    break;
                }
                if (GameScreen.getLevel() % 10 == 0) {
                    this.setPhase(2);
                    break;
                }
                if (GameScreen.getLevel() % 7 == 0) {
                    this.setPhase(6);
                    break;
                }
                this.setPhase(0);
                this.waitTick = 0;
                break;
            }
            case 6: {
                ++this.totalTicks;
                if (GidrahFeature.getNumGidrahs() > 0) break;
                this.setPhase(7);
                this.setTick(0);
                Saucer.resetChallenge();
                LabelEffect challengeEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "CHALLENGE STAGE", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                challengeEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 40));
                challengeEffect.setVisible(true);
                challengeEffect.spawn((Screen)GameScreen.getInstance());
                LabelEffect challengeEffect2 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "SHOOT ALL SPIDROIDS", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                challengeEffect2.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
                challengeEffect2.setVisible(true);
                challengeEffect2.spawn((Screen)GameScreen.getInstance());
                challengeEffect2.setDelay(120);
                LabelEffect challengeEffect3 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "PLAYER IS SHIELDED", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                challengeEffect3.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 20));
                challengeEffect3.setVisible(true);
                challengeEffect3.spawn((Screen)GameScreen.getInstance());
                challengeEffect3.setDelay(240);
            }
            case 7: {
                this.setTick(this.getTick() + 1);
                if (this.getTick() < 360) break;
                this.setPhase(8);
                this.setTick(0);
            }
            case 8: {
                this.setTick(this.getTick() + 1);
                if (this.getTick() < 800 + 10 * this.getLevel()) {
                    int saucerSpawn = Math.max(20, 60 - 2 * this.getLevel() - (this.usingMouse ? 10 : 0));
                    if (this.getTick() % saucerSpawn != 0) break;
                    Saucer saucer = new Saucer();
                    saucer.setChallenge(true);
                    saucer.spawn(GameScreen.getInstance());
                    break;
                }
                if (Saucer.getNumberRemoved() < Saucer.getNumberSpawned()) break;
                this.setPhase(9);
                this.setTick(0);
                LabelEffect bonusEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "CHALLENGE COMPLETE", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                bonusEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 40));
                bonusEffect.setVisible(true);
                bonusEffect.setSound(Res.getWellDoneHumanoid());
                bonusEffect.spawn((Screen)GameScreen.getInstance());
                int ratio = 100 * Saucer.getNumberShot() / Saucer.getNumberSpawned();
                String message = ratio == 100 ? "PERFECT!" : "SHOT " + Saucer.getNumberShot() + " / " + Saucer.getNumberSpawned() + " : " + ratio + "%";
                LabelEffect bonusEffect2 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), message, ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                bonusEffect2.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
                bonusEffect2.setVisible(true);
                bonusEffect2.setDelay(120);
                bonusEffect2.setSound(Res.getChallengeBonus());
                bonusEffect2.spawn((Screen)GameScreen.getInstance());
                int rate = 100 * (1 + this.getLevel() / 7);
                int bonus = ratio * rate;
                LabelEffect bonusEffect3 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "BONUS " + ratio + "% x " + rate + " = " + bonus + " POINTS", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                bonusEffect3.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 20));
                Puppytron.addScore(bonus);
                bonusEffect3.setVisible(true);
                bonusEffect3.setDelay(240);
                bonusEffect3.setSound(Res.getBombDetonated());
                bonusEffect3.spawn((Screen)GameScreen.getInstance());
            }
            case 9: {
                this.setTick(this.getTick() + 1);
                if (this.getTick() < 360) break;
                this.setPhase(0);
                this.waitTick = 0;
                break;
            }
            case 2: {
                ++this.totalTicks;
                if (GidrahFeature.getNumGidrahs() > 0) break;
                String bossName = this.getLevel() <= 40 ? GameScreen.BOSS_NAMES[this.getLevel() / 10 - 1] : "BOSS ROBOTS";
                LabelEffect destroyBossEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "DESTROY " + bossName + "!!!", ReadableColor.WHITE, ReadableColor.RED, 60, 240);
                destroyBossEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
                destroyBossEffect.setVisible(true);
                destroyBossEffect.spawn((Screen)GameScreen.getInstance());
                GameScreen.initArena();
                GidrahFeature.createBosses();
                this.setPhase(3);
                this.setTick(0);
            }
            case 3: {
                ++this.totalTicks;
                this.setTick(this.getTick() + 1);
                if (this.getTick() == 300 && !Game.isRegistered() && Game.getConfiguration().getMaxLevel() > 0 && this.level >= Game.getConfiguration().getMaxLevel()) {
                    this.expireDemo();
                    break;
                }
                if (GidrahFeature.getNumGidrahs() > 0) break;
                if (!Game.isRegistered()) {
                    this.expireDemo();
                    break;
                }
                LabelEffect congratsEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), this.getLevel() == GameScreen.getInstance().progressDisplay.getTotalBars() ? "HUMAN RACE AVENGED!" : "WELL DONE!", ReadableColor.WHITE, ReadableColor.YELLOW, 180, 60);
                congratsEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 20));
                congratsEffect.setVisible(true);
                congratsEffect.setDelay(400);
                congratsEffect.setSound(Res.getWellDoneHumanoid());
                congratsEffect.spawn((Screen)GameScreen.getInstance());
                this.setPhase(0);
                this.waitTick = -600;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.setTick(this.getTick() + 1);
                if (this.getTick() <= 240) break;
                MiniGame.endGame();
            }
        }
    }

    private void expireDemo() {
        this.player.kill();
        LabelEffect nagEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "): ): DEMO EXPIRED :( :(", ReadableColor.YELLOW, ReadableColor.RED, 160, 240);
        nagEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
        nagEffect.setVisible(true);
        nagEffect.spawn((Screen)GameScreen.getInstance());
        Game.getLocalPreferences().putBoolean("showregister", true);
        this.phase = 5;
        this.tick = 0;
    }

    void tickAllEntities() {
        int i = 0;
        while (i < this.entities.size()) {
            Entity src = this.entities.get(i);
            if (!src.isActive()) {
                this.entities.remove(i);
                continue;
            }
            int j = i + 1;
            while (j < this.entities.size() && src.isActive()) {
                Entity dest = this.entities.get(j);
                if (!dest.isActive()) {
                    this.entities.remove(j);
                    continue;
                }
                if (src.canCollide() && dest.canCollide() && src.isTouching(dest)) {
                    src.onCollision(dest);
                    dest.onCollision(src);
                }
                ++j;
            }
            ++i;
        }
    }

    private void maybeSetBestLevel() {
        if (!Game.isRegistered()) {
            Game.getRoamingPreferences().putInt("bestlevel" + Game.getInstallation(), Math.max(this.getBestLevel(), this.getLevel()));
        }
    }

    private int getBestLevel() {
        return Game.getRoamingPreferences().getInt("bestlevel" + Game.getInstallation(), 0);
    }

    void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    void setTick(int tick) {
        this.tick = tick;
    }

    void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    void incLevel() {
        ++this.level;
    }

    int getTick() {
        return this.tick;
    }

    void setPhase(int phase) {
        this.phase = phase;
    }

    int getPhase() {
        return this.phase;
    }

    Player getPlayer() {
        return this.player;
    }

    int getTotalTicks() {
        return this.totalTicks;
    }

    void resetTotalTicks() {
        this.totalTicks = 0;
    }

    public void freezeGidrahs() {
        int n = this.entities.size();
        int i = 0;
        while (i < n) {
            Entity entity = this.entities.get(i);
            if (entity instanceof Gidrah) {
                ((Gidrah)((Object)entity)).freeze();
            }
            ++i;
        }
    }

    public int getNumGidrahs() {
        int n = this.entities.size();
        int count = 0;
        int i = 0;
        while (i < n) {
            Entity entity = this.entities.get(i);
            if (entity.isActive() && entity instanceof Gidrah) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void shortFreezeGidrahs() {
        int n = this.entities.size();
        int i = 0;
        while (i < n) {
            Entity entity = this.entities.get(i);
            if (entity instanceof Gidrah) {
                ((Gidrah)((Object)entity)).shortFreeze();
            }
            ++i;
        }
    }

    public Gidrah getRandomGidrah() {
        Entity entity;
        int n = this.entities.size();
        int i = Math.min(randomGidrahOffset + 1, n);
        while (i < n) {
            entity = this.entities.get(i);
            if (entity instanceof Gidrah) {
                randomGidrahOffset = i;
                return (Gidrah)((Object)entity);
            }
            ++i;
        }
        i = 0;
        while (i < n && i <= randomGidrahOffset) {
            entity = this.entities.get(i);
            if (entity instanceof Gidrah) {
                randomGidrahOffset = i;
                return (Gidrah)((Object)entity);
            }
            ++i;
        }
        return null;
    }

    public int getScore() {
        return this.score;
    }

    public void addScore(int delta) {
        this.score = Math.max(0, this.score + delta);
    }

    public void setUsingMouse(boolean usingMouse) {
        this.usingMouse = usingMouse;
    }

    public boolean isPowerupDue() {
        if (this.score >= this.powerupScore) {
            this.powerupScore += this.POWERUP_SCORE + this.powerupDelay * GameScreen.getPlayer().getMultiplier();
            this.powerupDelay += this.POWERUP_DELAY_RATE * GameScreen.getPlayer().getMultiplier();
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(Saucer.getNumberSpawned());
        stream.writeInt(Saucer.getNumberShot());
        stream.writeInt(Saucer.getNumberRemoved());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int saucersSpawned = stream.readInt();
        int saucersShot = stream.readInt();
        int saucersRemoved = stream.readInt();
        Saucer.reinit(saucersSpawned, saucersShot, saucersRemoved);
    }

    public void onSmartbombUsed() {
        ++this.smartbombs;
        if (this.smartbombs == 10) {
            this.awardMedal("smartbombtastic");
        }
    }

    public void awardMedal(String medal) {
        if (Game.isUsingSteam() && Steam.isCreated() && Steam.isSteamRunning()) {
            Steam.getUserStats().setAchievement(medal);
            Steam.getUserStats().storeStats();
        }
    }
}

