/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameState;
import net.puppygames.applet.Launcher;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.Score;
import net.puppygames.applet.screens.HiscoresScreen;
import net.puppygames.applet.screens.NagScreen;
import net.puppygames.applet.screens.OptionsScreen;
import net.puppygames.applet.screens.RegisterScreen;
import net.puppygames.applet.screens.TitleScreen;
import net.puppygames.steam.NotificationPosition;
import net.puppygames.steam.Steam;
import org.lwjgl.openal.AL;
import puppytron.GameScreen;
import puppytron.PuppytronGameState;

public class Puppytron
extends MiniGame {
    private static final long serialVersionUID = 1L;
    private static final boolean TESTSIGNUP = true;
    private static SoundPlayer speechPlayer;
    private static PuppytronGameState gameState;

    public Puppytron(String name) {
        super(name);
    }

    protected GameState createGameState() {
        return new PuppytronGameState();
    }

    public static PuppytronGameState getGameState() {
        return gameState;
    }

    protected void setGameState(GameState newGameState) {
        super.setGameState(newGameState);
        gameState = (PuppytronGameState)newGameState;
    }

    protected void doGameOver() {
        GameScreen.gameOver();
    }

    protected void doShowOptions() {
        OptionsScreen.show();
    }

    protected void doShowRegisterScreen() {
        RegisterScreen.show();
    }

    protected void doCreate() {
        super.doCreate();
        if (AL.isCreated() && Puppytron.isSFXEnabled()) {
            speechPlayer = new SoundPlayer(1);
            speechPlayer.create();
        }
        if (Puppytron.isUsingSteam() && Steam.isCreated() && Steam.isSteamRunning()) {
            Steam.getUtils().setOverlayNotificationPosition(NotificationPosition.TopRight);
            Steam.getUserStats().requestCurrentStats();
        }
    }

    public static SoundEffect speak(ALBuffer buffer) {
        if (!AL.isCreated() || !Puppytron.isSFXEnabled()) {
            return null;
        }
        SoundEffect effect = speechPlayer.allocate(buffer, Game.class);
        if (effect != null) {
            effect.setAttenuated(false, Game.class);
            effect.setGain(effect.getBuffer().getGain() * Puppytron.getSFXVolume(), Game.class);
            if (buffer.getWave().getType() == 1) {
                effect.setPosition(0.0f, 0.0f, 0.0f, Game.class);
            }
        }
        return effect;
    }

    public static int getScore() {
        return gameState.getScore();
    }

    public static boolean isPowerupDue() {
        return gameState.isPowerupDue();
    }

    public static void addScore(int points) {
        gameState.addScore(points);
    }

    public static void setUsingMouse(boolean usingMouse) {
        gameState.setUsingMouse(usingMouse);
    }

    public static boolean isUsingMouse() {
        return Puppytron.gameState.usingMouse;
    }

    protected void doEndGame() {
        if (MiniGame.isDemoExpired()) {
            NagScreen.show((String)"You know you want to!", (boolean)true);
        } else if (gameState.getScore() > 0) {
            Score scoreToSubmit = new Score(Puppytron.getTitle(), Puppytron.getVersion(), Puppytron.getScoreGroup(), "", Puppytron.getInstallation(), gameState.getScore(), "", Puppytron.isRegistered());
            HiscoresScreen.show((Score)scoreToSubmit);
        } else {
            TitleScreen.show();
        }
    }

    protected void doTick() {
        if (AL.isCreated()) {
            speechPlayer.play();
        }
    }

    protected void onExit() {
        GameScreen.onExit();
    }

    protected void doDestroy() {
        super.doDestroy();
        if (speechPlayer != null) {
            speechPlayer.destroy();
            speechPlayer = null;
        }
    }

    public static void main(String[] args) {
        Launcher.main((String[])args);
    }
}

