/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.widgets.PowerDisplay;
import net.puppygames.applet.widgets.PowerDisplayFeature;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import puppytron.Entity;
import puppytron.Gidrah;
import puppytron.Puppytron;
import puppytron.PuppytronGameState;
import puppytron.entities.Player;
import puppytron.features.Background;
import puppytron.features.GidrahFeature;

public class GameScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static final Point SPRITE_OFFSET = new Point();
    static final String GAMEOVER = "gameover";
    static final String PROGRESS = "progress";
    private static final String HUD_FRONT = "hud_front";
    private static final String HUD_BACK = "hud_back";
    private static final String SHIELDS_EMPTY = "shields_empty";
    private static final String SCORE_BOUNDS = "score_bounds";
    private static final String LEVEL_BOUNDS = "level_bounds";
    private static final String BONUS_BOUNDS = "bonus_bounds";
    private static final String TIMER_BOUNDS = "timer_bounds";
    static final String[] BOSS_NAMES = new String[]{"IEIUNITAS", "BELLUM", "LUES", "LETUM"};
    private static GameScreen instance;
    private static final Color cachedColor;
    public static final int LEVELS_PER_BOSS = 10;
    public static final int LEVELS_PER_CHALLENGE = 7;
    public static final int LEVELS_PER_ASSAULT = 5;
    static final int INITIAL_BOT_SPAWN_RATE = 70;
    static final int MIN_BOT_SPAWN_RATE = 30;
    static final int BOT_SPAWN_RATE_ADJUSTER = 2;
    static final int INITIAL_SAUCER_SPAWN_RATE = 3000;
    static final int MIN_SAUCER_SPAWN_RATE = 1000;
    static final int SAUCER_SPAWN_RATE_ADJUSTER = 50;
    static final int GUN_SPAWN_RATE_ADJUSTER = 1;
    public static final int PHASE_WAIT = 0;
    public static final int PHASE_PLAY = 1;
    public static final int PHASE_WAIT_FOR_BOSS = 2;
    public static final int PHASE_BOSS = 3;
    public static final int PHASE_NOTHING = 4;
    public static final int PHASE_GAMEOVER = 5;
    public static final int PHASE_WAIT_FOR_CHALLENGE = 6;
    public static final int PHASE_CHALLENGE_BEGIN = 7;
    public static final int PHASE_CHALLENGE = 8;
    public static final int PHASE_CHALLENGE_END = 9;
    static final int CHALLENGE_BEGIN_DURATION = 360;
    static final int CHALLENGE_DURATION = 800;
    static final int CHALLENGE_DURATION_PER_LEVEL = 10;
    static final int CHALLENGE_SPAWN_RATE = 60;
    static final int MIN_CHALLENGE_SPAWN_RATE = 20;
    static final int CHALLENGE_SPAWN_RATE_PER_LEVEL = 2;
    static final int CHALLENGE_END_DURATION = 360;
    static final int BOTS_PER_ASSAULT = 20;
    static final float BOTS_PER_LEVEL_IN_ASSAULT = 0.15f;
    static final int WAIT_DURATION = 240;
    static final int GAMEOVER_DURATION = 240;
    public static final int LEVEL_DURATION = 2200;
    private static int hudAlpha;
    private static Color oldBackgroundColor;
    static PuppytronGameState gameState;
    private static Background background;
    private static int backgroundFadeTick;
    private static int backgroundFadePhase;
    private static final int FADE_OUT = 0;
    private static final int SWAP = 1;
    private static final int FADE_IN = 2;
    private static final int DONE = 3;
    private static boolean immune;
    private PowerDisplayFeature shieldsDisplay;
    PowerDisplayFeature progressDisplay;
    private Color timeColorLeft;
    private Color timeColorRight;
    private transient GLTextArea scoreLabel;
    private transient GLTextArea bonusLabel;
    private transient GLTextArea levelLabel;
    private transient PowerDisplay shieldPowerInstance;
    private transient int displayedScore;
    private transient int displayedBonus;
    private transient int displayedLevel;
    transient PowerDisplay progressInstance;
    private transient Area shieldsEmpty;
    private transient TickableObject backgroundRenderer;
    private transient TickableObject hudRenderer;
    private transient ReadableRectangle scoreBounds;
    private transient ReadableRectangle timerBounds;
    private transient ReadableRectangle levelBounds;
    private transient ReadableRectangle bonusBounds;

    static {
        cachedColor = new Color();
        hudAlpha = 255;
        oldBackgroundColor = new Color(Color.BLACK);
    }

    public GameScreen(String name) {
        super(name);
    }

    protected void doRegister() {
        instance = this;
        Effect.setDefaultOffset((SpriteAllocator)this, (ReadablePoint)SPRITE_OFFSET);
    }

    protected void doDeregister() {
        instance = null;
    }

    public static int getLevel() {
        return gameState.getLevel();
    }

    protected void onOpen() {
        this.shieldPowerInstance = this.shieldsDisplay.spawn((Screen)this);
        this.setVisible(PROGRESS, false);
        this.displayedBonus = -1;
        this.displayedScore = -1;
        this.displayedLevel = -1;
        this.hudRenderer = new TickableObject(){
            private final GLRenderable setup = new GLRenderable(){

                public void render() {
                    GL11.glEnable((int)3553);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)1, (int)771);
                    GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                }
            };
            private final GLRenderable shadow = new GLRenderable(){

                public void render() {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)2.0f, (float)-2.0f, (float)0.0f);
                }
            };
            private final GLRenderable pop = new GLRenderable(){

                public void render() {
                    GL11.glPopMatrix();
                }
            };
            private final GLRenderable disableTexturing = new GLRenderable(){

                public void render() {
                    GL11.glDisable((int)3553);
                }
            };

            protected void render() {
                this.glRender(this.setup);
                ColorUtil.setGLColorPre((ReadableColor)ReadableColor.BLACK, (int)(hudAlpha >> 1), (SimpleRenderer)this);
                if (GameScreen.this.displayedScore != Puppytron.getScore()) {
                    GameScreen.this.displayedScore = Puppytron.getScore();
                    GameScreen.this.scoreLabel.setText(String.valueOf(GameScreen.this.displayedScore));
                }
                if (GameScreen.this.displayedLevel != GameScreen.getLevel()) {
                    GameScreen.this.displayedLevel = GameScreen.getLevel();
                    GameScreen.this.levelLabel.setText(String.valueOf(GameScreen.this.displayedLevel));
                }
                this.glRender(this.shadow);
                GameScreen.this.scoreLabel.render((SimpleRenderer)this);
                GameScreen.this.levelLabel.render((SimpleRenderer)this);
                this.glRender(this.pop);
                ColorUtil.setGLColorPre((ReadableColor)ReadableColor.WHITE, (int)hudAlpha, (SimpleRenderer)this);
                GameScreen.this.scoreLabel.render((SimpleRenderer)this);
                GameScreen.this.levelLabel.render((SimpleRenderer)this);
                int mult = gameState.getPlayer().getMultiplier();
                if (mult != GameScreen.this.displayedBonus) {
                    GameScreen.this.bonusLabel.setText(String.valueOf(mult));
                    GameScreen.this.displayedBonus = mult;
                }
                if (mult > 1) {
                    this.glRender(this.shadow);
                    ColorUtil.setGLColorPre((ReadableColor)ReadableColor.BLACK, (int)(hudAlpha >> 1), (SimpleRenderer)this);
                    GameScreen.this.bonusLabel.render((SimpleRenderer)this);
                    this.glRender(this.pop);
                    ColorUtil.setGLColorPre((ReadableColor)ReadableColor.WHITE, (int)hudAlpha, (SimpleRenderer)this);
                    GameScreen.this.bonusLabel.render((SimpleRenderer)this);
                }
                if (gameState.getPhase() == 1) {
                    int ld = GameScreen.isAssaultLevel() ? 550 : 2200;
                    this.glRender(this.disableTexturing);
                    int timeLeft = ld - Math.min(ld, gameState.getTick());
                    float ratio = (float)timeLeft / (float)ld;
                    ColorInterpolator.interpolate((ReadableColor)GameScreen.this.timeColorLeft, (ReadableColor)GameScreen.this.timeColorRight, (float)ratio, (Interpolator)LinearInterpolator.instance, (Color)cachedColor);
                    cachedColor.setAlpha(hudAlpha);
                    int x2 = (int)LinearInterpolator.instance.interpolate((float)GameScreen.this.timerBounds.getX(), (float)(GameScreen.this.timerBounds.getX() + GameScreen.this.timerBounds.getWidth()), ratio);
                    ColorUtil.setGLColorPre((ReadableColor)GameScreen.this.timeColorLeft, (int)hudAlpha, (SimpleRenderer)this);
                    short idx = this.glVertex2f(GameScreen.this.timerBounds.getX(), GameScreen.this.timerBounds.getY());
                    ColorUtil.setGLColorPre((ReadableColor)cachedColor, (SimpleRenderer)this);
                    this.glVertex2f(x2, GameScreen.this.timerBounds.getY());
                    this.glVertex2f(x2, GameScreen.this.timerBounds.getY() + GameScreen.this.timerBounds.getHeight());
                    ColorUtil.setGLColorPre((ReadableColor)GameScreen.this.timeColorLeft, (int)hudAlpha, (SimpleRenderer)this);
                    this.glVertex2f(GameScreen.this.timerBounds.getX(), GameScreen.this.timerBounds.getY() + GameScreen.this.timerBounds.getHeight());
                    this.glRender(4, new short[]{(short)(idx + 0), (short)(idx + 1), (short)(idx + 2), (short)(idx + 0), (short)(idx + 2), (short)(idx + 3)});
                }
            }
        };
        this.hudRenderer.setLayer(6);
        this.hudRenderer.spawn((Screen)this);
        this.backgroundRenderer = new TickableObject(){
            private final GLRenderable setup = new GLRenderable(){

                public void render() {
                    GL11.glDisable((int)3042);
                    GL11.glDisable((int)3553);
                }
            };

            protected void render() {
                switch (backgroundFadePhase) {
                    case 0: {
                        float ratio;
                        backgroundFadeTick = backgroundFadeTick + 1;
                        if (backgroundFadeTick < 20) {
                            ratio = (float)backgroundFadeTick / 20.0f;
                            ColorInterpolator.interpolate((ReadableColor)oldBackgroundColor, (ReadableColor)ReadableColor.BLACK, (float)ratio, (Interpolator)LinearInterpolator.instance, (Color)cachedColor);
                            backgroundFadeTick = backgroundFadeTick + 1;
                            break;
                        }
                        cachedColor.setColor(ReadableColor.BLACK);
                        backgroundFadePhase = 1;
                        backgroundFadeTick = 0;
                        break;
                    }
                    case 1: {
                        cachedColor.setColor(ReadableColor.BLACK);
                        backgroundFadeTick = backgroundFadeTick + 1;
                        if (backgroundFadeTick < 20) break;
                        backgroundFadePhase = 2;
                        backgroundFadeTick = 0;
                        break;
                    }
                    case 2: {
                        float ratio;
                        backgroundFadeTick = backgroundFadeTick + 1;
                        if (backgroundFadeTick < 20) {
                            ratio = (float)backgroundFadeTick / 20.0f;
                            ColorInterpolator.interpolate((ReadableColor)ReadableColor.BLACK, (ReadableColor)background.getColor(), (float)ratio, (Interpolator)LinearInterpolator.instance, (Color)cachedColor);
                            break;
                        }
                        cachedColor.setColor((ReadableColor)background.getColor());
                        backgroundFadePhase = 3;
                        backgroundFadeTick = 0;
                        break;
                    }
                    case 3: {
                        cachedColor.setColor((ReadableColor)background.getColor());
                    }
                }
                this.glRender(this.setup);
                ColorUtil.setGLColorPre((ReadableColor)cachedColor, (SimpleRenderer)this);
                short idx = this.glVertex2f(0.0f, 0.0f);
                this.glVertex2f(GameScreen.this.getWidth(), 0.0f);
                this.glVertex2f(GameScreen.this.getWidth(), GameScreen.this.getHeight());
                this.glVertex2f(0.0f, GameScreen.this.getHeight());
                this.glRender(4, new short[]{(short)(idx + 0), (short)(idx + 1), (short)(idx + 2), (short)(idx + 0), (short)(idx + 2), (short)(idx + 3)});
            }
        };
        this.backgroundRenderer.setLayer(-6);
        this.backgroundRenderer.spawn((Screen)this);
        this.onResized();
    }

    public static boolean isImmune() {
        return immune;
    }

    public static boolean isLevelTimedOut() {
        return gameState.getPhase() == 0;
    }

    protected void doTick() {
        if (Game.isPaused()) {
            return;
        }
        MiniGame.onTicked();
        gameState.tick();
        Player player = gameState.getPlayer();
        if (player != null) {
            this.shieldPowerInstance.setUsed(player.getShields());
            if (player.getShields() == 0 && this.shieldsEmpty != null && !this.shieldsEmpty.isVisible()) {
                this.shieldsEmpty.setVisible(true);
            } else if (this.shieldsEmpty != null && this.shieldsEmpty.isVisible() && player.getShields() > 0) {
                this.shieldsEmpty.setVisible(false);
            }
            if (Keyboard.isKeyDown((int)1) && player.canCollide()) {
                MiniGame.saveGame();
                player.kill();
            }
        }
        while (Keyboard.next()) {
        }
        gameState.tickAllEntities();
        if (player != null && player.getY() > 280.0f) {
            if (hudAlpha > 32) {
                hudAlpha = Math.max(32, hudAlpha - 16);
            }
        } else if (hudAlpha < 255) {
            hudAlpha = Math.min(255, hudAlpha + 16);
        }
        this.getArea(HUD_BACK).setAlpha(hudAlpha);
        this.getArea(HUD_FRONT).setAlpha(hudAlpha);
        this.getArea(SHIELDS_EMPTY).setAlpha(hudAlpha);
        this.shieldPowerInstance.setAlpha(hudAlpha);
    }

    public static int getTick() {
        return gameState.getTick();
    }

    public static int getTotalTicks() {
        int oldTotalTicks = gameState.getTotalTicks();
        gameState.resetTotalTicks();
        return oldTotalTicks;
    }

    public static void beginGame(PuppytronGameState newGameState) {
        gameState = newGameState;
        instance.setVisible(GAMEOVER, false);
        instance.open();
    }

    public static void initBackground() {
        boolean advance = false;
        Background newBackground = Background.getBackground(GameScreen.getLevel());
        if (newBackground != background) {
            if (background != null) {
                background.remove();
                oldBackgroundColor = background.getColor();
                background = null;
                backgroundFadePhase = 0;
            } else {
                advance = true;
                backgroundFadePhase = 2;
            }
            backgroundFadeTick = 0;
            background = newBackground;
            background.spawn(instance);
            if (advance) {
                background.advance();
            }
        }
    }

    static void initArena() {
        boolean advance = false;
        if (background != null) {
            background.remove();
            oldBackgroundColor = background.getColor();
            background = null;
            backgroundFadePhase = 0;
        } else {
            advance = true;
            backgroundFadePhase = 2;
        }
        backgroundFadeTick = 0;
        background = Background.getArena(GameScreen.getLevel() / 5 - 1);
        background.spawn(instance);
        if (advance) {
            background.advance();
        }
    }

    static void initLevel() {
        GidrahFeature.resetDifficulty();
        GameScreen.initBackground();
        gameState.setTick(0);
    }

    public static void gameOver() {
        instance.setVisible(GAMEOVER, true);
        Game.playMusic(null, (int)180);
        gameState.setPhase(5);
        gameState.setTick(0);
    }

    protected void doCleanup() {
        if (background != null) {
            background.cleanup();
            background = null;
        }
        this.shieldPowerInstance.cleanup();
        this.shieldPowerInstance = null;
        if (this.progressInstance != null) {
            this.progressInstance.cleanup();
            this.progressInstance = null;
        }
        if (this.hudRenderer != null) {
            this.hudRenderer.remove();
            this.hudRenderer = null;
        }
        if (this.backgroundRenderer != null) {
            this.backgroundRenderer.remove();
            this.backgroundRenderer = null;
        }
    }

    protected void doCreateScreen() {
        this.shieldsEmpty = this.getArea(SHIELDS_EMPTY);
        this.scoreLabel = new GLTextArea();
        this.scoreLabel.setFont(Res.getSmallFont());
        this.scoreLabel.setHorizontalAlignment(TextLayout.RIGHT);
        this.scoreLabel.setVerticalAlignment(GLTextArea.BOTTOM);
        this.bonusLabel = new GLTextArea();
        this.bonusLabel.setFont(Res.getSmallFont());
        this.bonusLabel.setVerticalAlignment(GLTextArea.BOTTOM);
        this.levelLabel = new GLTextArea();
        this.levelLabel.setHorizontalAlignment(TextLayout.RIGHT);
        this.levelLabel.setFont(Res.getSmallFont());
        this.levelLabel.setVerticalAlignment(GLTextArea.BOTTOM);
    }

    protected void onResized() {
        SPRITE_OFFSET.setLocation((this.getWidth() - Game.getScale()) / 2, (this.getHeight() - Game.getScale()) / 2);
        this.scoreBounds = this.getArea(SCORE_BOUNDS).getBounds();
        this.levelBounds = this.getArea(LEVEL_BOUNDS).getBounds();
        this.timerBounds = this.getArea(TIMER_BOUNDS).getBounds();
        this.bonusBounds = this.getArea(BONUS_BOUNDS).getBounds();
        this.scoreLabel.setBounds(this.scoreBounds);
        this.levelLabel.setBounds(this.levelBounds);
        this.bonusLabel.setBounds(this.bonusBounds);
        if (this.shieldPowerInstance != null) {
            this.shieldPowerInstance.onResized();
        }
        if (this.progressInstance != null) {
            this.progressInstance.onResized();
        }
        this.setConstrainMouse((ReadableRectangle)new Rectangle(0, 0, Game.getScale(), Game.getScale()));
    }

    public static Player getPlayer() {
        return gameState.getPlayer();
    }

    public static boolean isChallengeMode() {
        return gameState.getPhase() == 7 || gameState.getPhase() == 9 || gameState.getPhase() == 8;
    }

    static boolean isAssaultLevel() {
        return gameState.getLevel() % 5 == 0 && gameState.getLevel() % 10 != 0;
    }

    public static void addEntity(Entity entity) {
        instance.addTickable(entity);
        gameState.addEntity(entity);
    }

    public static GameScreen getInstance() {
        return instance;
    }

    public static void freezeGidrahs() {
        gameState.freezeGidrahs();
    }

    public static void shortFreezeGidrahs() {
        gameState.shortFreezeGidrahs();
    }

    public static Gidrah getRandomGidrah() {
        return gameState.getRandomGidrah();
    }

    public static void onExit() {
        if (instance != null && instance.isOpen()) {
            MiniGame.saveGame();
        }
    }

    protected void preRender() {
        if (this.isOpen()) {
            GL11.glScissor((int)((int)Game.logicalXtoPhysicalX((float)SPRITE_OFFSET.getX())), (int)((int)Game.logicalYtoPhysicalY((float)SPRITE_OFFSET.getY())), (int)((int)Game.logicalXtoPhysicalX((float)Game.getScale())), (int)((int)Game.logicalYtoPhysicalY((float)Game.getScale())));
            GL11.glEnable((int)3089);
        }
    }

    protected void postRender() {
        if (this.isOpen()) {
            GL11.glDisable((int)3089);
        }
    }

    public static ReadablePoint getSpriteOffset() {
        return SPRITE_OFFSET;
    }
}

