/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;

final class APIUtil {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private static final int INITIAL_LENGTHS_SIZE = 4;
    private static final int BUFFERS_SIZE = 32;
    private static final ThreadLocal<char[]> arrayTL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[256];
        }
    };
    private static final ThreadLocal<ByteBuffer> bufferTL = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return BufferUtils.createByteBuffer(256);
        }
    };
    private static final ThreadLocal<IntBuffer> lengthsTL = new ThreadLocal<IntBuffer>(){

        @Override
        protected IntBuffer initialValue() {
            return BufferUtils.createIntBuffer(4);
        }
    };
    private static final ThreadLocal<Buffers> buffersTL = new ThreadLocal<Buffers>(){

        @Override
        protected Buffers initialValue() {
            return new Buffers();
        }
    };

    private APIUtil() {
    }

    private static char[] getArray(int size) {
        char[] array = arrayTL.get();
        if (array.length < size) {
            int sizeNew = array.length << 1;
            while (sizeNew < size) {
                sizeNew <<= 1;
            }
            array = new char[size];
            arrayTL.set(array);
        }
        return array;
    }

    static ByteBuffer getBufferByte(int size) {
        ByteBuffer buffer = bufferTL.get();
        if (buffer.capacity() < size) {
            int sizeNew = buffer.capacity() << 1;
            while (sizeNew < size) {
                sizeNew <<= 1;
            }
            buffer = BufferUtils.createByteBuffer(size);
            bufferTL.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    private static ByteBuffer getBufferByteOffset(int size) {
        ByteBuffer buffer = bufferTL.get();
        if (buffer.capacity() < size) {
            int sizeNew = buffer.capacity() << 1;
            while (sizeNew < size) {
                sizeNew <<= 1;
            }
            ByteBuffer bufferNew = BufferUtils.createByteBuffer(size);
            bufferNew.put(buffer);
            buffer = bufferNew;
            bufferTL.set(buffer);
        } else {
            buffer.position(buffer.limit());
            buffer.limit(buffer.capacity());
        }
        return buffer;
    }

    static ShortBuffer getBufferShort() {
        return APIUtil.buffersTL.get().shorts;
    }

    static IntBuffer getBufferInt() {
        return APIUtil.buffersTL.get().ints;
    }

    static LongBuffer getBufferLong() {
        return APIUtil.buffersTL.get().longs;
    }

    static FloatBuffer getBufferFloat() {
        return APIUtil.buffersTL.get().floats;
    }

    static DoubleBuffer getBufferDouble() {
        return APIUtil.buffersTL.get().doubles;
    }

    static IntBuffer getLengths() {
        return APIUtil.getLengths(1);
    }

    static IntBuffer getLengths(int size) {
        IntBuffer lengths = lengthsTL.get();
        if (lengths.capacity() < size) {
            int sizeNew = lengths.capacity();
            while (sizeNew < size) {
                sizeNew <<= 1;
            }
            lengths = BufferUtils.createIntBuffer(size);
            lengthsTL.set(lengths);
        } else {
            lengths.clear();
        }
        return lengths;
    }

    private static ByteBuffer encode(ByteBuffer buffer, CharSequence string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (LWJGLUtil.DEBUG && '\u0080' <= c) {
                buffer.put((byte)26);
            } else {
                buffer.put((byte)c);
            }
            ++i;
        }
        return buffer;
    }

    static String getString(ByteBuffer buffer) {
        int length = buffer.remaining();
        char[] charArray = APIUtil.getArray(length);
        int i = buffer.position();
        while (i < buffer.limit()) {
            charArray[i - buffer.position()] = (char)buffer.get(i);
            ++i;
        }
        return new String(charArray, 0, length);
    }

    static ByteBuffer getBuffer(CharSequence string) {
        ByteBuffer buffer = APIUtil.encode(APIUtil.getBufferByte(string.length()), string);
        buffer.flip();
        return buffer;
    }

    static ByteBuffer getBuffer(CharSequence string, int offset) {
        ByteBuffer buffer = APIUtil.encode(APIUtil.getBufferByteOffset(offset + string.length()), string);
        buffer.flip();
        return buffer;
    }

    static ByteBuffer getBufferNT(CharSequence string) {
        ByteBuffer buffer = APIUtil.encode(APIUtil.getBufferByte(string.length() + 1), string);
        buffer.put((byte)0);
        buffer.flip();
        return buffer;
    }

    static int getTotalLength(CharSequence[] strings) {
        int length = 0;
        CharSequence[] charSequenceArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence string = charSequenceArray[n2];
            length += string.length();
            ++n2;
        }
        return length;
    }

    static ByteBuffer getBuffer(CharSequence[] strings) {
        ByteBuffer buffer = APIUtil.getBufferByte(APIUtil.getTotalLength(strings));
        CharSequence[] charSequenceArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence string = charSequenceArray[n2];
            APIUtil.encode(buffer, string);
            ++n2;
        }
        buffer.flip();
        return buffer;
    }

    static ByteBuffer getBufferNT(CharSequence[] strings) {
        ByteBuffer buffer = APIUtil.getBufferByte(APIUtil.getTotalLength(strings) + strings.length);
        CharSequence[] charSequenceArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence string = charSequenceArray[n2];
            APIUtil.encode(buffer, string);
            buffer.put((byte)0);
            ++n2;
        }
        buffer.flip();
        return buffer;
    }

    static IntBuffer getLengths(CharSequence[] strings) {
        IntBuffer buffer = APIUtil.getLengths(strings.length);
        CharSequence[] charSequenceArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence string = charSequenceArray[n2];
            buffer.put(string.length());
            ++n2;
        }
        buffer.flip();
        return buffer;
    }

    private static class Buffers {
        final ShortBuffer shorts = BufferUtils.createShortBuffer(32);
        final IntBuffer ints = BufferUtils.createIntBuffer(32);
        final LongBuffer longs = BufferUtils.createLongBuffer(32);
        final FloatBuffer floats = BufferUtils.createFloatBuffer(32);
        final DoubleBuffer doubles = BufferUtils.createDoubleBuffer(32);

        Buffers() {
        }
    }
}

