/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.eval;

import java.math.BigDecimal;
import net.java.dev.eval.Operator;

final class Tokeniser {
    static final Character START_NEW_EXPRESSION = new Character('(');
    private final String string;
    private int position;
    private Operator pushedBackOperator = null;

    Tokeniser(String string) {
        this.string = string;
        this.position = 0;
    }

    int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        this.position = position;
    }

    void pushBack(Operator operator) {
        this.pushedBackOperator = operator;
    }

    Operator getOperator(char endOfExpressionChar) {
        if (this.pushedBackOperator != null) {
            Operator operator = this.pushedBackOperator;
            this.pushedBackOperator = null;
            return operator;
        }
        int len = this.string.length();
        char ch = '\u0000';
        while (this.position < len && Character.isWhitespace(ch = this.string.charAt(this.position))) {
            ++this.position;
        }
        if (this.position == len) {
            if (endOfExpressionChar == '\u0000') {
                return Operator.END;
            }
            throw new RuntimeException("missing " + endOfExpressionChar);
        }
        ++this.position;
        if (ch == endOfExpressionChar) {
            return Operator.END;
        }
        switch (ch) {
            case '+': {
                return Operator.ADD;
            }
            case '-': {
                return Operator.SUB;
            }
            case '/': {
                return Operator.DIV;
            }
            case '%': {
                return Operator.REMAINDER;
            }
            case '*': {
                return Operator.MUL;
            }
            case '?': {
                return Operator.TERNARY;
            }
            case '>': {
                if (this.position < len && this.string.charAt(this.position) == '=') {
                    ++this.position;
                    return Operator.GE;
                }
                return Operator.GT;
            }
            case '<': {
                if (this.position < len) {
                    switch (this.string.charAt(this.position)) {
                        case '=': {
                            ++this.position;
                            return Operator.LE;
                        }
                        case '>': {
                            ++this.position;
                            return Operator.NE;
                        }
                    }
                }
                return Operator.LT;
            }
            case '=': {
                if (this.position < len && this.string.charAt(this.position) == '=') {
                    ++this.position;
                    return Operator.EQ;
                }
                throw new RuntimeException("use == for equality at position " + this.position);
            }
            case '!': {
                if (this.position < len && this.string.charAt(this.position) == '=') {
                    ++this.position;
                    return Operator.NE;
                }
                throw new RuntimeException("use != or <> for inequality at position " + this.position);
            }
            case '&': {
                if (this.position < len && this.string.charAt(this.position) == '&') {
                    ++this.position;
                    return Operator.AND;
                }
                throw new RuntimeException("use && for AND at position " + this.position);
            }
            case '|': {
                if (this.position < len && this.string.charAt(this.position) == '|') {
                    ++this.position;
                    return Operator.OR;
                }
                throw new RuntimeException("use || for OR at position " + this.position);
            }
        }
        if (Character.isUnicodeIdentifierStart(ch)) {
            int start = this.position - 1;
            while (this.position < len && Character.isUnicodeIdentifierPart(this.string.charAt(this.position))) {
                ++this.position;
            }
            String name = this.string.substring(start, this.position);
            if (name.equals("pow")) {
                return Operator.POW;
            }
        }
        throw new RuntimeException("operator expected at position " + this.position + " instead of '" + ch + "'");
    }

    Object getOperand() {
        int len = this.string.length();
        char ch = '\u0000';
        while (this.position < len && Character.isWhitespace(ch = this.string.charAt(this.position))) {
            ++this.position;
        }
        if (this.position == len) {
            throw new RuntimeException("operand expected but end of string found");
        }
        if (ch == '(') {
            ++this.position;
            return START_NEW_EXPRESSION;
        }
        if (ch == '-') {
            ++this.position;
            return Operator.NEG;
        }
        if (ch == '+') {
            ++this.position;
            return Operator.PLUS;
        }
        if (ch == '.' || Character.isDigit(ch)) {
            return this.getBigDecimal();
        }
        if (Character.isUnicodeIdentifierStart(ch) || ch == '$') {
            int start = this.position++;
            while (this.position < len && Character.isUnicodeIdentifierPart(this.string.charAt(this.position))) {
                ++this.position;
            }
            String name = this.string.substring(start, this.position);
            if (name.equals("abs")) {
                return Operator.ABS;
            }
            if (name.equals("int")) {
                return Operator.INT;
            }
            return name;
        }
        throw new RuntimeException("operand expected but '" + ch + "' found");
    }

    private BigDecimal getBigDecimal() {
        char ch;
        int len = this.string.length();
        int start = this.position;
        while (this.position < len && (Character.isDigit(ch = this.string.charAt(this.position)) || ch == '.')) {
            ++this.position;
        }
        if (this.position < len && ((ch = this.string.charAt(this.position)) == 'E' || ch == 'e')) {
            ++this.position;
            if (this.position < len && ((ch = this.string.charAt(this.position)) == '+' || ch == '-')) {
                ++this.position;
            }
            while (this.position < len && Character.isDigit(ch = this.string.charAt(this.position))) {
                ++this.position;
            }
        }
        return new BigDecimal(this.string.substring(start, this.position));
    }

    public String toString() {
        return String.valueOf(this.string.substring(0, this.position)) + ">>>" + this.string.substring(this.position);
    }
}

