/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoreImprovedStringTokenizer
implements Iterator<String> {
    private final String input;
    private final String delimiter;
    private int index;
    private final StringBuilder token;

    public MoreImprovedStringTokenizer(String input, String delimiter) {
        this.input = input;
        this.delimiter = delimiter;
        this.token = new StringBuilder(input.length());
    }

    public boolean hasMoreTokens() {
        return this.index < this.input.length();
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    @Override
    public String next() {
        return this.nextToken();
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        boolean inquotes = false;
        this.token.setLength(0);
        while (this.index < this.input.length()) {
            char c = this.input.charAt(this.index++);
            if (inquotes) {
                if (c == '\"') {
                    inquotes = false;
                    continue;
                }
                this.token.append(c);
                continue;
            }
            if (c == '\"') {
                inquotes = true;
                continue;
            }
            if (this.delimiter.indexOf(c) != -1) {
                return this.token.toString();
            }
            this.token.append(c);
        }
        return this.token.toString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

