/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovedStringTokenizer
implements Iterator<String> {
    private final String input;
    private int index;
    private final StringBuilder token;

    public ImprovedStringTokenizer(String input) {
        this.input = input;
        this.token = new StringBuilder(input.length());
        this.skipWhitespace();
    }

    public boolean hasMoreTokens() {
        return this.index < this.input.length();
    }

    @Override
    public boolean hasNext() {
        return this.hasMoreTokens();
    }

    @Override
    public String next() {
        return this.nextToken();
    }

    public String nextToken() {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        boolean inquotes = false;
        this.token.setLength(0);
        while (this.index < this.input.length()) {
            char c = this.input.charAt(this.index);
            if (inquotes) {
                if (c == '\"') {
                    inquotes = false;
                    ++this.index;
                    this.skipWhitespace();
                    return this.token.toString();
                }
                this.token.append(c);
            } else if (c == '\"') {
                inquotes = true;
            } else {
                if (Character.isWhitespace(c)) {
                    ++this.index;
                    this.skipWhitespace();
                    return this.token.toString();
                }
                this.token.append(c);
            }
            ++this.index;
        }
        return this.token.toString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void skipWhitespace() {
        while (this.index < this.input.length() && Character.isWhitespace(this.input.charAt(this.index))) {
            ++this.index;
        }
    }
}

