/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import com.shavenpuppy.jglib.util.DoubleParser;
import com.shavenpuppy.jglib.util.FloatParser;
import com.shavenpuppy.jglib.util.IntParser;
import com.shavenpuppy.jglib.util.MoreImprovedStringTokenizer;
import com.shavenpuppy.jglib.util.Parser;
import java.lang.reflect.Array;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayParser {
    private static void validate(String in) throws Exception {
        if (in.charAt(0) != '{') {
            throw new Exception("Array must start with {");
        }
        if (in.charAt(in.length() - 1) != '}') {
            throw new Exception("Array must end with }");
        }
    }

    public static <T> T[] parse(Parser<T> parser, Class<T> arrayType, String in) throws Exception {
        ArrayParser.validate(in);
        LinkedList<T> values = new LinkedList<T>();
        MoreImprovedStringTokenizer st = new MoreImprovedStringTokenizer(in.substring(1, in.length() - 1), ",");
        while (st.hasMoreTokens()) {
            T t = parser.parse(st.nextToken());
            values.add(t);
        }
        Object ret = Array.newInstance(arrayType, values.size());
        return values.toArray((Object[])ret);
    }

    public static int[] parseInts(String in) throws Exception {
        ArrayParser.validate(in);
        LinkedList<Integer> values = new LinkedList<Integer>();
        MoreImprovedStringTokenizer st = new MoreImprovedStringTokenizer(in.substring(1, in.length() - 1), ",");
        IntParser ip = new IntParser();
        while (st.hasMoreTokens()) {
            Integer t = ip.parse(st.nextToken().trim());
            values.add(t);
        }
        int[] ret = (int[])Array.newInstance(Integer.TYPE, values.size());
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Integer)values.get(i);
            ++i;
        }
        return ret;
    }

    public static float[] parseFloats(String in) throws Exception {
        ArrayParser.validate(in);
        LinkedList<Float> values = new LinkedList<Float>();
        MoreImprovedStringTokenizer st = new MoreImprovedStringTokenizer(in.substring(1, in.length() - 1), ",");
        FloatParser ip = new FloatParser();
        while (st.hasMoreTokens()) {
            Float t = ip.parse(st.nextToken().trim());
            values.add(t);
        }
        float[] ret = (float[])Array.newInstance(Float.TYPE, values.size());
        int i = 0;
        while (i < ret.length) {
            ret[i] = ((Float)values.get(i)).floatValue();
            ++i;
        }
        return ret;
    }

    public static double[] parseDoubles(String in) throws Exception {
        ArrayParser.validate(in);
        LinkedList<Double> values = new LinkedList<Double>();
        MoreImprovedStringTokenizer st = new MoreImprovedStringTokenizer(in.substring(1, in.length() - 1), ",");
        DoubleParser ip = new DoubleParser();
        while (st.hasMoreTokens()) {
            Double t = ip.parse(st.nextToken().trim());
            values.add(t);
        }
        double[] ret = (double[])Array.newInstance(Double.TYPE, values.size());
        int i = 0;
        while (i < ret.length) {
            ret[i] = (Double)values.get(i);
            ++i;
        }
        return ret;
    }
}

