/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.w3c.dom.Element;

public class ScaleCommand
extends Command {
    private static final long serialVersionUID = 1L;
    private float xdelta;
    private float ydelta;
    private boolean relativex;
    private boolean relativey;
    private int duration;

    public boolean execute(Sprite target) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            int newScaleX = this.relativex ? target.getXScale() + FPMath.fpValue(this.xdelta) : FPMath.fpValue(this.xdelta);
            int newScaleY = this.relativey ? target.getYScale() + FPMath.fpValue(this.ydelta) : FPMath.fpValue(this.ydelta);
            target.setScale(newScaleX, newScaleY);
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(++currentTick);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        String sdelta = XMLUtil.getString(element, "scale", "!");
        if (!sdelta.equals("!")) {
            if (sdelta.startsWith("+")) {
                this.relativex = true;
                this.relativey = true;
                this.xdelta = Float.parseFloat(sdelta.substring(1));
            } else {
                this.xdelta = Float.parseFloat(sdelta);
            }
            this.ydelta = this.xdelta;
        } else {
            String sxdelta = XMLUtil.getString(element, "xscale");
            if (sxdelta.startsWith("+")) {
                this.relativex = true;
                this.xdelta = Float.parseFloat(sxdelta.substring(1));
            } else {
                this.xdelta = Float.parseFloat(sxdelta);
            }
            String sydelta = XMLUtil.getString(element, "yscale");
            if (sydelta.startsWith("+")) {
                this.relativey = true;
                this.ydelta = Float.parseFloat(sydelta.substring(1));
            } else {
                this.ydelta = Float.parseFloat(sydelta);
            }
        }
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.xdelta == this.ydelta && this.relativex == this.relativey) {
            if (this.relativex) {
                writer.writeAttribute("scale", "+" + this.xdelta);
            } else {
                writer.writeAttribute("scale", this.xdelta, true);
            }
        } else {
            if (this.relativex) {
                writer.writeAttribute("x", "+" + this.xdelta);
            } else {
                writer.writeAttribute("x", this.xdelta, true);
            }
            if (this.relativey) {
                writer.writeAttribute("y", "+" + this.ydelta);
            } else {
                writer.writeAttribute("y", this.ydelta, true);
            }
        }
        writer.writeAttribute("d", this.duration, true);
    }

    protected void doCreate() {
    }

    protected void doDestroy() {
    }
}

