/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.lwjgl.util.vector.Vector3f;
import org.w3c.dom.Element;

public class OffsetCommand
extends Command {
    private static final long serialVersionUID = 1L;
    private static final Vector3f temp = new Vector3f();
    private float deltax;
    private float deltay;
    private boolean relativex;
    private boolean relativey;
    private int duration;

    public boolean execute(Sprite target) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            if (this.relativex) {
                target.getOffset(temp);
                if (this.relativey) {
                    temp.setX(temp.getX() + this.deltax);
                    temp.setY(temp.getY() + this.deltay);
                } else {
                    temp.setX(temp.getX() + this.deltax);
                    temp.setY(this.deltay);
                }
                target.setOffset(temp.getX(), temp.getY(), 0.0f);
            } else if (this.relativey) {
                target.getOffset(temp);
                temp.setX(this.deltax);
                temp.setY(temp.getY() + this.deltay);
                target.setOffset(temp.getX(), temp.getY(), 0.0f);
            } else {
                target.setOffset(this.deltax, this.deltay, 0.0f);
            }
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(++currentTick);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        String sx = XMLUtil.getString(element, "x");
        if (sx.startsWith("+")) {
            this.relativex = true;
            this.deltax = Float.parseFloat(sx.substring(1));
        } else {
            this.deltax = Float.parseFloat(sx);
        }
        String sy = XMLUtil.getString(element, "y");
        if (sy.startsWith("+")) {
            this.relativey = true;
            this.deltay = Float.parseFloat(sy.substring(1));
        } else {
            this.deltay = Float.parseFloat(sy);
        }
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.relativex) {
            writer.writeAttribute("x", "+" + this.deltax);
        } else {
            writer.writeAttribute("x", this.deltax, true);
        }
        if (this.relativey) {
            writer.writeAttribute("y", "+" + this.deltay);
        } else {
            writer.writeAttribute("y", this.deltay, true);
        }
        writer.writeAttribute("d", this.duration, true);
    }

    protected void doCreate() {
    }

    protected void doDestroy() {
    }
}

