/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Memory;
import com.shavenpuppy.jglib.MultiBuffer;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.algorithms.RadixSort;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.GLVertexBufferObject;
import com.shavenpuppy.jglib.sprites.AlphaOp;
import com.shavenpuppy.jglib.sprites.FlashStyle;
import com.shavenpuppy.jglib.sprites.GeometryData;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.SpriteRenderer;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.FloatList;
import com.shavenpuppy.jglib.util.ShortList;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.vector.Vector3f;

class DefaultSpriteRenderer
extends Resource
implements SpriteRenderer {
    private static final long serialVersionUID = 1L;
    private static final float PREMULT_ALPHA = 0.003921569f;
    private static final Vector3f offset = new Vector3f();
    private static RingBuffer ringBuffer;
    private final RadixSort sort = new RadixSort();
    private static final int NO_SCALE;
    private static final boolean DEBUG = true;
    private float alpha;
    private final boolean uniqueSprites;
    private int[] sort_z;
    private int[] sort_y;
    private int[] sort_x;
    private int[] sort_layer;
    private int[] sort_sublayer;
    private int[] sort_style;
    private int[] sort_texture0;
    private int[] sort_texture1;
    private final boolean sortY;
    private Sprite[] sprite;
    private Style[] style;
    private int numSprites;
    private int sortLayer;
    static final int VERTEX_SIZE = 32;
    static final int TEXTURE0_COORD_OFFSET = 12;
    static final int TEXTURE1_COORD_OFFSET = 20;
    static final int COLOR_OFFSET = 28;

    static {
        NO_SCALE = FPMath.ONE;
    }

    DefaultSpriteRenderer(boolean sortY, int sortLayer, boolean uniqueSprites) {
        this.sortY = sortY;
        this.sortLayer = sortLayer;
        this.uniqueSprites = uniqueSprites;
        this.sprite = new Sprite[1];
        if (uniqueSprites) {
            int i = 0;
            while (i < this.sprite.length) {
                this.sprite[i] = new Sprite(null);
                ++i;
            }
        }
        this.style = new Style[1];
        this.sort_layer = new int[1];
        this.sort_sublayer = new int[1];
        this.sort_texture0 = new int[1];
        this.sort_texture1 = new int[1];
        this.sort_style = new int[1];
        this.sort_z = new int[1];
        if (sortY) {
            this.sort_y = new int[1];
            this.sort_x = new int[1];
        } else {
            this.sort_y = null;
            this.sort_x = null;
        }
        this.sort.resetIndices();
    }

    protected void doCreate() {
        if (ringBuffer == null) {
            ringBuffer = new RingBuffer();
            ringBuffer.create();
        }
        if (FlashStyle.instance == null) {
            FlashStyle.instance = new FlashStyle("flash.style");
            FlashStyle.instance.create();
        }
    }

    protected void doDestroy() {
    }

    public void render(Sprite s) {
        if (!s.isVisible()) {
            return;
        }
        SpriteImage image = s.getImage();
        Style spriteStyle = s.getStyle();
        if (image == null && spriteStyle == null) {
            return;
        }
        if (s.isFlashing() && GLContext.getCapabilities().GL_EXT_secondary_color) {
            this.addSprite(FlashStyle.instance, s);
        } else {
            this.addSprite(spriteStyle, s);
        }
    }

    private void addSprite(Style spriteStyle, Sprite s) {
        if (this.numSprites == this.sprite.length) {
            int[] old_sort_z = this.sort_z;
            this.sort_z = new int[this.numSprites * 2];
            System.arraycopy(old_sort_z, 0, this.sort_z, 0, this.numSprites);
            old_sort_z = null;
            if (this.sortY) {
                int[] old_sort_y = this.sort_y;
                this.sort_y = new int[this.numSprites * 2];
                System.arraycopy(old_sort_y, 0, this.sort_y, 0, this.numSprites);
                old_sort_y = null;
                int[] old_sort_x = this.sort_x;
                this.sort_x = new int[this.numSprites * 2];
                System.arraycopy(old_sort_x, 0, this.sort_x, 0, this.numSprites);
                old_sort_x = null;
            }
            int[] old_sort_layer = this.sort_layer;
            this.sort_layer = new int[this.numSprites * 2];
            System.arraycopy(old_sort_layer, 0, this.sort_layer, 0, this.numSprites);
            old_sort_layer = null;
            int[] old_sort_sublayer = this.sort_sublayer;
            this.sort_sublayer = new int[this.numSprites * 2];
            System.arraycopy(old_sort_sublayer, 0, this.sort_sublayer, 0, this.numSprites);
            old_sort_sublayer = null;
            int[] old_sort_style = this.sort_style;
            this.sort_style = new int[this.numSprites * 2];
            System.arraycopy(old_sort_style, 0, this.sort_style, 0, this.numSprites);
            old_sort_style = null;
            int[] old_sort_texture0 = this.sort_texture0;
            this.sort_texture0 = new int[this.numSprites * 2];
            System.arraycopy(old_sort_texture0, 0, this.sort_texture0, 0, this.numSprites);
            old_sort_texture0 = null;
            int[] old_sort_texture1 = this.sort_texture1;
            this.sort_texture1 = new int[this.numSprites * 2];
            System.arraycopy(old_sort_texture1, 0, this.sort_texture1, 0, this.numSprites);
            old_sort_z = null;
            Sprite[] old_sprite = this.sprite;
            this.sprite = new Sprite[this.numSprites * 2];
            System.arraycopy(old_sprite, 0, this.sprite, 0, this.numSprites);
            old_sprite = null;
            Style[] old_style = this.style;
            this.style = new Style[this.numSprites * 2];
            System.arraycopy(old_style, 0, this.style, 0, this.numSprites);
            old_style = null;
        }
        this.style[this.numSprites] = spriteStyle;
        if (this.uniqueSprites) {
            Sprite copy = this.sprite[this.numSprites];
            if (copy == null) {
                copy = this.sprite[this.numSprites] = new Sprite(null);
            }
            copy.copy(s);
        } else {
            this.sprite[this.numSprites] = s;
        }
        ++this.numSprites;
    }

    public void postRender() {
        if (this.numSprites == 0) {
            return;
        }
        this.sort();
        ringBuffer.begin();
        this.build();
        ringBuffer.finish();
    }

    private void build() {
        int[] index = this.sort.getIndices();
        int i = 0;
        while (i < this.numSprites) {
            int idx = index[i];
            Sprite s = this.sprite[idx];
            if (s.isVisible()) {
                Style newStyle = this.style[idx];
                if (newStyle.getRenderSprite()) {
                    ringBuffer.add(s, newStyle, this.alpha);
                } else {
                    ringBuffer.add(newStyle);
                }
            }
            ++i;
        }
    }

    public void preRender() {
        this.numSprites = 0;
    }

    private void sort() {
        int n = this.numSprites;
        if (this.sortY) {
            int i = 0;
            while (i < n) {
                Sprite s = this.sprite[i];
                if (s.isVisible()) {
                    this.sort_x[i] = (int)s.getX();
                    this.sort_layer[i] = s.getLayer();
                    this.sort_sublayer[i] = s.getSubLayer();
                    this.sort_style[i] = this.style[i].getStyleID();
                    if (s.getStyle().getRenderSprite()) {
                        SpriteImage si = s.getImage();
                        GLBaseTexture tex = si.getTexture();
                        this.sort_texture0[i] = tex == null ? 0 : tex.getID();
                        GLBaseTexture t1 = s.getTexture();
                        this.sort_texture1[i] = t1 != null ? t1.getID() : -1;
                        this.sort_y[i] = s.getLayer() >= this.sortLayer ? 0 : (int)(-(s.getY() + s.getYSortOffset()));
                    } else {
                        this.sort_texture0[i] = 0;
                        this.sort_texture1[i] = -1;
                        this.sort_y[i] = 0;
                    }
                }
                ++i;
            }
            this.sort.resetIndices().sort(this.sort_style, n).sort(this.sort_texture0, n).sort(this.sort_texture1, n).sort(this.sort_x, n).sort(this.sort_sublayer, n).sort(this.sort_y, n).sort(this.sort_layer, n);
        } else {
            int i = 0;
            while (i < n) {
                Sprite s = this.sprite[i];
                if (s.isVisible()) {
                    this.sort_z[i] = (int)s.getZ();
                    this.sort_layer[i] = s.getLayer();
                    this.sort_sublayer[i] = s.getSubLayer();
                    this.sort_style[i] = this.style[i].getStyleID();
                    if (s.getStyle().getRenderSprite()) {
                        SpriteImage si = s.getImage();
                        GLBaseTexture tex = si.getTexture();
                        this.sort_texture0[i] = tex == null ? 0 : tex.getID();
                        GLBaseTexture t1 = s.getTexture();
                        this.sort_texture1[i] = t1 != null ? t1.getID() : -1;
                    } else {
                        this.sort_texture0[i] = 0;
                        this.sort_texture1[i] = -1;
                    }
                }
                ++i;
            }
            this.sort.resetIndices().sort(this.sort_style, n).sort(this.sort_texture0, n).sort(this.sort_texture1, n).sort(this.sort_sublayer, n).sort(this.sort_z, n).sort(this.sort_layer, n);
        }
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    private static class RingBuffer {
        private static final int DEFAULT_STATE_RUNS = 1024;
        int bufferSize;
        int bufferSizeInVertices;
        int indexBufferSize;
        int numBuffers;
        boolean useVBOs;
        GLVertexBufferObject[] vbo;
        GLVertexBufferObject[] ibo;
        MultiBuffer[] buffer;
        MultiBuffer[] indices;
        int sequence = -1;
        int mark = -1;
        MultiBuffer currentVertices;
        MultiBuffer currentIndices;
        StateRun[] stateRun;
        GLBaseTexture lastRenderedTexture0;
        GLBaseTexture lastRenderedTexture1;
        GLBaseTexture currentTexture0;
        GLBaseTexture currentTexture1;
        Style lastRenderedStyle;
        Style currentStyle;
        int vertexCursor;
        int indexCursor;
        int numRuns;
        StateRun currentRun;

        RingBuffer() {
        }

        void create() {
            int i;
            this.useVBOs = GLContext.getCapabilities().GL_ARB_vertex_buffer_object;
            if (this.useVBOs) {
                this.bufferSize = 262144;
                this.bufferSizeInVertices = this.bufferSize / 32;
                this.numBuffers = 32;
            } else {
                this.bufferSize = 0x400000;
                this.bufferSizeInVertices = this.bufferSize / 32;
                this.numBuffers = 2;
            }
            this.indexBufferSize = this.bufferSizeInVertices * 3;
            this.buffer = new MultiBuffer[this.numBuffers];
            this.indices = new MultiBuffer[this.numBuffers];
            if (this.useVBOs) {
                this.vbo = new GLVertexBufferObject[this.numBuffers];
                this.ibo = new GLVertexBufferObject[this.numBuffers];
                i = 0;
                while (i < this.numBuffers) {
                    this.vbo[i] = new GLVertexBufferObject(this.bufferSize, 34962, 35040);
                    this.vbo[i].create();
                    this.ibo[i] = new GLVertexBufferObject(this.indexBufferSize * 2, 34963, 35040);
                    this.ibo[i].create();
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.numBuffers) {
                    this.buffer[i] = new MultiBuffer(this.bufferSize);
                    this.indices[i] = new MultiBuffer(this.indexBufferSize * 2);
                    ++i;
                }
            }
            this.stateRun = new StateRun[1024];
            i = 0;
            while (i < this.stateRun.length) {
                this.stateRun[i] = new StateRun();
                ++i;
            }
        }

        private void next() {
            ++this.sequence;
            if (this.sequence == this.numBuffers) {
                this.sequence = 0;
            }
            if (this.sequence == this.mark) {
                System.out.println("Buffer overrun");
            }
            if (this.useVBOs) {
                this.vbo[this.sequence].render();
                this.ibo[this.sequence].render();
                ByteBuffer buf = this.vbo[this.sequence].map();
                if (this.buffer[this.sequence] == null || this.buffer[this.sequence].bytes != buf) {
                    this.buffer[this.sequence] = new MultiBuffer(buf);
                }
                ByteBuffer ibuf = this.ibo[this.sequence].map();
                if (this.indices[this.sequence] == null || this.indices[this.sequence].bytes != ibuf) {
                    this.indices[this.sequence] = new MultiBuffer(ibuf);
                }
            }
            this.currentVertices = this.buffer[this.sequence];
            this.currentVertices.bytes.clear();
            this.currentVertices.floats.clear();
            this.currentVertices.ints.clear();
            this.currentIndices = this.indices[this.sequence];
            this.currentIndices.shorts.clear();
            ContextCapabilities capabilities = GLContext.getCapabilities();
            if (this.useVBOs) {
                GL11.glVertexPointer((int)3, (int)5126, (int)32, (long)0L);
                if (capabilities.GL_ARB_multitexture) {
                    ARBMultitexture.glClientActiveTextureARB((int)33985);
                    GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)20L);
                    ARBMultitexture.glClientActiveTextureARB((int)33984);
                } else if (capabilities.OpenGL13) {
                    GL13.glClientActiveTexture((int)33985);
                    GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)20L);
                    GL13.glClientActiveTexture((int)33985);
                }
                GL11.glTexCoordPointer((int)2, (int)5126, (int)32, (long)12L);
                GL11.glColorPointer((int)4, (int)5121, (int)32, (long)28L);
            } else {
                GL11.glVertexPointer((int)3, (int)32, (FloatBuffer)this.currentVertices.floats);
                if (capabilities.GL_ARB_multitexture) {
                    ARBMultitexture.glClientActiveTextureARB((int)33985);
                    GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)Memory.chop(this.currentVertices.bytes, 20).asFloatBuffer());
                    ARBMultitexture.glClientActiveTextureARB((int)33984);
                } else if (capabilities.OpenGL13) {
                    GL13.glClientActiveTexture((int)33985);
                    GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)Memory.chop(this.currentVertices.bytes, 20).asFloatBuffer());
                    GL13.glClientActiveTexture((int)33985);
                }
                GL11.glTexCoordPointer((int)2, (int)32, (FloatBuffer)Memory.chop(this.currentVertices.bytes, 12).asFloatBuffer());
                GL11.glColorPointer((int)4, (boolean)true, (int)32, (ByteBuffer)Memory.chop(this.currentVertices.bytes, 28));
            }
            this.vertexCursor = 0;
            this.indexCursor = 0;
            this.numRuns = 0;
            this.currentRun = null;
        }

        void begin() {
            this.currentStyle = null;
            this.currentTexture0 = null;
            this.currentTexture1 = null;
            this.next();
            this.mark = this.sequence;
            GL11.glEnableClientState((int)32884);
        }

        void finish() {
            this.render();
            if (this.useVBOs) {
                ARBBufferObject.glBindBufferARB((int)34962, (int)0);
                ARBBufferObject.glBindBufferARB((int)34963, (int)0);
            }
        }

        void growStateRuns() {
            StateRun[] newStateRun = new StateRun[(int)((float)this.stateRun.length * 1.5f)];
            System.arraycopy(this.stateRun, 0, newStateRun, 0, this.stateRun.length);
            int i = this.numRuns;
            while (i < newStateRun.length) {
                newStateRun[i] = new StateRun();
                ++i;
            }
            this.stateRun = newStateRun;
        }

        void add(Sprite s, Style newStyle, float engineAlpha) {
            float scaledy01;
            float scaledy11;
            float scaledy10;
            float scaledy00;
            float scaledx01;
            float scaledx11;
            float scaledx10;
            float scaledx00;
            SpriteImage image;
            if (this.vertexCursor + 4 > this.bufferSizeInVertices || this.indexCursor + 6 > this.indexBufferSize) {
                this.render();
                this.next();
            }
            GLBaseTexture newTexture0 = (image = s.getImage()) != null ? image.getTexture() : null;
            GLBaseTexture newTexture1 = s.getTexture();
            if (this.currentRun == null || newStyle != this.currentStyle && (this.currentStyle == null || newStyle.getStyleID() != this.currentStyle.getStyleID()) || newTexture0 != this.currentTexture0 || newTexture1 != this.currentTexture1) {
                this.currentRun = this.stateRun[this.numRuns];
                this.currentRun.start = this.vertexCursor;
                this.currentRun.length = 0;
                this.currentRun.style = newStyle;
                this.currentRun.texture0 = newTexture0;
                this.currentRun.texture1 = newTexture1;
                this.currentRun.indices = this.currentIndices.shorts;
                this.currentRun.startIndex = this.indexCursor;
                this.currentRun.endIndex = this.indexCursor;
                ++this.numRuns;
                if (this.numRuns == this.stateRun.length) {
                    this.growStateRuns();
                }
                this.currentStyle = newStyle;
                this.currentTexture0 = newTexture0;
                this.currentTexture1 = newTexture1;
            }
            float w = image.getWidth();
            float h = image.getHeight();
            float tx0 = image.getTx0();
            float tx1 = image.getTx1();
            float ty0 = image.getTy0();
            float ty1 = image.getTy1();
            int xscale = s.getXScale();
            int yscale = s.getYScale();
            s.getOffset(offset);
            float x = s.getX() + offset.getX();
            float y = s.getY() + offset.getY();
            float z = s.getZ() + offset.getZ();
            int alpha = (int)(engineAlpha * (float)s.getAlpha());
            double angle = FPMath.doubleValue(s.getAngle()) * Math.PI * 2.0;
            float scaledx0 = -image.getHotspotX();
            float scaledy0 = -image.getHotspotY();
            float scaledx1 = scaledx0 + w;
            float scaledy1 = scaledy0 + h;
            if (xscale != NO_SCALE || yscale != NO_SCALE) {
                float fxScale = FPMath.floatValue(xscale);
                float fyScale = FPMath.floatValue(yscale);
                scaledx0 *= fxScale;
                scaledx1 *= fxScale;
                scaledy0 *= fyScale;
                scaledy1 *= fyScale;
            }
            if (angle != 0.0) {
                double cos = Math.cos(angle);
                double sin = Math.sin(angle);
                scaledx00 = (float)(cos * (double)scaledx0 - sin * (double)scaledy0);
                scaledx10 = (float)(cos * (double)scaledx1 - sin * (double)scaledy0);
                scaledx11 = (float)(cos * (double)scaledx1 - sin * (double)scaledy1);
                scaledx01 = (float)(cos * (double)scaledx0 - sin * (double)scaledy1);
                scaledy00 = (float)(sin * (double)scaledx0 + cos * (double)scaledy0);
                scaledy10 = (float)(sin * (double)scaledx1 + cos * (double)scaledy0);
                scaledy11 = (float)(sin * (double)scaledx1 + cos * (double)scaledy1);
                scaledy01 = (float)(sin * (double)scaledx0 + cos * (double)scaledy1);
            } else {
                scaledx00 = scaledx0;
                scaledx10 = scaledx1;
                scaledx11 = scaledx1;
                scaledx01 = scaledx0;
                scaledy00 = scaledy0;
                scaledy10 = scaledy0;
                scaledy11 = scaledy1;
                scaledy01 = scaledy1;
            }
            float x00 = scaledx00 + x;
            float x01 = scaledx01 + x;
            float x11 = scaledx11 + x;
            float x10 = scaledx10 + x;
            float y00 = scaledy00 + y;
            float y01 = scaledy01 + y;
            float y11 = scaledy11 + y;
            float y10 = scaledy10 + y;
            AlphaOp alphaOp = newStyle.getAlphaOp();
            if (alphaOp == null) {
                throw new RuntimeException(newStyle + " as no alpha op");
            }
            FloatBuffer floats = this.currentVertices.floats;
            IntBuffer ints = this.currentVertices.ints;
            int vertex = this.vertexCursor * 32;
            floats.position(vertex >> 2);
            ints.position(vertex + 28 >> 2);
            floats.put(x00);
            floats.put(y00);
            floats.put(z);
            floats.put(s.isMirrored() ? tx1 : tx0);
            floats.put(s.isFlipped() ? ty0 : ty1);
            floats.put(s.getTx00());
            floats.put(s.getTy00());
            ReadableColor color = s.getColor(0);
            alphaOp.op(color, alpha, ints);
            floats.position((vertex += 32) >> 2);
            ints.position(vertex + 28 >> 2);
            floats.put(x10);
            floats.put(y10);
            floats.put(z);
            floats.put(s.isMirrored() ? tx0 : tx1);
            floats.put(s.isFlipped() ? ty0 : ty1);
            floats.put(s.getTx10());
            floats.put(s.getTy10());
            color = s.getColor(1);
            alphaOp.op(color, alpha, ints);
            floats.position((vertex += 32) >> 2);
            ints.position(vertex + 28 >> 2);
            floats.put(x11);
            floats.put(y11);
            floats.put(z);
            floats.put(s.isMirrored() ? tx0 : tx1);
            floats.put(s.isFlipped() ? ty1 : ty0);
            floats.put(s.getTx11());
            floats.put(s.getTy11());
            color = s.getColor(2);
            alphaOp.op(color, alpha, ints);
            floats.position((vertex += 32) >> 2);
            ints.position(vertex + 28 >> 2);
            floats.put(x01);
            floats.put(y01);
            floats.put(z);
            floats.put(s.isMirrored() ? tx1 : tx0);
            floats.put(s.isFlipped() ? ty1 : ty0);
            floats.put(s.getTx01());
            floats.put(s.getTy01());
            color = s.getColor(3);
            alphaOp.op(color, alpha, ints);
            this.currentIndices.shorts.position(this.indexCursor);
            this.currentIndices.shorts.put((short)this.vertexCursor);
            this.currentIndices.shorts.put((short)(this.vertexCursor + 1));
            this.currentIndices.shorts.put((short)(this.vertexCursor + 2));
            this.currentIndices.shorts.put((short)this.vertexCursor);
            this.currentIndices.shorts.put((short)(this.vertexCursor + 2));
            this.currentIndices.shorts.put((short)(this.vertexCursor + 3));
            this.indexCursor += 6;
            this.vertexCursor += 4;
            this.currentRun.endIndex += 6;
            this.currentRun.length += 4;
        }

        void add(Style s) {
            GeometryData data = s.build();
            FloatList vertexData = data.getVertexData();
            ShortList indexData = data.getIndexData();
            int vertsToWrite = vertexData.size() >> 3;
            if (this.vertexCursor + vertsToWrite > this.bufferSizeInVertices) {
                this.render();
                this.next();
            }
            this.currentRun = this.stateRun[this.numRuns];
            this.currentRun.start = this.vertexCursor;
            this.currentRun.length = vertsToWrite;
            this.currentRun.style = s;
            this.currentRun.texture0 = null;
            this.currentRun.texture1 = null;
            this.currentRun.startIndex = this.indexCursor;
            ++this.numRuns;
            if (this.numRuns == this.stateRun.length) {
                this.growStateRuns();
            }
            this.currentVertices.floats.position(this.vertexCursor * 32 >> 2);
            this.currentVertices.floats.put(vertexData.array(), 0, vertexData.size());
            this.currentIndices.shorts.position(this.indexCursor);
            short[] idx = indexData.array();
            int indicesToWrite = indexData.size();
            int i = 0;
            while (i < indicesToWrite) {
                int n = i++;
                idx[n] = (short)(idx[n] + this.vertexCursor);
            }
            this.currentIndices.shorts.put(idx, 0, indicesToWrite);
            this.vertexCursor += vertsToWrite;
            this.indexCursor += indicesToWrite;
            this.currentStyle = null;
            this.currentTexture0 = null;
            this.currentTexture1 = null;
        }

        void render() {
            if (this.useVBOs) {
                this.vbo[this.sequence].unmap();
                this.ibo[this.sequence].unmap();
            }
            this.lastRenderedStyle = null;
            this.lastRenderedTexture0 = null;
            this.lastRenderedTexture1 = null;
            int i = 0;
            while (i < this.numRuns) {
                this.stateRun[i].render();
                ++i;
            }
            if (this.lastRenderedStyle != null) {
                this.lastRenderedStyle.resetState();
            }
        }

        private class StateRun {
            GLBaseTexture texture0;
            GLBaseTexture texture1;
            Style style;
            int start;
            int length;
            ShortBuffer indices;
            int startIndex;
            int endIndex;

            private StateRun() {
            }

            void render() {
                if (this.style != RingBuffer.this.lastRenderedStyle) {
                    if (RingBuffer.this.lastRenderedStyle != null) {
                        RingBuffer.this.lastRenderedStyle.resetState();
                    }
                    if (this.style != null) {
                        this.style.setupState();
                    }
                    RingBuffer.this.lastRenderedStyle = this.style;
                }
                if (this.texture0 != RingBuffer.this.lastRenderedTexture0) {
                    if (this.texture0 != null) {
                        this.texture0.render();
                    }
                    RingBuffer.this.lastRenderedTexture0 = this.texture0;
                }
                if (this.texture1 != RingBuffer.this.lastRenderedTexture1) {
                    if (this.texture1 != null) {
                        this.texture1.render();
                    }
                    RingBuffer.this.lastRenderedTexture1 = this.texture1;
                }
                if (this.length == 0) {
                    return;
                }
                if (this.style.getRenderSprite()) {
                    if (RingBuffer.this.useVBOs) {
                        GL12.glDrawRangeElements((int)4, (int)this.start, (int)(this.start + this.length), (int)(this.endIndex - this.startIndex), (int)5123, (long)(this.startIndex * 2));
                    } else {
                        this.indices.limit(this.endIndex).position(this.startIndex);
                        GL12.glDrawRangeElements((int)4, (int)this.start, (int)(this.start + this.length), (ShortBuffer)this.indices);
                    }
                } else {
                    this.style.render(this.start, this.startIndex);
                }
            }
        }
    }
}

