/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.w3c.dom.Element;

public class AnimColorCommand
extends Command {
    private static final long serialVersionUID = 1L;
    private int red;
    private int green;
    private int blue;
    private int alpha;
    private boolean deltaRed;
    private boolean deltaGreen;
    private boolean deltaBlue;
    private boolean deltaAlpha;
    private int duration;

    public boolean execute(Sprite target) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            this.adjust(target, 0);
            this.adjust(target, 1);
            this.adjust(target, 2);
            this.adjust(target, 3);
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(++currentTick);
        return false;
    }

    private void adjust(Sprite colored, int index) {
        ReadableColor c = colored.getColor(index);
        Color newC = new Color(this.deltaRed ? Math.min(255, Math.max(0, c.getRed() + this.red)) : this.red, this.deltaGreen ? Math.min(255, Math.max(0, c.getGreen() + this.green)) : this.green, this.deltaBlue ? Math.min(255, Math.max(0, c.getBlue() + this.blue)) : this.blue, this.deltaAlpha ? Math.min(255, Math.max(0, c.getAlpha() + this.alpha)) : this.alpha);
        colored.setColor(index, (ReadableColor)newC);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        String redS = XMLUtil.getString(element, "r", "+0");
        if (redS.startsWith("+")) {
            this.deltaRed = true;
            this.red = Integer.parseInt(redS.substring(1));
        } else {
            this.red = Integer.parseInt(redS);
        }
        String greenS = XMLUtil.getString(element, "g", "+0");
        if (greenS.startsWith("+")) {
            this.deltaGreen = true;
            this.green = Integer.parseInt(greenS.substring(1));
        } else {
            this.green = Integer.parseInt(greenS);
        }
        String blueS = XMLUtil.getString(element, "b", "+0");
        if (blueS.startsWith("+")) {
            this.deltaBlue = true;
            this.blue = Integer.parseInt(blueS.substring(1));
        } else {
            this.blue = Integer.parseInt(blueS);
        }
        String alphaS = XMLUtil.getString(element, "a", "+0");
        if (alphaS.startsWith("+")) {
            this.deltaAlpha = true;
            this.alpha = Integer.parseInt(alphaS.substring(1));
        } else {
            this.alpha = Integer.parseInt(alphaS);
        }
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.deltaRed) {
            writer.writeAttribute("r", "+" + this.red);
        } else {
            writer.writeAttribute("r", this.red, true);
        }
        if (this.deltaGreen) {
            writer.writeAttribute("g", "+" + this.green);
        } else {
            writer.writeAttribute("g", this.green, true);
        }
        if (this.deltaBlue) {
            writer.writeAttribute("b", "+" + this.blue);
        } else {
            writer.writeAttribute("b", this.blue, true);
        }
        if (this.deltaAlpha) {
            writer.writeAttribute("a", "+" + this.alpha);
        } else {
            writer.writeAttribute("a", this.alpha, true);
        }
        writer.writeAttribute("d", this.duration, true);
    }
}

