/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.w3c.dom.Element;

public class AngleCommand
extends Command {
    private static final long serialVersionUID = 1L;
    private int delta;
    private boolean relative;
    private int duration;

    public boolean execute(Sprite target) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            if (this.relative) {
                target.adjustAngle(this.delta);
            } else {
                target.setAngle(this.delta);
            }
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(++currentTick);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        String sdelta = XMLUtil.getString(element, "angle");
        if (sdelta.startsWith("+")) {
            this.relative = true;
            this.delta = Integer.parseInt(sdelta.substring(1));
        } else {
            this.delta = Integer.parseInt(sdelta);
        }
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.relative) {
            writer.writeAttribute("angle", "+" + this.delta);
        } else {
            writer.writeAttribute("angle", this.delta, true);
        }
        writer.writeAttribute("d", this.duration, true);
    }

    protected void doCreate() {
    }

    protected void doDestroy() {
    }
}

