/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Wave;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.WaveWrapper;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.w3c.dom.Element;

public class WaveResource
extends Resource
implements WaveWrapper {
    private static final long serialVersionUID = 1L;
    private String url;
    private transient Wave wave;
    private transient int frequency;
    private transient int type;

    public WaveResource(String name) {
        super(name);
    }

    protected void doCreate() {
    }

    protected void doDestroy() {
        this.wave = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        this.url = element.getAttribute("url");
    }

    public final Wave getWave() throws Exception {
        assert (this.isCreated());
        if (this.wave == null || this.wave.getData() == null) {
            this.wave = Wave.read(this.getStream());
        }
        return this.wave;
    }

    public InputStream getStream() throws Exception {
        BufferedInputStream bis = this.url.startsWith("classpath:") ? new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10)), 128000) : new BufferedInputStream(new URL(this.url).openStream(), 128000);
        return bis;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getType() {
        return this.type;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeAttribute("url", this.url);
    }
}

