/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.IResource;
import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.Data;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;

public abstract class Feature
extends Resource {
    private static final long serialVersionUID = 1L;
    private static final List<Feature> FEATURES = new ArrayList<Feature>();
    private boolean autoCreated;
    private String inherit;
    private transient Feature inheritFeature;

    public Feature() {
    }

    public Feature(String name) {
        super(name);
    }

    public static void autoCreate() throws Exception {
        for (Feature feature : FEATURES) {
            if (!feature.autoCreated) continue;
            feature.create();
        }
        for (IResource resource : Resources.list()) {
            if (!resource.isCreated()) continue;
            resource.archive();
        }
        System.gc();
    }

    public void archive() {
        this.clearStrings();
    }

    protected final void setAutoCreated() {
        this.autoCreated = true;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.autoCreated = XMLUtil.getBoolean(element, "autoCreated", this.autoCreated);
        XMLUtil.grabXMLAttributes(loader, this, Feature.class, element);
    }

    private void clearStrings() {
        Class<?> clazz = this.getClass();
        while (Feature.class.isAssignableFrom(clazz)) {
            Field[] fields = clazz.getDeclaredFields();
            ArrayList<Field> sortedStringFields = new ArrayList<Field>(fields.length / 2 + 1);
            ArrayList<Field> sortedResourceFields = new ArrayList<Field>(fields.length / 2 + 1);
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                String fieldName = f.getName().toLowerCase();
                if (!(fieldName.equals("name") || fieldName.equals("class") || fieldName.equals("autoCreated") || fieldName.equals("inherit"))) {
                    f.setAccessible(true);
                    int modifiers = f.getModifiers();
                    if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && f.getAnnotation(Data.class) == null) {
                        if (!Modifier.isTransient(modifiers) && f.getType() == String.class) {
                            sortedStringFields.add(f);
                        } else if (Modifier.isTransient(modifiers) && IResource.class.isAssignableFrom(f.getType())) {
                            sortedResourceFields.add(f);
                        }
                    }
                }
                ++i;
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LengthSorter
            implements Comparator<Field> {
                LengthSorter() {
                }

                @Override
                public int compare(Field fa, Field fb) {
                    int fbl;
                    int fal = fa.getName().length();
                    if (fal > (fbl = fb.getName().length())) {
                        return -1;
                    }
                    if (fal < fbl) {
                        return 1;
                    }
                    return 0;
                }
            }
            LengthSorter sorter = new LengthSorter();
            Collections.sort(sortedStringFields, sorter);
            Collections.sort(sortedResourceFields, sorter);
            block4: for (Field stringField : sortedStringFields) {
                Iterator j = sortedResourceFields.iterator();
                while (j.hasNext()) {
                    Field resourceField = (Field)j.next();
                    if (!resourceField.getName().startsWith(stringField.getName())) continue;
                    resourceField.setAccessible(true);
                    try {
                        String resourceName = (String)stringField.get(this);
                        if (resourceName != null && Resources.exists(resourceName)) {
                            Object r = Resources.peek(resourceName);
                            if (!resourceField.getType().isAssignableFrom(r.getClass())) continue block4;
                            stringField.set(this, null);
                            continue block4;
                        }
                        j.remove();
                        continue block4;
                    }
                    catch (Exception e) {
                        assert (false) : "Should never happen: " + e;
                        continue block4;
                    }
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void defaultCreation() throws Exception {
        Field f;
        Field[] fields;
        Class<?> clazz;
        if (this.inherit != null && this.inheritFeature == null) {
            this.inheritFeature = (Feature)Resources.get(this.inherit);
            if (this.inheritFeature == null) {
                throw new Exception(this + " (a " + this.getClass().getName() + ") cannot inherit " + this.inherit + " as it doesn't exist");
            }
            if (!this.inheritFeature.getClass().isAssignableFrom(this.getClass())) {
                throw new Exception(this + " (a " + this.getClass().getName() + ") cannot inherit " + this.inherit + " (a " + this.inheritFeature.getClass().getName() + ")");
            }
            clazz = this.getClass();
            while (Feature.class.isAssignableFrom(clazz)) {
                fields = clazz.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    f = fields[i];
                    String fieldName = f.getName().toLowerCase();
                    if (!(fieldName.equals("name") || fieldName.equals("class") || fieldName.equals("autoCreated") || fieldName.equals("inherit"))) {
                        Object inheritedValue;
                        f.setAccessible(true);
                        int modifiers = f.getModifiers();
                        if (!(Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || (inheritedValue = f.get(this.inheritFeature)) == null)) {
                            Object currentValue = f.get(this);
                            if (currentValue != null) {
                                if (f.getType().isPrimitive() && (currentValue.equals(Boolean.FALSE) || currentValue instanceof Number && ((Number)currentValue).doubleValue() == 0.0)) {
                                    f.set(this, inheritedValue);
                                }
                            } else {
                                f.set(this, inheritedValue);
                            }
                        }
                    }
                    ++i;
                }
                clazz = clazz.getSuperclass();
            }
        }
        clazz = this.getClass();
        while (Feature.class.isAssignableFrom(clazz)) {
            fields = clazz.getDeclaredFields();
            ArrayList<Field> sortedStringFields = new ArrayList<Field>(fields.length / 2 + 1);
            ArrayList<Field> sortedResourceFields = new ArrayList<Field>(fields.length / 2 + 1);
            int i = 0;
            while (i < fields.length) {
                Field f2 = fields[i];
                String fieldName = f2.getName().toLowerCase();
                if (!(fieldName.equals("name") || fieldName.equals("class") || fieldName.equals("autoCreated") || fieldName.equals("inherit"))) {
                    f2.setAccessible(true);
                    int modifiers = f2.getModifiers();
                    if (!Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
                        if (!Modifier.isTransient(modifiers) && f2.getType() == String.class) {
                            sortedStringFields.add(f2);
                        } else if (Modifier.isTransient(modifiers) && IResource.class.isAssignableFrom(f2.getType())) {
                            sortedResourceFields.add(f2);
                        }
                    }
                }
                ++i;
            }
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class LengthSorter
            implements Comparator<Field> {
                LengthSorter() {
                }

                @Override
                public int compare(Field fa, Field fb) {
                    int fbl;
                    int fal = fa.getName().length();
                    if (fal > (fbl = fb.getName().length())) {
                        return -1;
                    }
                    if (fal < fbl) {
                        return 1;
                    }
                    return 0;
                }
            }
            LengthSorter sorter = new LengthSorter();
            Collections.sort(sortedStringFields, sorter);
            Collections.sort(sortedResourceFields, sorter);
            block4: for (Field stringField : sortedStringFields) {
                Iterator j = sortedResourceFields.iterator();
                while (j.hasNext()) {
                    Field resourceField = (Field)j.next();
                    if (!resourceField.getName().startsWith(stringField.getName()) || resourceField.get(this) != null) continue;
                    resourceField.setAccessible(true);
                    String resourceName = (String)stringField.get(this);
                    if (resourceName != null && Resources.exists(resourceName)) {
                        Object r = Resources.get(resourceName);
                        if (resourceField.getType().isAssignableFrom(r.getClass())) {
                            resourceField.set(this, r);
                            continue block4;
                        }
                        throw new Exception(String.valueOf(resourceField.getName()) + " cannot be assigned a " + r.getClass().getName());
                    }
                    j.remove();
                    continue block4;
                }
            }
            clazz = clazz.getSuperclass();
        }
        clazz = this.getClass();
        while (Feature.class.isAssignableFrom(clazz)) {
            fields = clazz.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                f = fields[i];
                int rfmodifiers = f.getModifiers();
                if (!Modifier.isTransient(rfmodifiers) && !Modifier.isStatic(rfmodifiers)) {
                    f.setAccessible(true);
                    Object resource = f.get(this);
                    if (resource != null && IResource.class.isAssignableFrom(resource.getClass())) {
                        ((IResource)resource).create();
                    }
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
    }

    protected void doCreate() {
        try {
            this.defaultCreation();
        }
        catch (Exception t) {
            throw new RuntimeException("Failed to create " + this + " due to " + t, t);
        }
    }

    protected void doDestroy() {
        this.defaultDestroy();
    }

    private void defaultDestroy() {
        Field f;
        int i;
        Field[] fields;
        Class<?> clazz = this.getClass();
        while (Feature.class.isAssignableFrom(clazz)) {
            fields = clazz.getDeclaredFields();
            i = 0;
            while (i < fields.length) {
                f = fields[i];
                if (!(f.getName().equals("name") || f.getName().equals("class") || f.getName().equals("autoCreated"))) {
                    f.setAccessible(true);
                    int modifiers = f.getModifiers();
                    if (Modifier.isTransient(modifiers) && !Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers) && IResource.class.isAssignableFrom(f.getType())) {
                        try {
                            IResource r = (IResource)f.get(this);
                            if (r != null && !r.isLocked()) {
                                f.set(this, null);
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        clazz = this.getClass();
        while (Feature.class.isAssignableFrom(clazz)) {
            fields = clazz.getDeclaredFields();
            i = 0;
            while (i < fields.length) {
                f = fields[i];
                int rfmodifiers = f.getModifiers();
                if (!Modifier.isTransient(rfmodifiers) && !Modifier.isStatic(rfmodifiers) && IResource.class.isAssignableFrom(f.getType())) {
                    f.setAccessible(true);
                    try {
                        IResource resource;
                        if (f.get(this) != null && (resource = (IResource)f.get(this)) != null) {
                            resource.destroy();
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace(System.err);
                    }
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        Object value;
        Feature tester;
        if (this.autoCreated && this.shouldWriteAttribute("autoCreated")) {
            writer.writeAttribute("autoCreated", this.autoCreated);
        }
        Class<?> clazz = this.getClass();
        LinkedList<Field> normalFields = new LinkedList<Field>();
        LinkedList<Field> objectFields = new LinkedList<Field>();
        while (Feature.class.isAssignableFrom(clazz)) {
            Field[] fields = clazz.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                if (!(f.getName().equals("name") || f.getName().equals("class") || f.getName().equals("autoCreated"))) {
                    f.setAccessible(true);
                    int modifiers = f.getModifiers();
                    if (!(Modifier.isTransient(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers))) {
                        if (Resource.class.isAssignableFrom(f.getType())) {
                            objectFields.add(f);
                        } else {
                            normalFields.add(f);
                        }
                    }
                }
                ++i;
            }
            clazz = clazz.getSuperclass();
        }
        try {
            tester = (Feature)this.getClass().newInstance();
        }
        catch (InstantiationException e1) {
            throw new IOException(e1.getMessage());
        }
        catch (IllegalAccessException e1) {
            throw new IOException(e1.getMessage());
        }
        for (Field field : normalFields) {
            String name = field.getName();
            if (!this.shouldWriteAttribute(name)) continue;
            try {
                value = field.get(this);
                Object defaultValue = field.get(tester);
                if (value == null || value.equals(defaultValue)) continue;
                writer.writeAttribute(name, value);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.doWriteAttributes(writer);
        for (Field field : objectFields) {
            String name = field.getName();
            if (!this.shouldWriteChild(name)) continue;
            try {
                value = (Resource)field.get(this);
                if (value == null) continue;
                writer.writeTag(name);
                ((Resource)value).toXML(writer);
                writer.closeTag();
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.doWriteChildren(writer);
    }

    protected void doWriteAttributes(XMLResourceWriter writer) throws IOException {
    }

    protected void doWriteChildren(XMLResourceWriter writer) throws IOException {
    }

    protected boolean shouldWriteAttribute(String attribute) {
        return true;
    }

    protected boolean shouldWriteChild(String child) {
        return true;
    }

    public final void deregister() {
        if (FEATURES.remove(this)) {
            this.doDeregister();
        }
    }

    public final void register() {
        if (FEATURES.contains(this)) {
            return;
        }
        FEATURES.add(this);
        this.doRegister();
    }

    protected void doRegister() {
    }

    protected void doDeregister() {
    }
}

