/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.resources.ClassLoaderResource;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.ResourceConverter;
import com.shavenpuppy.jglib.resources.ResourceLoadedListener;
import java.io.BufferedInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class DynamicResource
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final List<DynamicResource> DYNAMIC_RESOURCES = new ArrayList<DynamicResource>(1);
    private String classLoader;
    private String url;
    private transient ResourceLoadedListener listener;
    private transient ClassLoaderResource classLoaderResource;

    public DynamicResource() {
    }

    public DynamicResource(String name) {
        super(name);
    }

    public DynamicResource(String name, String url) {
        super(name);
        this.url = url;
    }

    protected void doRegister() {
        DYNAMIC_RESOURCES.remove(this);
        DYNAMIC_RESOURCES.add(this);
    }

    protected void doDeregister() {
        DYNAMIC_RESOURCES.remove(this);
    }

    private ClassLoader getClassLoader() {
        if (this.classLoaderResource == null) {
            return this.getClass().getClassLoader();
        }
        return this.classLoaderResource.getClassLoader();
    }

    protected void doCreate() {
        super.doCreate();
        try {
            BufferedInputStream bis = this.url.startsWith("classpath:") ? new BufferedInputStream(this.getClassLoader().getResourceAsStream(this.url.substring(10))) : new BufferedInputStream(new URL(this.url).openStream());
            ResourceConverter loader = new ResourceConverter(this.listener, this.getClassLoader());
            loader.setOverwrite(true);
            loader.include(bis);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void createAll() {
        for (DynamicResource dr : DYNAMIC_RESOURCES) {
            if (dr.isCreated()) {
                dr.destroy();
            }
            dr.create();
        }
    }

    public void setListener(ResourceLoadedListener listener) {
        this.listener = listener;
    }

    public ResourceLoadedListener getListener() {
        return this.listener;
    }
}

