/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.MultiBuffer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import org.lwjgl.opengl.ARBDepthTexture;
import org.lwjgl.opengl.ARBFragmentProgram;
import org.lwjgl.opengl.ARBMatrixPalette;
import org.lwjgl.opengl.ARBMultisample;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBPointParameters;
import org.lwjgl.opengl.ARBShadow;
import org.lwjgl.opengl.ARBShadowAmbient;
import org.lwjgl.opengl.ARBTextureBorderClamp;
import org.lwjgl.opengl.ARBTextureCompression;
import org.lwjgl.opengl.ARBTextureCubeMap;
import org.lwjgl.opengl.ARBTextureEnvCombine;
import org.lwjgl.opengl.ARBTextureEnvDot3;
import org.lwjgl.opengl.ARBTextureMirroredRepeat;
import org.lwjgl.opengl.ARBTransposeMatrix;
import org.lwjgl.opengl.ARBVertexBlend;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.ARBWindowPos;
import org.lwjgl.opengl.ATIElementArray;
import org.lwjgl.opengl.ATIEnvmapBumpmap;
import org.lwjgl.opengl.ATIFragmentShader;
import org.lwjgl.opengl.ATIPnTriangles;
import org.lwjgl.opengl.ATISeparateStencil;
import org.lwjgl.opengl.ATITextureMirrorOnce;
import org.lwjgl.opengl.ATIVertexArrayObject;
import org.lwjgl.opengl.ATIVertexStreams;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTAbgr;
import org.lwjgl.opengl.EXTBgra;
import org.lwjgl.opengl.EXTBlendFuncSeparate;
import org.lwjgl.opengl.EXTBlendSubtract;
import org.lwjgl.opengl.EXTCompiledVertexArray;
import org.lwjgl.opengl.EXTDrawRangeElements;
import org.lwjgl.opengl.EXTFogCoord;
import org.lwjgl.opengl.EXTMultiDrawArrays;
import org.lwjgl.opengl.EXTPackedPixels;
import org.lwjgl.opengl.EXTPointParameters;
import org.lwjgl.opengl.EXTRescaleNormal;
import org.lwjgl.opengl.EXTSecondaryColor;
import org.lwjgl.opengl.EXTSeparateSpecularColor;
import org.lwjgl.opengl.EXTSharedTexturePalette;
import org.lwjgl.opengl.EXTStencilTwoSide;
import org.lwjgl.opengl.EXTStencilWrap;
import org.lwjgl.opengl.EXTTextureCompressionS3TC;
import org.lwjgl.opengl.EXTTextureEnvCombine;
import org.lwjgl.opengl.EXTTextureEnvDot3;
import org.lwjgl.opengl.EXTTextureFilterAnisotropic;
import org.lwjgl.opengl.EXTTextureLODBias;
import org.lwjgl.opengl.EXTVertexShader;
import org.lwjgl.opengl.EXTVertexWeighting;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.NVCopyDepthToColor;
import org.lwjgl.opengl.NVDepthClamp;
import org.lwjgl.opengl.NVEvaluators;
import org.lwjgl.opengl.NVFence;
import org.lwjgl.opengl.NVFogDistance;
import org.lwjgl.opengl.NVLightMaxExponent;
import org.lwjgl.opengl.NVOcclusionQuery;
import org.lwjgl.opengl.NVPackedDepthStencil;
import org.lwjgl.opengl.NVPointSprite;
import org.lwjgl.opengl.NVRegisterCombiners;
import org.lwjgl.opengl.NVRegisterCombiners2;
import org.lwjgl.opengl.NVTexgenReflection;
import org.lwjgl.opengl.NVTextureEnvCombine4;
import org.lwjgl.opengl.NVTextureRectangle;
import org.lwjgl.opengl.NVTextureShader;
import org.lwjgl.opengl.NVTextureShader2;
import org.lwjgl.opengl.NVTextureShader3;
import org.lwjgl.opengl.NVVertexArrayRange;
import org.lwjgl.opengl.NVVertexArrayRange2;
import org.lwjgl.opengl.NVVertexProgram;
import org.lwjgl.opengl.OpenGLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLUtil {
    private static final HashMap<String, Integer> glConstantsMap = new HashMap(513, 1.0f);
    public static final MultiBuffer scratch;

    static {
        GLUtil.loadGLConstants();
        scratch = new MultiBuffer(64);
    }

    public static int decode(String glstring) throws OpenGLException {
        Integer i = glConstantsMap.get(glstring.toUpperCase());
        if (i == null) {
            throw new OpenGLException(String.valueOf(glstring) + " is not a recognised GL constant");
        }
        return i;
    }

    public static String recode(int code) {
        for (String s : glConstantsMap.keySet()) {
            Integer n = glConstantsMap.get(s);
            if (n != code) continue;
            return s;
        }
        throw new OpenGLException(String.valueOf(code) + " is not a known GL code");
    }

    private static void loadGLConstants() {
        Class[] classes = new Class[]{GL11.class, GL12.class, GL13.class, GL14.class, GL15.class, ARBMultitexture.class, ARBTextureCubeMap.class, ARBDepthTexture.class, ARBFragmentProgram.class, ARBMatrixPalette.class, ARBMultisample.class, ARBPointParameters.class, ARBShadow.class, ARBShadowAmbient.class, ARBTextureBorderClamp.class, ARBTextureCompression.class, ARBTextureEnvCombine.class, ARBTextureEnvDot3.class, ARBTextureMirroredRepeat.class, ARBTransposeMatrix.class, ARBVertexBlend.class, ARBVertexBufferObject.class, ARBVertexProgram.class, ARBWindowPos.class, EXTDrawRangeElements.class, EXTAbgr.class, EXTBgra.class, EXTBlendFuncSeparate.class, EXTBlendSubtract.class, EXTCompiledVertexArray.class, EXTFogCoord.class, EXTMultiDrawArrays.class, EXTPackedPixels.class, EXTPointParameters.class, EXTRescaleNormal.class, EXTSecondaryColor.class, EXTSeparateSpecularColor.class, EXTSharedTexturePalette.class, EXTStencilTwoSide.class, EXTStencilWrap.class, EXTTextureCompressionS3TC.class, EXTTextureEnvCombine.class, EXTTextureEnvDot3.class, EXTTextureFilterAnisotropic.class, EXTTextureLODBias.class, EXTVertexShader.class, EXTVertexWeighting.class, ATIElementArray.class, ATIEnvmapBumpmap.class, ATIFragmentShader.class, ATIPnTriangles.class, ATISeparateStencil.class, ATITextureMirrorOnce.class, ATIVertexArrayObject.class, ATIVertexStreams.class, NVCopyDepthToColor.class, NVDepthClamp.class, NVEvaluators.class, NVFence.class, NVFogDistance.class, NVLightMaxExponent.class, NVOcclusionQuery.class, NVPackedDepthStencil.class, NVPointSprite.class, NVRegisterCombiners.class, NVRegisterCombiners2.class, NVTexgenReflection.class, NVTextureEnvCombine4.class, NVTextureRectangle.class, NVTextureShader.class, NVTextureShader2.class, NVTextureShader3.class, NVVertexArrayRange.class, NVVertexArrayRange2.class, NVVertexProgram.class};
        int i = 0;
        while (i < classes.length) {
            GLUtil.loadGLConstants(classes[i]);
            ++i;
        }
    }

    private static void loadGLConstants(Class<?> intf) {
        Field[] field = intf.getFields();
        int i = 0;
        while (i < field.length) {
            try {
                if (Modifier.isStatic(field[i].getModifiers()) && Modifier.isPublic(field[i].getModifiers()) && Modifier.isFinal(field[i].getModifiers()) && field[i].getType().equals(Integer.TYPE)) {
                    glConstantsMap.put(field[i].getName(), new Integer(field[i].getInt(null)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void glClientActiveTexture(int texture) {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (capabilities.OpenGL13) {
            GL13.glClientActiveTexture((int)texture);
        } else if (capabilities.GL_ARB_multitexture) {
            ARBMultitexture.glClientActiveTextureARB((int)texture);
        } else {
            throw new OpenGLException("ARB_multitexture not supported.");
        }
    }

    public static boolean isMultitextureSupported() {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        return capabilities.OpenGL13 || capabilities.GL_ARB_multitexture;
    }

    public static void glActiveTexture(int texture) {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (capabilities.OpenGL13) {
            GL13.glActiveTexture((int)texture);
        } else if (capabilities.GL_ARB_multitexture) {
            ARBMultitexture.glActiveTextureARB((int)texture);
        } else {
            throw new OpenGLException("ARB_multitexture not supported.");
        }
    }

    public static void glDrawRangeElements(int mode, int start, int end, ByteBuffer indices) {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (capabilities.OpenGL12) {
            GL12.glDrawRangeElements((int)mode, (int)start, (int)end, (ByteBuffer)indices);
        } else if (capabilities.GL_EXT_draw_range_elements) {
            EXTDrawRangeElements.glDrawRangeElementsEXT((int)mode, (int)start, (int)end, (ByteBuffer)indices);
        } else {
            throw new OpenGLException("EXT_draw_range_elements not supported.");
        }
    }

    public static void glDrawRangeElements(int mode, int start, int end, ShortBuffer indices) {
        if (GLContext.getCapabilities().OpenGL12) {
            GL12.glDrawRangeElements((int)mode, (int)start, (int)end, (ShortBuffer)indices);
        } else if (GLContext.getCapabilities().GL_EXT_draw_range_elements) {
            EXTDrawRangeElements.glDrawRangeElementsEXT((int)mode, (int)start, (int)end, (ShortBuffer)indices);
        } else {
            throw new OpenGLException("EXT_draw_range_elements not supported.");
        }
    }

    public static void glDrawRangeElements(int mode, int start, int end, IntBuffer indices) {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (capabilities.OpenGL12) {
            GL12.glDrawRangeElements((int)mode, (int)start, (int)end, (IntBuffer)indices);
        } else if (capabilities.GL_EXT_draw_range_elements) {
            EXTDrawRangeElements.glDrawRangeElementsEXT((int)mode, (int)start, (int)end, (IntBuffer)indices);
        } else {
            throw new OpenGLException("EXT_draw_range_elements not supported.");
        }
    }
}

