/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.sprites.SimpleRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public class GLGlyph
implements SimpleRenderable {
    protected transient GLBaseTexture texture;
    protected transient Glyph glyph;
    protected transient int xpos;
    protected transient int ypos;
    protected transient float scale;
    private static final Rectangle bounds = new Rectangle();

    public GLGlyph(GLBaseTexture texture, Glyph glyph, float scale) {
        this.texture = texture;
        this.glyph = glyph;
        this.scale = scale;
    }

    public GLGlyph(GLGlyph src) {
        this.texture = src.texture;
        this.glyph = src.glyph;
        this.scale = src.scale;
    }

    public void from(GLGlyph src) {
        this.init(src.texture, src.glyph);
    }

    public void init(GLBaseTexture texture, Glyph g) {
        this.texture = texture;
        this.glyph = g;
    }

    public String getName() {
        return null;
    }

    public int getXpos() {
        return this.xpos;
    }

    public int getYpos() {
        return this.ypos;
    }

    public void render(SimpleRenderer renderer) {
        this.render(null, null, 255, renderer);
    }

    public void render(ReadableColor topCol, ReadableColor bottomCol, int alpha, SimpleRenderer renderer) {
        float y0;
        float x1;
        float y1;
        float x0;
        int offset;
        this.glyph.getBounds((WritableRectangle)bounds);
        int n = offset = this.texture.minMode == 9728 ? 0 : 1;
        if (offset == 0) {
            x0 = (float)bounds.getX() / (float)this.texture.getWidth();
            y1 = (float)bounds.getY() / (float)this.texture.getHeight();
            x1 = (float)(bounds.getX() + bounds.getWidth()) / (float)this.texture.getWidth();
            y0 = (float)(bounds.getY() + bounds.getHeight()) / (float)this.texture.getHeight();
        } else {
            x0 = ((float)bounds.getX() + 0.5f) / (float)this.texture.getWidth();
            y1 = ((float)bounds.getY() + 0.5f) / (float)this.texture.getHeight();
            x1 = ((float)(bounds.getX() + bounds.getWidth()) + 0.5f) / (float)this.texture.getWidth();
            y0 = ((float)(bounds.getY() + bounds.getHeight()) + 0.5f) / (float)this.texture.getHeight();
        }
        boolean coloured = topCol != null && bottomCol != null;
        renderer.glTexCoord2f(x0, y0);
        if (coloured) {
            ColorUtil.setGLColorPre(bottomCol, alpha, renderer);
        }
        short idx = renderer.glVertex2f(this.xpos, this.ypos);
        renderer.glTexCoord2f(x1, y0);
        if (coloured) {
            ColorUtil.setGLColorPre(bottomCol, alpha, renderer);
        }
        renderer.glVertex2f((int)((float)(bounds.getWidth() + offset) * this.scale) + this.xpos, this.ypos);
        renderer.glTexCoord2f(x1, y1);
        if (coloured) {
            ColorUtil.setGLColorPre(topCol, alpha, renderer);
        }
        renderer.glVertex2f((int)((float)(bounds.getWidth() + offset) * this.scale) + this.xpos, (int)((float)(bounds.getHeight() + offset) * this.scale) + this.ypos);
        renderer.glTexCoord2f(x0, y1);
        if (coloured) {
            ColorUtil.setGLColorPre(topCol, alpha, renderer);
        }
        renderer.glVertex2f(this.xpos, (int)((float)(bounds.getHeight() + offset) * this.scale) + this.ypos);
        renderer.glRender(4, new short[]{(short)(idx + 0), (short)(idx + 1), (short)(idx + 2), (short)(idx + 0), (short)(idx + 2), (short)(idx + 3)});
    }

    public void setLocation(int xp, int yp) {
        this.xpos = xp;
        this.ypos = yp;
    }

    public int getWidth() {
        return (int)((float)this.glyph.getWidth() * this.scale);
    }

    public int getHeight() {
        return (int)((float)this.glyph.getHeight() * this.scale);
    }

    public int getBearingX() {
        return (int)((float)this.glyph.getBearingX() * this.scale);
    }

    public int getBearingY() {
        return (int)((float)this.glyph.getBearingY() * this.scale);
    }

    public int getAdvance() {
        return (int)((float)this.glyph.getAdvance() * this.scale);
    }

    public int getKerningAfter(GLGlyph g) {
        if (g == null) {
            return 0;
        }
        return (int)((float)this.glyph.getKerningAfter(g.glyph) * this.scale);
    }

    public void getBearing(Point dest) {
        this.glyph.getBearing((WritablePoint)dest);
        dest.setLocation((int)((float)dest.getX() * this.scale), (int)((float)dest.getY() * this.scale));
    }

    public void getBounds(Rectangle dest) {
        this.glyph.getBounds((WritableRectangle)dest);
        dest.setBounds((int)((float)dest.getX() * this.scale), (int)((float)dest.getY() * this.scale), (int)((float)dest.getWidth() * this.scale), (int)((float)dest.getHeight() * this.scale));
    }

    public String toString() {
        return "GLGlyph[" + this.getXpos() + ", " + this.getYpos() + ": " + this.glyph.toString() + "]";
    }
}

