/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.interpolators;

import com.shavenpuppy.jglib.interpolators.InterpolatorBase;
import java.io.ObjectInput;
import java.io.ObjectStreamException;

public final class SineInterpolator
extends InterpolatorBase {
    private static final long serialVersionUID = 1L;
    public static final SineInterpolator instance = new SineInterpolator();

    private SineInterpolator() {
    }

    public float interpolate(float a, float b, float ratio) {
        if (a == b) {
            return a;
        }
        if (ratio < 0.0f) {
            ratio = 0.0f;
        } else if (ratio > 1.0f) {
            ratio = 1.0f;
        }
        ratio = 1.0f - ratio;
        double f = Math.sqrt(1.0 - (double)(ratio * ratio));
        return (float)((double)a * (1.0 - f) + (double)b * f);
    }

    private Object readResolve(ObjectInput oi) throws ObjectStreamException {
        return instance;
    }
}

