/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.interpolators;

import com.shavenpuppy.jglib.interpolators.InterpolatorBase;
import java.io.ObjectInput;
import java.io.ObjectStreamException;

public final class CosineInterpolator
extends InterpolatorBase {
    private static final long serialVersionUID = 1L;
    public static final CosineInterpolator instance = new CosineInterpolator();

    private CosineInterpolator() {
    }

    public float interpolate(float a, float b, float ratio) {
        if (a == b) {
            return a;
        }
        if (ratio < 0.0f) {
            ratio = 0.0f;
        } else if (ratio > 1.0f) {
            ratio = 1.0f;
        }
        double f = Math.sqrt(1.0 - (double)(ratio * ratio));
        return (float)((double)a * f + (double)b * (1.0 - f));
    }

    private Object readResolve(ObjectInput oi) throws ObjectStreamException {
        return instance;
    }
}

