/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.IResource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resources {
    public static final boolean DEBUG = false;
    private static boolean runMode;
    private static final Map<String, IResource> RESOURCES;
    private static final HashMap<Class<? extends IResource>, String> CLASS_TO_TAG_MAP;
    private static final HashMap<String, Class<? extends IResource>> TAG_TO_CLASS_MAP;
    private static final List<IResource> QUEUE;
    private static int numCreated;
    private static CreatingCallback creatingCallback;

    static {
        if (System.getProperty("java.protocol.handler.pkgs") == null) {
            System.getProperties().put("java.protocol.handler.pkgs", "com.shavenpuppy.jglib.resources.protocol");
        }
        RESOURCES = new LinkedHashMap<String, IResource>(256, 0.25f);
        CLASS_TO_TAG_MAP = new HashMap();
        TAG_TO_CLASS_MAP = new HashMap();
        QUEUE = new LinkedList<IResource>();
    }

    private Resources() {
    }

    public static <T extends IResource> T peek(String name) {
        return (T)RESOURCES.get(name.toLowerCase());
    }

    public static <T extends IResource> T get(String name) {
        IResource ret = RESOURCES.get(name.toLowerCase());
        if (ret == null) {
            System.err.println("WARNING: Resource '" + name + "' not found");
            return null;
        }
        if (!ret.isCreated()) {
            if (creatingCallback != null) {
                creatingCallback.onCreating(ret);
            }
            ret.create();
            ++numCreated;
        }
        return (T)ret;
    }

    public static boolean exists(String name) {
        return RESOURCES.containsKey(name.toLowerCase());
    }

    public static void put(IResource resource) {
        if (resource.getName() == null) {
            throw new RuntimeException("Unnamed resource " + resource + " cannot be put in the named set");
        }
        IResource old = RESOURCES.put(resource.getName().toLowerCase(), resource);
        if (old != null) {
            old.deregister();
        }
        resource.register();
    }

    public static IResource remove(String name) {
        IResource ret = RESOURCES.remove(name.toLowerCase());
        if (ret != null) {
            ret.destroy();
            ret.deregister();
        }
        return ret;
    }

    static IResource forget(IResource resource) {
        return RESOURCES.remove(resource.getName());
    }

    public static void save(OutputStream os) throws IOException {
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new BufferedOutputStream(os);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(RESOURCES);
            oos.flush();
            bos.flush();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void load(InputStream is) throws IOException, ClassNotFoundException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Map newAll = (Map)ois.readObject();
        for (Map.Entry entry : newAll.entrySet()) {
            Resources.put((IResource)entry.getValue());
        }
    }

    public static void clear() {
        for (IResource res : RESOURCES.values()) {
            if (res == null) continue;
            if (res.isCreated()) {
                res.destroy();
            }
            res.deregister();
        }
        RESOURCES.clear();
        System.gc();
    }

    public static void reset() {
        for (IResource res : RESOURCES.values()) {
            if (res == null || !res.isCreated()) continue;
            res.destroy();
        }
        System.gc();
    }

    public static int getNumCreated() {
        return numCreated;
    }

    public static CreatingCallback getCreatingCallback() {
        return creatingCallback;
    }

    public static void setCreatingCallback(CreatingCallback creatingCallback) {
        Resources.creatingCallback = creatingCallback;
    }

    public static <T extends IResource> ArrayList<T> list(Class<T> clazz) {
        LinkedList<IResource> ret = new LinkedList<IResource>();
        for (Map.Entry<String, IResource> entry : RESOURCES.entrySet()) {
            if (entry.getValue().getName() == null || !clazz.isAssignableFrom(entry.getValue().getClass())) continue;
            ret.add((IResource)clazz.cast(entry.getValue()));
        }
        return new ArrayList(ret);
    }

    public static List<IResource> list() {
        ArrayList<IResource> ret = new ArrayList<IResource>(RESOURCES.values());
        return Collections.unmodifiableList(ret);
    }

    public static void setRunMode(boolean runMode) {
        Resources.runMode = runMode;
    }

    public static boolean isRunMode() {
        return runMode;
    }

    public static void registerTag(Class<? extends IResource> clazz, String tag) {
        CLASS_TO_TAG_MAP.put(clazz, tag);
        TAG_TO_CLASS_MAP.put(tag, clazz);
    }

    public static String getTag(Class<? extends IResource> clazz) {
        return CLASS_TO_TAG_MAP.get(clazz);
    }

    public static Class<? extends IResource> getMapping(String tag) {
        return TAG_TO_CLASS_MAP.get(tag);
    }

    public static void create() {
        for (IResource res : RESOURCES.values()) {
            res.create();
        }
    }

    static void queue(IResource res) {
        QUEUE.add(res);
    }

    public static void dequeue() {
        for (IResource r : QUEUE) {
            r.create();
        }
        QUEUE.clear();
    }

    public static interface CreatingCallback {
        public void onCreating(IResource var1);
    }
}

