/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public final class Palette
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private int format;
    public static final int ABGR = 0;
    public static final int BGRA = 1;
    public static final int ARGB = 2;
    public static final int RGBA = 3;
    private ByteBuffer data;

    public Palette() {
    }

    public Palette(int format, int size) {
        this.format = format;
        this.data = ByteBuffer.allocateDirect(size << 2).order(ByteOrder.nativeOrder());
    }

    public Palette(int format, IntBuffer buf) {
        this.format = format;
        this.data = ByteBuffer.allocateDirect(buf.capacity() << 2).order(ByteOrder.nativeOrder());
        this.data.asIntBuffer().put(buf);
    }

    public Palette(int format, int[] buf) {
        this.format = format;
        this.data = ByteBuffer.allocateDirect(buf.length << 2).order(ByteOrder.nativeOrder());
        this.data.asIntBuffer().put(buf);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.format = in.readInt();
        switch (this.format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IOException("Illegal palette format " + this.format);
            }
        }
        int size = in.readInt();
        this.data = ByteBuffer.allocateDirect(size << 2).order(ByteOrder.nativeOrder());
        IntBuffer buf = this.data.asIntBuffer();
        int i = 0;
        while (i < size) {
            buf.put(in.readInt());
            ++i;
        }
        buf.flip();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.format);
        int size = this.getSize();
        out.writeInt(size);
        IntBuffer buf = this.data.asIntBuffer();
        int i = 0;
        while (i < size) {
            out.writeInt(buf.get(i));
            ++i;
        }
    }

    public final int getFormat() {
        return this.format;
    }

    public final int getSize() {
        return this.data.capacity() >> 2;
    }

    public final ByteBuffer getBuffer() {
        return this.data;
    }

    public void setColor(int index, ReadableColor color) {
        this.data.position(index << 2);
        switch (this.format) {
            case 3: {
                color.writeRGBA(this.data);
                break;
            }
            case 2: {
                color.writeARGB(this.data);
                break;
            }
            case 1: {
                color.writeBGRA(this.data);
                break;
            }
            case 0: {
                color.writeABGR(this.data);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Color getColor(int index, Color color) {
        if (color == null) {
            color = new Color();
        }
        this.data.position(index << 2);
        return color;
    }
}

