/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.Image;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public final class Font
implements Serializable {
    private static final long serialVersionUID = 5L;
    private static final int MAGIC = 17185;
    private static final Rectangle TEMPBOUNDS = new Rectangle();
    private static final Point TEMPPOINT = new Point();
    private String name;
    private boolean bold;
    private boolean italic;
    private int ascent;
    private int descent;
    private int leading;
    private int size;
    private Glyph[] glyph;
    private int[] map;
    private Image image;

    public Font() {
    }

    public Font(String name, boolean bold, boolean italic, Image image, Glyph[] glyph, int size, int ascent, int descent, int leading, int[] map) {
        this.name = name;
        this.bold = bold;
        this.italic = italic;
        this.image = image;
        this.size = size;
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.map = map;
        this.glyph = glyph;
    }

    public static Font importSerialised(String filename) throws Exception {
        InputStream fIn = Font.class.getClassLoader().getResourceAsStream(filename);
        BufferedInputStream bIn = new BufferedInputStream(fIn);
        Font ret = new Font();
        ret.readExternal(bIn);
        return ret;
    }

    public void writeExternal(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        dos.writeInt(17185);
        dos.writeUTF(this.name);
        dos.writeBoolean(this.bold);
        dos.writeBoolean(this.italic);
        dos.writeInt(this.ascent);
        dos.writeInt(this.descent);
        dos.writeInt(this.leading);
        dos.writeInt(this.size);
        dos.writeInt(this.glyph.length);
        Object[] objectArray = this.glyph;
        int n = this.glyph.length;
        int n2 = 0;
        while (n2 < n) {
            Glyph g = objectArray[n2];
            g.writeExternal(dos);
            ++n2;
        }
        dos.writeInt(this.map.length);
        objectArray = this.map;
        n = this.map.length;
        n2 = 0;
        while (n2 < n) {
            Glyph i = objectArray[n2];
            dos.writeInt((int)i);
            ++n2;
        }
        this.image.writeExternal(dos);
    }

    public void readExternal(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        int magic = dis.readInt();
        if (magic != 17185) {
            throw new IOException("Expected 17185 but got " + magic);
        }
        this.name = dis.readUTF();
        this.bold = dis.readBoolean();
        this.italic = dis.readBoolean();
        this.ascent = dis.readInt();
        this.descent = dis.readInt();
        this.leading = dis.readInt();
        this.size = dis.readInt();
        this.glyph = new Glyph[dis.readInt()];
        int i = 0;
        while (i < this.glyph.length) {
            this.glyph[i] = new Glyph();
            this.glyph[i].readExternal(dis);
            ++i;
        }
        this.map = new int[dis.readInt()];
        i = 0;
        while (i < this.map.length) {
            this.map[i] = dis.readInt();
            ++i;
        }
        this.image = new Image();
        this.image.readExternal(dis);
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public Glyph getGlyph(int i) {
        return this.glyph[i];
    }

    public int getNumGlyphs() {
        return this.glyph.length;
    }

    public Image getImage() {
        assert (this.image != null) : "Font image has been disposed.";
        return this.image;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getSize() {
        return this.size;
    }

    public Glyph map(char c) {
        if (c >= this.map.length) {
            c = '\u0000';
        }
        if (c == '\t') {
            c = (char)32;
        }
        int m = this.map[c];
        assert (m != -1) : "char " + c + " is not valid";
        if (m >= this.glyph.length) {
            m = 0;
        }
        return this.glyph[m];
    }

    public Rectangle getStringBounds(String text, int start, int end, Rectangle dest) {
        if (dest == null) {
            dest = new Rectangle();
        } else {
            dest.setBounds(0, 0, 0, 0);
        }
        Glyph last = null;
        int penX = 0;
        int i = start;
        while (i < end) {
            Glyph next = this.map(text.charAt(i));
            next.getBounds((WritableRectangle)TEMPBOUNDS);
            next.getBearing((WritablePoint)TEMPPOINT);
            TEMPBOUNDS.setLocation(TEMPPOINT.getX() + penX - next.getKerningAfter(last), TEMPPOINT.getY());
            TEMPBOUNDS.setWidth(Math.max(TEMPBOUNDS.getWidth(), next.getAdvance()));
            dest.add((ReadableRectangle)TEMPBOUNDS);
            penX += next.getAdvance() - next.getKerningAfter(last);
            last = next;
            ++i;
        }
        return dest;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isPlain() {
        return !this.bold && !this.italic;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Font [name=");
        buffer.append(this.name);
        buffer.append(", bold=");
        buffer.append(this.bold);
        buffer.append(", italic=");
        buffer.append(this.italic);
        buffer.append(", ascent=");
        buffer.append(this.ascent);
        buffer.append(", descent=");
        buffer.append(this.descent);
        buffer.append(", leading=");
        buffer.append(this.leading);
        buffer.append(", size=");
        buffer.append(this.size);
        buffer.append(", image=");
        buffer.append(this.image);
        buffer.append("]");
        return buffer.toString();
    }
}

