/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.steam;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import net.puppygames.steam.AppID;
import net.puppygames.steam.AuthTicket;
import net.puppygames.steam.BeginAuthSessionResult;
import net.puppygames.steam.ISteamObject;
import net.puppygames.steam.SteamID;
import net.puppygames.steam.UserHasLicenseForAppResult;
import net.puppygames.steam.VoiceResult;
import net.puppygames.steam.user.AvailableVoice;
import net.puppygames.steam.user.UserListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ISteamUser
extends ISteamObject<UserListener> {
    public boolean isLoggedOn();

    public SteamID getSteamID();

    public void initiateGameConnection(ByteBuffer var1, SteamID var2, InetSocketAddress var3, boolean var4);

    public void terminateGameConnection(InetSocketAddress var1);

    public String getUserDataFolder();

    public void startVoiceRecording();

    public void stopVoiceRecording();

    public AvailableVoice getAvailableVoice(int var1);

    public VoiceResult getVoice(boolean var1, ByteBuffer var2, boolean var3, ByteBuffer var4, int var5);

    public VoiceResult decompressVoice(ByteBuffer var1, ByteBuffer var2, int var3);

    public int getVoiceOptimalSampleRate();

    public AuthTicket getAuthSessionTicket(ByteBuffer var1);

    public BeginAuthSessionResult beginAuthSession(ByteBuffer var1, SteamID var2);

    public void endAuthSession(SteamID var1);

    public void cancelAuthTicket(AuthTicket var1);

    public UserHasLicenseForAppResult isUserLicensedForApp(SteamID var1, AppID var2);

    public boolean isBehindNAT();

    public void advertiseGame(SteamID var1, InetSocketAddress var2);

    public void requestEncryptedAppTicket(ByteBuffer var1);

    public void getEncryptedAppTicket(ByteBuffer var1);
}

