/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.LWJGLUtil;

public class XRandR {
    private static Screen[] current;
    private static Map screens;
    private static final Pattern SCREEN_PATTERN1;
    private static final Pattern SCREEN_PATTERN2;

    static {
        SCREEN_PATTERN1 = Pattern.compile("^(\\d+)x(\\d+)\\+(\\d+)\\+(\\d+)$");
        SCREEN_PATTERN2 = Pattern.compile("^(\\d+)x(\\d+)$");
    }

    private static void populate() {
        if (screens == null) {
            screens = new HashMap();
            try {
                String line;
                Process p = Runtime.getRuntime().exec(new String[]{"xrandr", "-q"});
                ArrayList currentList = new ArrayList();
                ArrayList possibles = new ArrayList();
                String name = null;
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = br.readLine()) != null) {
                    String[] sa = (line = line.trim()).split("\\s+");
                    if (sa[1].equals("connected")) {
                        if (name != null) {
                            screens.put(name, possibles.toArray(new Screen[possibles.size()]));
                            possibles.clear();
                        }
                        name = sa[0];
                        XRandR.parseScreen(currentList, name, sa[2]);
                        continue;
                    }
                    if (!Pattern.matches("\\d*x\\d*", sa[0])) continue;
                    XRandR.parseScreen(possibles, name, sa[0]);
                }
                screens.put(name, possibles.toArray(new Screen[possibles.size()]));
                current = currentList.toArray(new Screen[currentList.size()]);
            }
            catch (Throwable e) {
                LWJGLUtil.log("Exception in XRandR.populate(): " + e.getMessage());
                screens.clear();
                current = new Screen[0];
            }
        }
    }

    public static Screen[] getConfiguration() {
        XRandR.populate();
        return (Screen[])current.clone();
    }

    public static void setConfiguration(Screen[] screens) {
        if (screens.length == 0) {
            throw new IllegalArgumentException("Must specify at least one screen");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("xrandr");
        int i = 0;
        while (i < current.length) {
            boolean found = false;
            int j = 0;
            while (j < screens.length) {
                if (screens[j].name.equals(XRandR.current[i].name)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                cmd.add("--output");
                cmd.add(XRandR.current[i].name);
                cmd.add("--off");
            }
            ++i;
        }
        i = 0;
        while (i < screens.length) {
            screens[i].getArgs(cmd);
            ++i;
        }
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[cmd.size()]));
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                LWJGLUtil.log("Unexpected output from xrandr process: " + line);
            }
            current = screens;
        }
        catch (IOException e) {
            LWJGLUtil.log("XRandR exception in setConfiguration(): " + e.getMessage());
        }
    }

    public static String[] getScreenNames() {
        XRandR.populate();
        return screens.keySet().toArray(new String[screens.size()]);
    }

    public static Screen[] getResolutions(String name) {
        XRandR.populate();
        return (Screen[])((Screen[])screens.get(name)).clone();
    }

    private static void parseScreen(List list, String name, String what) {
        int ypos;
        int xpos;
        Matcher m = SCREEN_PATTERN1.matcher(what);
        if (!m.matches() && !(m = SCREEN_PATTERN2.matcher(what)).matches()) {
            System.out.println("Did not match: " + what);
            return;
        }
        int width = Integer.parseInt(m.group(1));
        int height = Integer.parseInt(m.group(2));
        if (m.groupCount() > 3) {
            xpos = Integer.parseInt(m.group(3));
            ypos = Integer.parseInt(m.group(4));
        } else {
            xpos = 0;
            ypos = 0;
        }
        list.add(new Screen(name, width, height, xpos, ypos));
    }

    public static class Screen
    implements Cloneable {
        public final String name;
        public final int width;
        public final int height;
        public int xPos = 0;
        public int yPos = 0;

        private Screen(String name, int width, int height, int xPos, int yPos) {
            this.name = name;
            this.width = width;
            this.height = height;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        private void getArgs(List argList) {
            argList.add("--output");
            argList.add(this.name);
            argList.add("--mode");
            argList.add(String.valueOf(this.width) + "x" + this.height);
            argList.add("--pos");
            argList.add(String.valueOf(this.xPos) + "x" + this.yPos);
        }

        public String toString() {
            return String.valueOf(this.name) + " " + this.width + "x" + this.height + " @ " + this.xPos + "x" + this.yPos;
        }
    }
}

