/*
 * Decompiled with CFR 0.152.
 */
package puppytron.movements;

import puppytron.GameScreen;
import puppytron.Moveable;
import puppytron.Movement;
import puppytron.MovementFeature;

public class XYMovementFeature
extends MovementFeature {
    private static final long serialVersionUID = 1L;
    private int moveAmount;
    private int delayAmount;
    private boolean targetEnemies;

    public XYMovementFeature() {
    }

    public XYMovementFeature(String name) {
        super(name);
    }

    public Movement spawn(Moveable gidrah) {
        return new XYMovementInstance(gidrah);
    }

    public int getArmour() {
        return 0;
    }

    public int getHitPoints() {
        return 0;
    }

    public int getScore() {
        return 10;
    }

    public String getSpawnType() {
        return "edge";
    }

    public int getDifficulty() {
        return 1;
    }

    protected class XYMovementInstance
    extends MovementFeature.MovementInstance {
        private boolean delay;
        private int moveTick;
        private Moveable target;

        protected XYMovementInstance(Moveable gidrah) {
            super(gidrah);
        }

        public void tick(Moveable moveableGidrah) {
            if (this.target == null || !this.target.isActive()) {
                moveableGidrah.setVelocity(0.0f, 0.0f);
                this.chooseTarget();
                if (this.target == null) {
                    return;
                }
            }
            ++this.moveTick;
            if (this.delay) {
                float vx;
                if (this.moveTick < XYMovementFeature.this.delayAmount) {
                    moveableGidrah.setVelocity(0.0f, 0.0f);
                    return;
                }
                this.delay = false;
                this.moveTick = 0;
                if (this.target.getX() < moveableGidrah.getX()) {
                    vx = -XYMovementFeature.this.getSpeed();
                    moveableGidrah.setFacing(-1);
                } else if (this.target.getX() > moveableGidrah.getX()) {
                    vx = XYMovementFeature.this.getSpeed();
                    moveableGidrah.setFacing(1);
                } else {
                    vx = 0.0f;
                }
                float vy = this.target.getY() < moveableGidrah.getY() ? -XYMovementFeature.this.getSpeed() : (this.target.getY() > moveableGidrah.getY() ? XYMovementFeature.this.getSpeed() : 0.0f);
                moveableGidrah.setVelocity(vx, vy);
            } else {
                if (this.moveTick < XYMovementFeature.this.moveAmount) {
                    return;
                }
                this.delay = true;
                this.moveTick = 0;
                moveableGidrah.setVelocity(0.0f, 0.0f);
            }
        }

        private void chooseTarget() {
            this.target = XYMovementFeature.this.targetEnemies ? GameScreen.getRandomGidrah() : GameScreen.getPlayer();
        }
    }
}

