/*
 * Decompiled with CFR 0.152.
 */
package puppytron.movements;

import puppytron.GameScreen;
import puppytron.Moveable;
import puppytron.Movement;
import puppytron.MovementFeature;

public class HVMovementFeature
extends MovementFeature {
    private static final long serialVersionUID = 1L;
    private int moveAmount;
    private int delayAmount;

    public Movement spawn(Moveable gidrah) {
        return new HVMovementInstance(gidrah);
    }

    public int getArmour() {
        return 0;
    }

    public int getHitPoints() {
        return 0;
    }

    public int getScore() {
        return 5;
    }

    public String getSpawnType() {
        return "edge";
    }

    public int getDifficulty() {
        return 1;
    }

    protected class HVMovementInstance
    extends MovementFeature.MovementInstance {
        private boolean delay;
        private int moveTick;

        protected HVMovementInstance(Moveable gidrah) {
            super(gidrah);
        }

        public void tick(Moveable moveableGidrah) {
            ++this.moveTick;
            if (this.delay) {
                if (this.moveTick < HVMovementFeature.this.delayAmount) {
                    return;
                }
                this.delay = false;
                this.moveTick = 0;
                float vx = moveableGidrah.getVX();
                float vy = moveableGidrah.getVY();
                if (Math.random() < 0.5) {
                    if (GameScreen.getPlayer().getX() < moveableGidrah.getX()) {
                        vx = -HVMovementFeature.this.getSpeed();
                        moveableGidrah.setFacing(-1);
                    } else if (GameScreen.getPlayer().getX() > moveableGidrah.getX()) {
                        vx = HVMovementFeature.this.getSpeed();
                        moveableGidrah.setFacing(1);
                    }
                    vy = 0.0f;
                } else {
                    if (GameScreen.getPlayer().getY() < moveableGidrah.getY()) {
                        vy = -HVMovementFeature.this.getSpeed();
                    } else if (GameScreen.getPlayer().getY() > moveableGidrah.getY()) {
                        vy = HVMovementFeature.this.getSpeed();
                    }
                    vx = 0.0f;
                }
                moveableGidrah.setVelocity(vx, vy);
            } else {
                if (this.moveTick < HVMovementFeature.this.moveAmount) {
                    return;
                }
                this.delay = true;
                this.moveTick = 0;
                moveableGidrah.setVelocity(0.0f, 0.0f);
            }
        }
    }
}

