/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class SpawnEffect
extends Effect {
    private static final Color cachedColor = new Color();
    float x;
    float y;
    ReadableColor startColor;
    ReadableColor endColor;
    int tick;
    int duration;
    static final int SIZE = 4;

    public SpawnEffect(int x, int y, ReadableColor color, int duration) {
        this.x = x;
        this.y = y;
        this.startColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        this.endColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
        this.duration = duration;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    protected void doTick() {
        ++this.tick;
    }

    protected void doRender() {
        float ratio = (float)this.tick / (float)this.duration;
        ColorInterpolator.interpolate((ReadableColor)this.startColor, (ReadableColor)this.endColor, (float)ratio, (Interpolator)LinearInterpolator.instance, (Color)cachedColor);
        ColorUtil.setGLColor((ReadableColor)cachedColor);
        int dt = this.duration - this.tick << 2;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3553);
        GL11.glBegin((int)5);
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)0);
        GL11.glVertex2f((float)(this.x - (float)dt - 4.0f), (float)(this.y - (float)dt - 4.0f));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)-1);
        GL11.glVertex2f((float)(this.x - (float)dt), (float)(this.y - (float)dt));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)0);
        GL11.glVertex2f((float)(this.x + (float)dt + 4.0f), (float)(this.y - (float)dt - 4.0f));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)-1);
        GL11.glVertex2f((float)(this.x + (float)dt), (float)(this.y - (float)dt));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)0);
        GL11.glVertex2f((float)(this.x + (float)dt + 4.0f), (float)(this.y + (float)dt + 4.0f));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)-1);
        GL11.glVertex2f((float)(this.x + (float)dt), (float)(this.y + (float)dt));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)0);
        GL11.glVertex2f((float)(this.x - (float)dt - 4.0f), (float)(this.y + (float)dt + 4.0f));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)-1);
        GL11.glVertex2f((float)(this.x - (float)dt), (float)(this.y + (float)dt));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)0);
        GL11.glVertex2f((float)(this.x - (float)dt - 4.0f), (float)(this.y - (float)dt - 4.0f));
        GL11.glColor4ub((byte)cachedColor.getRedByte(), (byte)cachedColor.getGreenByte(), (byte)cachedColor.getBlueByte(), (byte)-1);
        GL11.glVertex2f((float)(this.x - (float)dt), (float)(this.y - (float)dt));
        GL11.glEnd();
    }

    public boolean isActive() {
        return this.tick < this.duration;
    }
}

