/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameState;
import net.puppygames.applet.Launcher;
import net.puppygames.applet.Score;
import net.puppygames.applet.screens.HiscoresScreen;
import net.puppygames.applet.screens.NagScreen;
import net.puppygames.applet.screens.OptionsScreen;
import org.lwjgl.openal.AL;
import puppytron.GameScreen;
import puppytron.PuppytronGameState;
import puppytron.RegisterScreen;
import puppytron.Res;
import puppytron.TitleScreen;

public class Puppytron
extends Game {
    private static final long serialVersionUID = 1L;
    private static SoundPlayer speechPlayer;
    private static PuppytronGameState gameState;
    static /* synthetic */ Class class$0;

    public Puppytron(String name) {
        super(name);
    }

    protected GameState createGameState() {
        return new PuppytronGameState();
    }

    protected void setGameState(GameState newGameState) {
        super.setGameState(newGameState);
        gameState = (PuppytronGameState)newGameState;
    }

    protected void doGameOver() {
        GameScreen.gameOver();
    }

    protected void doShowOptions() {
        OptionsScreen.show();
    }

    protected void doShowRegisterScreen() {
        RegisterScreen.show();
    }

    protected void doCreate() {
        super.doCreate();
        if (AL.isCreated() && Puppytron.isSFXEnabled()) {
            speechPlayer = new SoundPlayer(1);
            speechPlayer.create();
        }
        Resources.put((Resource)new Res());
        Res.instantiate();
    }

    public static SoundEffect speak(ALBuffer buffer) {
        SoundEffect effect;
        if (!AL.isCreated() || !Puppytron.isSFXEnabled()) {
            return null;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.puppygames.applet.Game");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((effect = speechPlayer.allocate(buffer, (Object)clazz)) != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            effect.setAttenuated(false, (Object)clazz2);
            float f = effect.getBuffer().getGain() * Puppytron.getSFXVolume();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("net.puppygames.applet.Game");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            effect.setGain(f, (Object)clazz3);
            if (buffer.getWave().getType() == 1) {
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("net.puppygames.applet.Game");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                effect.setPosition(0.0f, 0.0f, 0.0f, (Object)clazz4);
            }
        }
        return effect;
    }

    public static int getScore() {
        return gameState.getScore();
    }

    public static boolean isPowerupDue() {
        return gameState.isPowerupDue();
    }

    public static void addScore(int points) {
        gameState.addScore(points);
    }

    public static void setUsingMouse(boolean usingMouse) {
        gameState.setUsingMouse(usingMouse);
    }

    protected void doEndGame() {
        if (Game.isDemoExpired()) {
            NagScreen.show((String)"You know you want to!", (boolean)true);
        } else if (gameState.getScore() > 0) {
            Score scoreToSubmit = new Score(Game.getTitle(), Game.getVersion(), Game.getScoreGroup(), "", Game.getInstallation(), gameState.getScore(), "", Game.isRegistered());
            HiscoresScreen.show((Score)scoreToSubmit);
        } else {
            TitleScreen.show();
        }
    }

    protected void doGameTick() {
        if (AL.isCreated()) {
            speechPlayer.play();
        }
    }

    protected void onExit() {
        GameScreen.onExit();
    }

    protected void doDestroy() {
        super.doDestroy();
        if (speechPlayer != null) {
            speechPlayer.destroy();
            speechPlayer = null;
        }
    }

    public static void main(String[] args) {
        Launcher.main((String[])args);
    }
}

