/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import java.io.Serializable;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import puppytron.AttackDrone;
import puppytron.Bomb;
import puppytron.Bullet;
import puppytron.DefenceDrone;
import puppytron.DroneBullet;
import puppytron.EnemyBullet;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Mine;
import puppytron.Moveable;
import puppytron.Player;
import puppytron.Powerup;
import puppytron.Saucer;
import puppytron.SmartBombShock;

public abstract class Entity
implements Moveable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected float x;
    protected float y;
    protected float vx;
    protected float vy;
    private boolean alive = true;
    protected boolean visible = true;
    protected boolean flash;
    protected Sprite sprite;

    public final void respawn(Screen screen) {
        screen.addTickable((Tickable)this);
        this.doRespawn();
    }

    protected abstract void doRespawn();

    public final void spawn(Screen screen) {
        this.sprite = screen.allocateSprite((Serializable)this);
        if (this.sprite == null) {
            this.remove();
            return;
        }
        GameScreen.addEntity(this);
        this.doSpawn();
    }

    protected void doSpawn() {
    }

    public abstract boolean canCollide();

    public final boolean isActive() {
        return this.alive;
    }

    public final void remove() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
        if (!this.alive) {
            return;
        }
        this.alive = false;
        this.doRemove();
    }

    protected void doRemove() {
    }

    public abstract void onCollision(Entity var1);

    protected void onCollisionWithPlayer(Player player) {
    }

    protected void onCollisionWithGidrah(Gidrah gidrah) {
    }

    protected void onCollisionWithPowerup(Powerup powerup) {
    }

    protected void onCollisionWithBullet(Bullet bullet) {
    }

    protected void onCollisionWithEnemyBullet(EnemyBullet enemyBullet) {
    }

    protected void onCollisionWithMine(Mine mine) {
    }

    protected void onCollisionWithShockwave(SmartBombShock shock) {
    }

    protected void onCollisionWithBomb(Bomb bomb) {
    }

    protected void onCollisionWithAttackDrone(AttackDrone drone) {
    }

    protected void onCollisionWithDefenceDrone(DefenceDrone drone) {
    }

    protected void onCollisionWithSaucer(Saucer saucer) {
    }

    protected void onCollisionWithDroneBullet(DroneBullet bullet) {
    }

    public final void setAppearance(AnimatedAppearance appearance) {
        if (this.sprite != null) {
            this.sprite.setAppearance(appearance);
        }
    }

    public final boolean isTouching(Entity dest) {
        if (!this.canCollide() || !dest.canCollide() || this.getRadius() == 0.0f || dest.getRadius() == 0.0f) {
            return false;
        }
        float dx = dest.x - this.x;
        float dy = dest.y - this.y;
        return Math.sqrt((dx *= dx) + (dy *= dy)) < (double)(this.getRadius() + dest.getRadius());
    }

    public final void tick() {
        try {
            this.doTick();
        }
        catch (Exception e) {
            System.err.println("Error ticking " + this);
            e.printStackTrace(System.err);
            this.remove();
        }
        if (this.isActive()) {
            this.x += this.vx;
            this.y += this.vy;
            if (this.autoRemove() && (this.x < -this.getRadius() * 4.0f || this.x > (float)Game.getWidth() + this.getRadius() * 4.0f || this.y < -this.getRadius() * 4.0f || this.y > (float)Game.getHeight() + this.getRadius() * 4.0f)) {
                this.remove();
            } else if (this.sprite != null) {
                this.sprite.setLocation((float)((int)this.x), (float)((int)this.y), 0.0f);
                this.sprite.setVisible(this.visible);
                this.sprite.setFlash(this.flash);
            } else {
                this.remove();
            }
        }
    }

    protected boolean autoRemove() {
        return true;
    }

    protected void doTick() {
    }

    public void update() {
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final float getVX() {
        return this.vx;
    }

    public final float getVY() {
        return this.vy;
    }

    public final void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public final void setVelocity(float vx, float vy) {
        this.vx = vx;
        this.vy = vy;
    }

    public final void setEvent(int event) {
        if (this.sprite != null) {
            this.sprite.setEvent(event);
        }
    }

    public final int getEvent() {
        if (this.sprite != null) {
            return this.sprite.getEvent();
        }
        return 0;
    }

    public void setFacing(int facing) {
    }
}

