/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import puppytron.AttackDrone;
import puppytron.DefenceDrone;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Player;
import puppytron.Res;
import puppytron.SmartBombShock;

public class EnemyBullet
extends Entity {
    private static final long serialVersionUID = 1L;
    private static final float BULLET_SPEED = 0.5f;
    private static final float BULLET_SPEED_PER_LEVEL = 0.01f;
    private static final float MAX_BULLET_SPEED = 2.0f;
    private static final int MAX_BULLETS = 24;
    private static int bullets;
    private transient Emitter emitter;
    private Sprite background;

    public EnemyBullet(float x, float y, float tx, float ty) {
        this.x = x;
        this.y = y;
        float dist = (float)Math.sqrt((x - tx) * (x - tx) + (y - ty) * (y - ty));
        float speed = Math.min(2.0f, 0.5f + 0.01f * (float)GameScreen.getLevel());
        this.vx = speed * (tx - x) / dist;
        this.vy = speed * (ty - y) / dist;
    }

    public static void reset() {
        bullets = 0;
    }

    protected void doSpawn() {
        ++bullets;
        this.sprite.setAppearance(Res.getEnemyBullet());
        this.sprite.setLayer(2);
        this.emitter = Res.getEnemyBulletEmitter().spawn((Screen)GameScreen.getInstance());
        this.emitter.setLocation(this.x, this.y);
        this.background = GameScreen.getInstance().allocateSprite(this);
        this.background.setAppearance((AnimatedAppearance)Res.getEnemyBulletBackground());
    }

    protected void doRespawn() {
        this.emitter = Res.getEnemyBulletEmitter().spawn((Screen)GameScreen.getInstance());
        this.emitter.setLocation(this.x, this.y);
    }

    protected void doRemove() {
        --bullets;
        if (this.emitter != null) {
            this.emitter.remove();
            this.emitter = null;
        }
        if (this.background != null) {
            this.background.deallocate();
            this.background = null;
        }
    }

    public boolean canCollide() {
        return true;
    }

    public float getRadius() {
        return 1.5f;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithEnemyBullet(this);
    }

    protected void onCollisionWithPlayer(Player player) {
        this.remove();
    }

    protected void onCollisionWithShockwave(SmartBombShock shock) {
        this.remove();
    }

    protected void onCollisionWithAttackDrone(AttackDrone drone) {
        this.remove();
    }

    protected void onCollisionWithDefenceDrone(DefenceDrone drone) {
        this.remove();
    }

    protected void doTick() {
        float newX = this.x + this.vx;
        float newY = this.y + this.vy;
        this.emitter.setLocation(newX, newY);
        this.background.setLocation((float)((int)newX), (float)((int)newY), 0.0f);
    }
}

