/*
 * Decompiled with CFR 0.152.
 */
package puppytron;

import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import puppytron.Bomb;
import puppytron.DroneBullet;
import puppytron.EnemyBullet;
import puppytron.Entity;
import puppytron.GameScreen;
import puppytron.Gidrah;
import puppytron.Mine;
import puppytron.Res;

public class DefenceDrone
extends Entity {
    private static final long serialVersionUID = 1L;
    private static final int MAX_WOUNDS = 10;
    private static final int SHOOT_INTERVAL = 28;
    private static final int SHOOT_INTERVAL_MULTIPLIER = 4;
    private static int numDrones = 0;
    private int wounds;
    private int tick;

    public DefenceDrone() {
        this.x = GameScreen.getPlayer().getX();
        this.y = GameScreen.getPlayer().getY();
    }

    protected void doSpawn() {
        ++numDrones;
        this.sprite.setAppearance((AnimatedAppearance)Res.getDefenceDroneAppearance());
    }

    public boolean canCollide() {
        return true;
    }

    public void onCollision(Entity entity) {
        entity.onCollisionWithDefenceDrone(this);
    }

    private void damage(int amount) {
        this.wounds += amount;
        if (this.wounds > 10) {
            this.kill();
        }
        Emitter emitter = Res.getDeflectEmitter().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
    }

    private void kill() {
        this.remove();
        Emitter emitter = Res.getPowerupRicochetEmitterFeature().spawn((Screen)GameScreen.getInstance());
        emitter.setLocation(this.x, this.y);
    }

    protected void onCollisionWithEnemyBullet(EnemyBullet enemyBullet) {
        this.damage(1);
    }

    protected void onCollisionWithGidrah(Gidrah gidrah) {
        if (gidrah.isDangerous()) {
            this.damage(gidrah.getLevel() + 1);
        }
    }

    protected void onCollisionWithMine(Mine mine) {
        this.damage(mine.getLevel() + 1);
    }

    protected void onCollisionWithBomb(Bomb bomb) {
        this.damage(10);
    }

    public float getRadius() {
        return 11.0f;
    }

    protected void doTick() {
        ++this.tick;
        if (this.tick > 28 + GameScreen.getPlayer().getRepeatRate() * 4) {
            this.tick = 0;
            this.shoot();
        }
    }

    private void shoot() {
        Gidrah target = GameScreen.getRandomGidrah();
        if (target == null) {
            return;
        }
        DroneBullet b = new DroneBullet(this.getX(), this.getY(), target.getX(), target.getY(), GameScreen.getPlayer().getBulletPower());
        b.spawn(GameScreen.getInstance());
    }

    protected void doRemove() {
        --numDrones;
    }

    protected void doRespawn() {
        ++numDrones;
    }
}

