/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.eval;

import java.math.BigDecimal;
import java.util.Map;
import net.java.dev.eval.Operator;
import net.java.dev.eval.Type;

final class Operation {
    final Type type;
    final Operator operator;
    final Object operand1;
    final Object operand2;
    final Object operand3;

    private Operation(Type type, Operator operator, Object operand1, Object operand2, Object operand3) {
        this.type = type;
        this.operator = operator;
        this.operand1 = operand1;
        this.operand2 = operand2;
        this.operand3 = operand3;
    }

    static Operation nopOperationfactory(Object operand) {
        return new Operation(Operator.NOP.resultType, Operator.NOP, operand, null, null);
    }

    static Object unaryOperationfactory(Operator operator, Object operand) {
        Operation.validateOperandType(operand, operator.operandType);
        if (operand instanceof BigDecimal) {
            return operator.perform((BigDecimal)operand, null, null);
        }
        return new Operation(operator.resultType, operator, operand, null, null);
    }

    static Object binaryOperationfactory(Operator operator, Object operand1, Object operand2) {
        Operation.validateOperandType(operand1, operator.operandType);
        Operation.validateOperandType(operand2, operator.operandType);
        if (operand1 instanceof BigDecimal && operand2 instanceof BigDecimal) {
            return operator.perform((BigDecimal)operand1, (BigDecimal)operand2, null);
        }
        return new Operation(operator.resultType, operator, operand1, operand2, null);
    }

    static Object tenaryOperationFactory(Operator operator, Object operand1, Object operand2, Object operand3) {
        Operation.validateOperandType(operand1, Type.BOOLEAN);
        Operation.validateOperandType(operand2, Type.ARITHMETIC);
        Operation.validateOperandType(operand3, Type.ARITHMETIC);
        if (operand1 instanceof BigDecimal) {
            return ((BigDecimal)operand1).signum() != 0 ? operand2 : operand3;
        }
        return new Operation(Type.ARITHMETIC, operator, operand1, operand2, operand3);
    }

    BigDecimal eval(Map variables) {
        switch (this.operator.numberOfOperands) {
            case 3: {
                return this.operator.perform(this.evaluateOperand(this.operand1, variables), this.evaluateOperand(this.operand2, variables), this.evaluateOperand(this.operand3, variables));
            }
            case 2: {
                return this.operator.perform(this.evaluateOperand(this.operand1, variables), this.evaluateOperand(this.operand2, variables), null);
            }
        }
        return this.operator.perform(this.evaluateOperand(this.operand1, variables), null, null);
    }

    private BigDecimal evaluateOperand(Object operand, Map variables) {
        if (operand instanceof Operation) {
            return ((Operation)operand).eval(variables);
        }
        if (operand instanceof String) {
            BigDecimal value;
            if (variables == null || (value = (BigDecimal)variables.get(operand)) == null) {
                throw new RuntimeException("no value for variable \"" + operand + "\"");
            }
            return value;
        }
        return (BigDecimal)operand;
    }

    private static void validateOperandType(Object operand, Type type) {
        Type operandType;
        if (operand instanceof Operation && (operandType = ((Operation)operand).type) != type) {
            throw new RuntimeException("cannot use " + operandType.name + " operands with " + type.name + " operators");
        }
    }

    public String toString() {
        switch (this.operator.numberOfOperands) {
            case 3: {
                return "(" + this.operand1 + this.operator.string + this.operand2 + ":" + this.operand3 + ")";
            }
            case 2: {
                return "(" + this.operand1 + this.operator.string + this.operand2 + ")";
            }
        }
        return "(" + this.operator.string + this.operand1 + ")";
    }
}

