/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.video;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Clock;
import com.fluendo.jst.ClockProvider;
import com.fluendo.jst.Event;
import com.fluendo.jst.Sink;
import com.fluendo.jst.SystemClock;
import com.fluendo.jst.WaitStatus;
import com.fluendo.utils.Debug;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.openal.ALStreamInstance;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.lwjgl.Sys;

public class OpenALSink
extends Sink
implements ClockProvider {
    private static final int AL_PLAYBACK_RATE = 44100;
    private final SoundPlayer soundPlayer;
    private SoundEffect soundEffect;
    private ALStream stream;
    private ALStreamInstance streamInstance;
    private PipedInputStream pipedIn;
    private PipedOutputStream pipedOut;
    private final AudioClock audioClock = new AudioClock();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.video.OpenALSink");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public OpenALSink(SoundPlayer soundPlayer) {
        this.soundPlayer = soundPlayer;
    }

    public Clock provideClock() {
        return this.audioClock;
    }

    protected WaitStatus doSync(long time) {
        return WaitStatus.newOK();
    }

    protected boolean doEvent(Event event) {
        switch (event.getType()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
        }
        System.out.println("OpenALSink.doEvent " + event);
        return true;
    }

    protected int render(Buffer buf) {
        try {
            this.pipedOut.write(buf.data, buf.offset, buf.length);
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return -5;
        }
    }

    protected boolean setCapsFunc(Caps caps) {
        System.out.println("OpenALSink.setCapsFunc " + caps);
        return true;
    }

    protected int changeState(int transition) {
        switch (transition) {
            case 18: {
                this.pipedOut = new PipedOutputStream();
                try {
                    this.pipedIn = new PipedInputStream(this.pipedOut);
                }
                catch (IOException e1) {
                    Debug.warning("Failed to create piped input stream " + e1);
                    return 0;
                }
                this.stream = new ALStream(this.pipedIn);
                this.stream.create();
                this.soundEffect = this.soundPlayer.allocate(this.stream, (Object)this);
                if (this.soundEffect != null) break;
                Debug.warning("Failed to create sound effect");
                this.stream.destroy();
                this.stream = null;
                return 0;
            }
            case 35: {
                this.audioClock.setStarted(true);
                this.soundEffect.play(this);
                break;
            }
            case 50: {
                this.audioClock.setStarted(false);
                this.soundEffect.pause(this);
                break;
            }
            case 33: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        int result = super.changeState(transition);
        switch (transition) {
            case 33: {
                if (this.pipedIn != null) {
                    try {
                        this.pipedIn.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.pipedIn = null;
                }
                if (this.pipedOut != null) {
                    try {
                        this.pipedOut.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.pipedOut = null;
                }
                if (this.soundEffect != null) {
                    this.soundEffect.stop(this);
                    this.soundEffect = null;
                }
                if (this.stream == null) break;
                this.stream.destroy();
                this.stream = null;
            }
        }
        return result;
    }

    public String getFactoryName() {
        return "openalsink";
    }

    private class AudioClock
    extends SystemClock {
        private long lastTime = -1L;
        private long diff = -1L;
        private boolean started = false;

        private AudioClock() {
        }

        public void setStarted(boolean s) {
            this.started = s;
            if (this.started) {
                this.diff = -1L;
                this.lastTime = -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long getInternalTime() {
            long result;
            ALStreamInstance aLStreamInstance = OpenALSink.this.streamInstance;
            synchronized (aLStreamInstance) {
                block8: {
                    if (OpenALSink.this.streamInstance != null && OpenALSink.this.streamInstance.isCreated()) break block8;
                    return 0L;
                }
                long samples = 1L;
                long timePos = samples * 1000000L / 44100L;
                if (this.started) {
                    long now = Sys.getTime() / Sys.getTimerResolution() * 1000L;
                    if (this.diff == -1L) {
                        this.diff = now;
                    }
                    if (timePos != this.lastTime) {
                        this.lastTime = timePos;
                        this.diff = now - timePos;
                    }
                    result = now - this.diff;
                } else {
                    result = timePos;
                }
            }
            return result;
        }
    }
}

