/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import com.shavenpuppy.jglib.Resource;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.java.dev.eval.Expression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XMLUtil {
    private static final Map vars;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    static {
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("com.shavenpuppy.jglib.util.XMLUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        vars = new HashMap();
    }

    private XMLUtil() {
    }

    public static void putVar(String key, String value) {
        vars.put(key, value);
    }

    private static String decode(String in) throws Exception {
        if (in != null && in.length() > 1 && in.charAt(0) == '$') {
            String key = in.substring(1);
            String val = (String)vars.get(key);
            if (val == null) {
                throw new Exception("Unknown variable " + in);
            }
            return val;
        }
        return in;
    }

    public static String parse(String in) throws Exception {
        int dollarPosition;
        if (in.length() < 2 || in.charAt(0) != '=') {
            return in;
        }
        String original = in;
        int minPos = 0;
        while ((dollarPosition = in.indexOf(36, minPos)) != -1) {
            int endPosition = in.length();
            int i = dollarPosition + 1;
            while (i < in.length()) {
                char c = in.charAt(i);
                if (c == '+' || c == '-' || c == '/' || c == '*' || c == ',' || c == '$' || c == '(' || c == ')' || Character.isWhitespace(c)) {
                    endPosition = i;
                    break;
                }
                ++i;
            }
            String token = in.substring(dollarPosition, endPosition);
            try {
                String decoded = XMLUtil.decode(token);
                if (!decoded.equals(token)) {
                    in = String.valueOf(in.substring(0, dollarPosition)) + decoded + in.substring(endPosition);
                    continue;
                }
                minPos = dollarPosition + 1;
            }
            catch (Exception e) {
                System.err.println("Failed to parse " + original);
                throw e;
            }
        }
        StringBuffer ret = new StringBuffer(in.length() * 2);
        StringTokenizer st = new StringTokenizer(in.substring(1), ",");
        while (st.hasMoreTokens()) {
            String subElement = st.nextToken().trim();
            if (subElement.charAt(0) == '=') {
                subElement = subElement.substring(1);
            }
            try {
                ret.append(String.valueOf(Expression.eval(subElement, vars).toString()));
            }
            catch (Exception e) {
                System.err.println("Failed to parse " + original + " (sent " + subElement + " to parser)");
                throw e;
            }
            if (!st.hasMoreTokens()) continue;
            ret.append(',');
        }
        return ret.toString();
    }

    public static boolean hasAttribute(Element element, String attribute) {
        String s = element.getAttribute(attribute);
        return s != null && !"".equals(s);
    }

    public static boolean hasChild(Element element, String child) throws Exception {
        NodeList nodes = element.getChildNodes();
        Element ret = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equals(child) && childNode.getNodeType() == 1) {
                if (ret != null) {
                    throw new Exception("Child element '" + child + "' present multiple times");
                }
                ret = (Element)childNode;
            }
            ++i;
        }
        return ret != null;
    }

    public static Element getChild(Element element, String child) throws Exception {
        NodeList nodes = element.getChildNodes();
        Element ret = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equalsIgnoreCase(child) && childNode.getNodeType() == 1) {
                if (ret != null) {
                    throw new Exception("Child element '" + child + "' present multiple times");
                }
                ret = (Element)childNode;
            }
            ++i;
        }
        if (ret == null) {
            return null;
        }
        return ret;
    }

    public static Element getFirstChild(Element element, String child) throws Exception {
        NodeList nodes = element.getChildNodes();
        Element ret = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equalsIgnoreCase(child) && childNode.getNodeType() == 1) {
                ret = (Element)childNode;
                return ret;
            }
            ++i;
        }
        return null;
    }

    public static List getChildren(Element element, String name) throws Exception {
        NodeList nodes = element.getChildNodes();
        ArrayList<Node> ret = new ArrayList<Node>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeName().equals(name) && childNode.getNodeType() == 1) {
                ret.add(childNode);
            }
            ++i;
        }
        return ret;
    }

    public static List getChildren(Element element) throws Exception {
        NodeList nodes = element.getChildNodes();
        ArrayList<Node> ret = new ArrayList<Node>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeType() == 1) {
                ret.add(childNode);
            }
            ++i;
        }
        return ret;
    }

    public static boolean getBoolean(Element element, String attribute) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return Boolean.valueOf(s);
    }

    public static boolean getOptionalBoolean(Element element, String attribute, boolean defaultValue) {
        String s = element.getAttribute(attribute);
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static boolean getBoolean(Element element, String attribute, boolean defaultValue) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static float getFloat(Element element, String attribute) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return Float.parseFloat(s);
    }

    public static float getFloat(Element element, String attribute, float defaultValue) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    public static int getInt(Element element, String attribute) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return (int)Float.parseFloat(s);
    }

    public static int getOptionalInt(Element element, String attribute, int defaultValue) {
        if (element.hasAttribute(attribute)) {
            String s = element.getAttribute(attribute);
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            return Integer.parseInt(s);
        }
        return defaultValue;
    }

    public static int getInt(Element element, String attribute, int defaultValue) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return (int)Float.parseFloat(s);
    }

    public static String getString(Element element, String attribute) throws Exception {
        String s;
        try {
            s = XMLUtil.parse(element.getAttribute(attribute));
        }
        catch (Exception e) {
            System.err.println("Failed to parse attribute '" + attribute + "' in element " + element.getNodeName());
            throw e;
        }
        if (s == null || "".equals(s)) {
            throw new Exception("Attribute '" + attribute + "' has not been specified for " + element.getNodeName());
        }
        return s;
    }

    public static String getString(Element element, String attribute, String defaultValue) throws Exception {
        String s = XMLUtil.parse(element.getAttribute(attribute));
        if (s == null || "".equals(s)) {
            return defaultValue;
        }
        return s;
    }

    public static String getText(Element element, String defaultText) throws Exception {
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Text text;
            String ret;
            Node child = children.item(i);
            if (child instanceof Text && !(ret = (text = (Text)child).getData().trim()).equals("")) {
                ret = ret.replaceAll("\\\\n", "\n");
                ret = ret.replaceAll("\\\\t", "\t");
                return ret;
            }
            ++i;
        }
        return defaultText;
    }

    /*
     * Exception decompiling
     */
    public static void grabXMLAttributes(Resource.Loader loader, Object destination, Class root, Element element) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadChildResources(Resource resource, Element resourceElement, Resource.Loader loader) throws Exception {
        Class<?> clazz;
        Class<?> clazz2 = resource.getClass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Field[] fields = clazz2.getDeclaredFields();
                int i = 0;
                while (i < fields.length) {
                    Object value;
                    Field f = fields[i];
                    f.setAccessible(true);
                    if (!(Modifier.isFinal(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || (value = f.get(resource)) != null)) {
                        Element childElement;
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("com.shavenpuppy.jglib.Resource");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (clazz3.isAssignableFrom(f.getType()) && (childElement = XMLUtil.getFirstChild(resourceElement, f.getName())) != null) {
                            Resource newResource = (Resource)f.getType().newInstance();
                            newResource.load(childElement, loader);
                            f.set(resource, newResource);
                        }
                    }
                    ++i;
                }
                clazz2 = clazz2.getSuperclass();
            }
            if ((clazz = class$1) != null) continue;
            try {
                clazz = Class.forName("com.shavenpuppy.jglib.Resource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(clazz2));
        XMLUtil.getChildren(resourceElement);
    }

    public static float getNormalisedFloat(Element element, String string, float defaultValue) throws Exception {
        if (!($assertionsDisabled || defaultValue >= 0.0f && defaultValue <= 1.0f)) {
            throw new AssertionError();
        }
        float val = XMLUtil.getFloat(element, string, defaultValue);
        val = val < 0.0f ? 0.0f : val;
        val = val > 1.0f ? 1.0f : val;
        return val;
    }
}

