/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import org.lwjgl.opengl.Display;

public class Util {
    private static final Random random;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.util.Util");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        random = new Random();
    }

    private Util() {
    }

    public static int nextPowerOf2(int n) {
        int x = 1;
        while (x < n) {
            x <<= 1;
        }
        return x;
    }

    public static int random(int min, int max) {
        if (max - min == 0) {
            return min;
        }
        int rmin = Math.min(max, min);
        int rmax = Math.max(max, min);
        return random.nextInt(1 + rmax - rmin) + rmin;
    }

    public static float random() {
        return random.nextFloat();
    }

    public static void setSeed(long seed) {
        random.setSeed(seed);
    }

    public static long getMachineSeed() {
        long ret = 0L;
        int lsb = 0;
        int msb = 0;
        Properties props = System.getProperties();
        Iterator<Map.Entry<Object, Object>> i = props.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            lsb ^= entry.getKey().hashCode();
            lsb ^= entry.getValue().hashCode();
        }
        String adapter = Display.getAdapter();
        String version = Display.getVersion();
        msb ^= adapter != null ? adapter.hashCode() : 0;
        ret = (long)lsb | (long)(msb ^= version != null ? version.hashCode() : 0) << 32;
        return ret;
    }

    public static float angleFromDirection(float dirX, float dirY) {
        if (dirX == 0.0f) {
            return 0.0f;
        }
        float inv = dirY / dirX;
        float ang = (float)Math.atan(inv);
        if (dirX < 0.0f) {
            ang += (float)Math.PI;
        }
        return ang -= 1.5707964f;
    }

    public static float slerpAngle(float angle1, float angle2, float weight) {
        if (!($assertionsDisabled || weight >= 0.0f && weight <= 1.0f)) {
            throw new AssertionError();
        }
        float oneMinus = 1.0f - weight;
        if ((double)Math.abs(angle1 - angle2) > Math.PI) {
            float a = angle1;
            float b = angle2;
            float twoPi = (float)Math.PI * 2;
            if (weight < 0.5f) {
                b = a > b ? (b += twoPi) : (b -= twoPi);
            } else {
                a = b > a ? (a += twoPi) : (a -= twoPi);
            }
            return a * weight + b * oneMinus;
        }
        return angle1 * weight + angle2 * oneMinus;
    }

    public static int moveToAngle(int currentAngle, int targetAngle, int rate) {
        int diff = Math.abs(targetAngle - currentAngle);
        int newAngle = diff < rate ? targetAngle : (diff > 32768 ? (targetAngle < currentAngle ? currentAngle + rate : currentAngle - rate) : (targetAngle < currentAngle ? currentAngle - rate : currentAngle + rate));
        while (newAngle < 0) {
            newAngle += 65536;
        }
        return newAngle & 0xFFFF;
    }

    public static int getAngleDifference(int currentAngle, int targetAngle) {
        currentAngle &= 0xFFFF;
        while (currentAngle < 0) {
            currentAngle += 65536;
        }
        targetAngle &= 0xFFFF;
        while (targetAngle < 0) {
            targetAngle += 65536;
        }
        int diff = Math.abs(targetAngle - currentAngle);
        if (diff <= 32768) {
            return diff;
        }
        if (targetAngle < currentAngle) {
            return targetAngle + 65536 - currentAngle;
        }
        return currentAngle + 65536 - targetAngle;
    }

    public static double getAngleDifference(double currentAngle, double targetAngle) {
        while (currentAngle >= Math.PI * 2) {
            currentAngle -= Math.PI * 2;
        }
        while (targetAngle >= Math.PI * 2) {
            targetAngle -= Math.PI * 2;
        }
        while (currentAngle < 0.0) {
            currentAngle += Math.PI * 2;
        }
        while (targetAngle < 0.0) {
            targetAngle += Math.PI * 2;
        }
        double diff = Math.abs(targetAngle - currentAngle);
        if (diff <= Math.PI) {
            return diff;
        }
        if (targetAngle < currentAngle) {
            return targetAngle + Math.PI * 2 - currentAngle;
        }
        return currentAngle + Math.PI * 2 - targetAngle;
    }

    public static double moveToAngle(double currentAngle, double targetAngle, double rate) {
        double diff = Math.abs(targetAngle - currentAngle);
        double newAngle = diff < rate ? targetAngle : (diff > Math.PI ? (targetAngle < currentAngle ? currentAngle + rate : currentAngle - rate) : (targetAngle < currentAngle ? currentAngle - rate : currentAngle + rate));
        while (newAngle < 0.0) {
            newAngle += Math.PI * 2;
        }
        while (newAngle > Math.PI * 2) {
            newAngle -= Math.PI * 2;
        }
        return newAngle;
    }

    public static double distanceFromLineToPoint(double x1, double y1, double z1, double x2, double y2, double z2, double px, double py, double pz) {
        double ddx = x2 - x1;
        double ddy = y2 - y1;
        double ddz = z2 - z1;
        double lineMag = ddx * ddx + ddy * ddy + ddz * ddz;
        double u = ((px - x1) * ddx + (py - y1) * ddy + (pz - z1) * ddz) / lineMag;
        if (u < 0.0 || u > 1.0) {
            return -1.0;
        }
        double ix = x1 + u * (x2 - x1);
        double iy = y1 + u * (y2 - y1);
        double iz = z1 + u * (z2 - z1);
        ddx = ix - px;
        ddy = iy - py;
        ddz = iz - pz;
        return Math.sqrt(ddx * ddx + ddy * ddy + ddz * ddz);
    }

    public static double distanceFromLineToPoint(double x1, double y1, double x2, double y2, double px, double py) {
        return Util.distanceFromLineToPoint(x1, y1, 0.0, x2, y2, 0.0, px, py, 0.0);
    }
}

