/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.w3c.dom.Element;

public class RepeatCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int newSequenceNumber;
    private String id;

    public boolean execute(Animated target, int tickRate) {
        target.addLoop(-1);
        if (target.getLoop() > 0) {
            if (this.id != null) {
                int s = target.getAnimation().getLabel(this.id);
                if (s != -1) {
                    target.setSequence(s);
                } else {
                    System.out.println("Label " + this.id + " not found for repeat in " + target.getAnimation());
                }
            } else {
                target.setSequence(this.newSequenceNumber);
            }
        } else {
            target.setSequence(target.getSequence() + 1);
        }
        return true;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        if (XMLUtil.hasAttribute(element, "id")) {
            this.id = XMLUtil.getString(element, "id");
        } else {
            this.newSequenceNumber = Integer.parseInt(element.getAttribute("seq"));
        }
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.id != null) {
            writer.writeAttribute("id", this.id, true);
        } else {
            writer.writeAttribute("seq", this.newSequenceNumber, true);
        }
    }
}

