/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Transparent;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.w3c.dom.Element;

public class AlphaCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int alpha;
    private int duration;
    private boolean delta;

    public boolean execute(Animated target, int tickRate) {
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick == 0) {
            Transparent sprite = (Transparent)((Object)target);
            if (this.delta) {
                sprite.adjustAlpha(this.alpha);
            } else {
                sprite.setAlpha(this.alpha);
            }
        }
        if (currentTick >= this.duration) {
            target.setSequence(++currentSequence);
            target.setTick(0);
            return true;
        }
        target.setTick(currentTick + tickRate);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        String s = XMLUtil.getString(element, "alpha");
        if (s.startsWith("+")) {
            this.delta = true;
            this.alpha = Integer.parseInt(s.substring(1));
        } else {
            this.alpha = Integer.parseInt(s);
        }
        this.duration = XMLUtil.getInt(element, "d", 0);
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.delta) {
            writer.writeAttribute("alpha", "+" + this.alpha);
        } else {
            writer.writeAttribute("alpha", this.alpha, true);
        }
        writer.writeAttribute("d", this.duration, true);
    }
}

