/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.resources;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.resources.ColorSequenceWrapper;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ColorSequenceResource
extends Resource
implements ColorSequenceWrapper {
    public static final long serialVersionUID = 1L;
    private ArrayList sequence;
    private transient int duration;
    private int style;
    private transient int[] index;
    public static final int STOP = 0;
    public static final int REPEAT = 1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.resources.ColorSequenceResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ColorSequenceResource(SequenceEntry[] entries, int style) {
        this.sequence = new ArrayList(entries.length);
        int i = 0;
        while (i < entries.length) {
            this.sequence.add(entries[i]);
            ++i;
        }
        this.style = style;
        this.calcDuration();
    }

    public ColorSequenceResource() {
    }

    public ColorSequenceResource(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        NodeList children = element.getElementsByTagName("color");
        int n = children.getLength();
        this.sequence = new ArrayList(n);
        int i = 0;
        while (i < n) {
            Element colorElement = (Element)children.item(i);
            SequenceEntry seq = new SequenceEntry();
            seq.color = (ReadableColor)new Color(Integer.parseInt(colorElement.getAttribute("r")), Integer.parseInt(colorElement.getAttribute("g")), Integer.parseInt(colorElement.getAttribute("b")), Integer.parseInt(colorElement.getAttribute("a")));
            seq.duration = Integer.parseInt(colorElement.getAttribute("d"));
            seq.fade = Integer.parseInt(colorElement.getAttribute("f"));
            this.sequence.add(seq);
            ++i;
        }
        this.style = ColorSequenceResource.decode(XMLUtil.getString(element, "style", "stop"));
        this.calcDuration();
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        writer.writeAttribute("style", this.style == 0 ? "stop" : "repeat");
        Iterator i = this.sequence.iterator();
        while (i.hasNext()) {
            SequenceEntry se = (SequenceEntry)i.next();
            writer.writeTag("color");
            writer.writeAttribute("r", se.color.getRed());
            writer.writeAttribute("g", se.color.getGreen());
            writer.writeAttribute("b", se.color.getBlue());
            writer.writeAttribute("a", se.color.getAlpha());
            writer.writeAttribute("d", se.duration);
            writer.writeAttribute("f", se.fade);
            writer.closeTag();
        }
    }

    public static int decode(String styleS) throws Exception {
        if (styleS.equalsIgnoreCase("repeat")) {
            return 1;
        }
        if (styleS.equalsIgnoreCase("stop")) {
            return 0;
        }
        throw new Exception("Illegal style '" + styleS + "'");
    }

    public boolean isLooped() {
        return this.style == 1;
    }

    public Color getColor(int time, Color color) {
        SequenceEntry seq;
        int fade;
        int idx;
        if (this.index == null) {
            this.calcDuration();
        }
        if (color == null) {
            color = new Color();
        }
        if (time < 0) {
            time = 0;
        }
        if (this.style == 1) {
            time %= this.duration;
        }
        if ((idx = Arrays.binarySearch(this.index, time)) < 0) {
            idx = -2 - idx;
        }
        if (idx == this.index.length) {
            --idx;
        }
        if ((time -= this.index[idx]) <= (fade = (seq = (SequenceEntry)this.sequence.get(idx)).duration - seq.fade) || idx == this.index.length - 1 && this.style == 0) {
            color.setColor(seq.color);
        } else {
            float fadeRatio = (float)(time - fade) / (float)seq.fade;
            ReadableColor a = seq.color;
            idx = idx == this.index.length - 1 ? 0 : ++idx;
            ReadableColor b = ((SequenceEntry)this.sequence.get(idx)).color;
            color.set((int)LinearInterpolator.instance.interpolate((float)a.getRed(), (float)b.getRed(), fadeRatio), (int)LinearInterpolator.instance.interpolate((float)a.getGreen(), (float)b.getGreen(), fadeRatio), (int)LinearInterpolator.instance.interpolate((float)a.getBlue(), (float)b.getBlue(), fadeRatio), (int)LinearInterpolator.instance.interpolate((float)a.getAlpha(), (float)b.getAlpha(), fadeRatio));
        }
        return color;
    }

    private void calcDuration() {
        this.duration = 0;
        this.index = new int[this.sequence.size()];
        int count = 0;
        Iterator i = this.sequence.iterator();
        while (i.hasNext()) {
            SequenceEntry seq = (SequenceEntry)i.next();
            this.index[count++] = this.duration;
            this.duration += seq.duration;
        }
    }

    protected void doDestroy() {
        this.index = null;
    }

    public final int getDuration() {
        if (!$assertionsDisabled && !this.isCreated()) {
            throw new AssertionError();
        }
        return this.duration;
    }

    public boolean isFinished(int tick) {
        if (this.isLooped()) {
            return false;
        }
        return tick >= this.duration;
    }

    public static class SequenceEntry
    implements Serializable {
        public static final long serialVersionUID = 1L;
        private ReadableColor color;
        private int duration;
        private int fade;

        private SequenceEntry() {
        }

        public SequenceEntry(ReadableColor color, int duration, int fade) {
            this.color = color;
            this.duration = duration;
            this.fade = fade;
        }
    }
}

