/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLGlyph;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.util.Decodeable;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritableDimension;
import org.lwjgl.util.WritablePoint;

public class GLTextArea
implements GLRenderable,
SimpleRenderable,
WritablePoint,
WritableDimension {
    private static final long serialVersionUID = 1L;
    protected GLFont font;
    private final StringBuffer text = new StringBuffer();
    private GLGlyph[] glyph;
    private int numGlyphs;
    private final Dimension size = new Dimension();
    private int textHeight;
    private final Point location = new Point();
    private TextLayout.Format format = TextLayout.WORD_WRAP;
    private TextLayout.HorizontalAlignment alignment = TextLayout.LEFT;
    private VerticalAlignment verticalAlignment = TOP;
    private boolean changed = true;
    private boolean coloured;
    private ReadableColor topColour;
    private ReadableColor bottomColour;
    private int alpha = 255;
    private int leading;
    public static final VerticalAlignment TOP;
    public static final VerticalAlignment BOTTOM;
    public static final VerticalAlignment CENTERED;
    public static final VerticalAlignment BASELINE;
    private String oldText;
    private boolean editing;
    private boolean cursorVisible;
    private int cursorPos;
    private int flashTick;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.shavenpuppy.jglib.opengl.GLTextArea");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        TOP = new VerticalAlignment("Top"){
            private static final long serialVersionUID = 1L;

            private Object readResolve() throws ObjectStreamException {
                return TOP;
            }
        };
        BOTTOM = new VerticalAlignment("Bottom"){
            private static final long serialVersionUID = 1L;

            private Object readResolve() throws ObjectStreamException {
                return BOTTOM;
            }
        };
        CENTERED = new VerticalAlignment("Centered"){
            private static final long serialVersionUID = 1L;

            private Object readResolve() throws ObjectStreamException {
                return CENTERED;
            }
        };
        BASELINE = new VerticalAlignment("Baseline"){
            private static final long serialVersionUID = 1L;

            private Object readResolve() throws ObjectStreamException {
                return BASELINE;
            }
        };
    }

    public GLFont getFont() {
        return this.font;
    }

    public Rectangle getGlyphBounds(int index, Rectangle dest) {
        this.layout();
        if (dest == null) {
            dest = new Rectangle();
        }
        if (index < 0) {
            dest.setBounds(this.location.getX(), this.location.getY(), 0, this.font.getAscent() + this.font.getDescent());
        } else {
            GLGlyph g = this.glyph[index];
            if (g != null) {
                dest.setBounds(g.xpos + this.location.getX(), g.ypos + this.location.getY(), g.getAdvance(), this.font.getAscent() + this.font.getDescent());
            }
        }
        return dest;
    }

    public GLGlyph getGlyph(int index) {
        return this.glyph[index];
    }

    public void setLeading(int leading) {
        this.leading = leading;
        this.changed = true;
    }

    public int getLeading() {
        return this.leading;
    }

    private void layout() {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        if (!$assertionsDisabled && this.text == null) {
            throw new AssertionError((Object)(this + " has no text"));
        }
        if (!$assertionsDisabled && this.size == null) {
            throw new AssertionError((Object)(this + " has no size"));
        }
        if (!$assertionsDisabled && this.font == null) {
            throw new AssertionError((Object)(this + " has no font"));
        }
        TextLayout textLayout = new TextLayout(this.font.getFont(), this.font.getScale(), this.leading, this.text.toString(), this.size.getWidth(), this.format, this.alignment);
        if (this.editing) {
            textLayout.setKeepWhiteSpace(true);
        }
        this.textHeight = textLayout.getHeight();
        final int ty = this.verticalAlignment == TOP ? this.size.getHeight() : (this.verticalAlignment == CENTERED ? this.textHeight + (this.size.getHeight() - this.textHeight) / 2 : (this.verticalAlignment == BASELINE ? this.font.getAscent() : this.textHeight));
        textLayout.apply(new TextLayout.Target(){

            public void setNumGlyphs(int n) {
                GLTextArea.this.numGlyphs = n;
                if (GLTextArea.this.glyph == null || GLTextArea.this.glyph.length < GLTextArea.this.numGlyphs || GLTextArea.this.glyph.length > GLTextArea.this.numGlyphs * 2) {
                    GLTextArea.this.glyph = null;
                    GLTextArea.this.glyph = new GLGlyph[GLTextArea.this.numGlyphs];
                }
            }

            public void setGlyph(int index, Glyph g, int x, int y) {
                if (GLTextArea.this.glyph[index] == null) {
                    ((GLTextArea)GLTextArea.this).glyph[index] = new GLGlyph(GLTextArea.this.font.getTexture(), g, GLTextArea.this.font.getScale());
                } else {
                    GLTextArea.this.glyph[index].init(GLTextArea.this.font.getTexture(), g);
                }
                GLTextArea.this.glyph[index].setLocation(x + GLTextArea.this.location.getX(), y + ty + GLTextArea.this.location.getY());
            }
        });
    }

    public void render(SimpleRenderer renderer) {
        this.layout();
        renderer.glRender(new GLRenderable(){

            public void render() {
                GLTextArea.this.font.getTexture().render();
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            }
        });
        renderer.glBegin(7);
        this.renderGlyphs(renderer);
        renderer.glEnd();
        if (this.cursorVisible && this.editing) {
            int cursorY;
            int cursorX;
            renderer.glRender(new GLRenderable(){

                public void render() {
                    GL11.glDisable((int)3553);
                }
            });
            if (this.cursorPos <= 0 || this.glyph.length == 0) {
                this.cursorPos = 0;
                cursorX = 0;
                cursorY = this.getHeight() - this.font.getAscent();
            } else {
                if (this.cursorPos > this.glyph.length) {
                    this.cursorPos = this.glyph.length;
                }
                cursorX = this.glyph[this.cursorPos - 1].getXpos() + this.glyph[this.cursorPos - 1].getWidth();
                cursorY = this.glyph[this.cursorPos - 1].getYpos();
            }
            renderer.glBegin(7);
            renderer.glColor(this.bottomColour);
            renderer.glVertex2f(cursorX, cursorY - this.font.getDescent());
            renderer.glVertex2f(cursorX + 4, cursorY - this.font.getDescent());
            renderer.glColor(this.topColour);
            renderer.glVertex2f(cursorX + 4, cursorY + this.font.getHeight() - this.font.getDescent());
            renderer.glVertex2f(cursorX, cursorY + this.font.getHeight() - this.font.getDescent());
            renderer.glEnd();
        }
    }

    public void render() {
        this.render(SimpleRenderer.GL_RENDERER);
    }

    protected void renderGlyphs(SimpleRenderer renderer) {
        int i = 0;
        while (i < this.numGlyphs) {
            if (this.glyph[i] != null) {
                if (this.coloured) {
                    this.glyph[i].render(this.topColour, this.bottomColour, this.alpha, renderer);
                } else {
                    this.glyph[i].render(renderer);
                }
            }
            ++i;
        }
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    public void setFont(GLFont font) {
        if (this.font == font) {
            return;
        }
        this.font = font;
        this.setLeading(font.getLeading());
        this.changed = true;
    }

    public void setHorizontalAlignment(TextLayout.HorizontalAlignment alignment) {
        if (this.alignment == alignment) {
            return;
        }
        this.alignment = alignment;
        this.changed = true;
    }

    public void setVerticalAlignment(VerticalAlignment valignment) {
        if (this.verticalAlignment == valignment) {
            return;
        }
        this.verticalAlignment = valignment;
        this.changed = true;
    }

    public int getTextHeight() {
        this.layout();
        return this.textHeight;
    }

    public TextLayout.Format getFormat() {
        return this.format;
    }

    public void setFormat(TextLayout.Format format) {
        if (this.format == format) {
            return;
        }
        this.format = format;
        this.changed = true;
    }

    public GLTextArea append(boolean b) {
        this.changed = true;
        this.text.append(b);
        return this;
    }

    public GLTextArea append(char c) {
        this.changed = true;
        this.text.append(c);
        return this;
    }

    public GLTextArea append(char[] str) {
        this.changed = true;
        this.text.append(str);
        return this;
    }

    public GLTextArea append(char[] str, int offset, int len) {
        this.changed = true;
        this.text.append(str, offset, len);
        return this;
    }

    public GLTextArea append(double d) {
        this.changed = true;
        this.text.append(d);
        return this;
    }

    public GLTextArea append(float f) {
        this.changed = true;
        this.text.append(f);
        return this;
    }

    public GLTextArea append(int i) {
        this.changed = true;
        this.text.append(i);
        return this;
    }

    public GLTextArea append(Object obj) {
        this.changed = true;
        this.text.append(obj);
        return this;
    }

    public GLTextArea append(String str) {
        this.changed = true;
        this.text.append(str);
        return this;
    }

    public GLTextArea append(StringBuffer sb) {
        this.changed = true;
        this.text.append(sb);
        return this;
    }

    public GLTextArea append(long l) {
        this.changed = true;
        this.text.append(l);
        return this;
    }

    public int capacity() {
        return this.text.capacity();
    }

    public GLTextArea delete(int start, int end) {
        this.changed = true;
        this.text.delete(start, end);
        return this;
    }

    public GLTextArea deleteCharAt(int index) {
        this.changed = true;
        this.text.deleteCharAt(index);
        return this;
    }

    public GLTextArea insert(int offset, boolean b) {
        this.changed = true;
        this.text.insert(offset, b);
        return this;
    }

    public GLTextArea insert(int offset, char c) {
        this.changed = true;
        this.text.insert(offset, c);
        return this;
    }

    public GLTextArea insert(int offset, char[] str) {
        this.changed = true;
        this.text.insert(offset, str);
        return this;
    }

    public GLTextArea insert(int index, char[] str, int offset, int len) {
        this.changed = true;
        this.text.insert(index, str, offset, len);
        return this;
    }

    public GLTextArea insert(int offset, double d) {
        this.changed = true;
        this.text.insert(offset, d);
        return this;
    }

    public GLTextArea insert(int offset, float f) {
        this.changed = true;
        this.text.insert(offset, f);
        return this;
    }

    public GLTextArea insert(int offset, int i) {
        this.changed = true;
        this.text.insert(offset, i);
        return this;
    }

    public GLTextArea insert(int offset, Object obj) {
        this.changed = true;
        this.text.insert(offset, obj);
        return this;
    }

    public GLTextArea insert(int offset, String str) {
        this.changed = true;
        this.text.insert(offset, str);
        return this;
    }

    public GLTextArea insert(int offset, long l) {
        this.changed = true;
        this.text.insert(offset, l);
        return this;
    }

    public int length() {
        return this.text.length();
    }

    public GLTextArea replace(int start, int end, String str) {
        this.changed = true;
        this.text.replace(start, end, str);
        return this;
    }

    public void setCharAt(int index, char ch) {
        if (this.text.charAt(index) == ch) {
            return;
        }
        this.changed = true;
        this.text.setCharAt(index, ch);
    }

    public void setLength(int newLength) {
        if (newLength == this.text.length()) {
            return;
        }
        this.changed = true;
        this.text.setLength(newLength);
    }

    public void getLocation(WritablePoint dest) {
        this.location.getLocation(dest);
    }

    public int getX() {
        return this.location.getX();
    }

    public int getY() {
        return this.location.getY();
    }

    public void setLocation(int x, int y) {
        if (this.location.getX() == x && this.location.getY() == y) {
            return;
        }
        this.changed = true;
        this.location.setLocation(x, y);
    }

    public void setLocation(ReadablePoint p) {
        if (this.location.getX() == p.getX() && this.location.getY() == p.getY()) {
            return;
        }
        this.changed = true;
        this.location.setLocation(p);
    }

    public void setX(int x) {
        if (this.location.getX() == x) {
            return;
        }
        this.changed = true;
        this.location.setX(x);
    }

    public void setY(int y) {
        if (this.location.getY() == y) {
            return;
        }
        this.changed = true;
        this.location.setY(y);
    }

    public void translate(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        this.changed = true;
        this.location.translate(dx, dy);
    }

    public void translate(ReadablePoint p) {
        if (p.getX() == 0 && p.getY() == 0) {
            return;
        }
        this.changed = true;
        this.location.translate(p);
    }

    public void untranslate(ReadablePoint p) {
        if (p.getX() == 0 && p.getY() == 0) {
            return;
        }
        this.changed = true;
        this.location.untranslate(p);
    }

    public int getHeight() {
        this.layout();
        return this.size.getHeight();
    }

    public int getWidth() {
        this.layout();
        return this.size.getWidth();
    }

    public void setHeight(int height) {
        if (this.size.getHeight() == height) {
            return;
        }
        this.changed = true;
        this.size.setHeight(height);
    }

    public void setWidth(int width) {
        if (this.size.getWidth() == width) {
            return;
        }
        this.changed = true;
        this.size.setWidth(width);
    }

    public void getSize(WritableDimension dest) {
        this.layout();
        this.size.getSize(dest);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.setLocation(x, y);
        this.setSize(w, h);
    }

    public void setBounds(ReadablePoint p, ReadableDimension d) {
        this.setLocation(p);
        this.setSize(d);
    }

    public void setBounds(ReadableRectangle r) {
        this.setLocation((ReadablePoint)r);
        this.setSize((ReadableDimension)r);
    }

    public void setSize(int w, int h) {
        if (this.size.getWidth() == w && this.size.getHeight() == h) {
            return;
        }
        this.changed = true;
        this.size.setSize(w, h);
    }

    public void setSize(ReadableDimension d) {
        if (this.size.equals((Object)d)) {
            return;
        }
        this.changed = true;
        this.size.setSize(d);
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public TextLayout.HorizontalAlignment getHorizontalAlignment() {
        return this.alignment;
    }

    public void setText(String newText) {
        this.text.setLength(0);
        this.text.append(newText);
        this.changed = true;
        this.cursorPos = newText.length();
    }

    public String getText() {
        return this.text.toString();
    }

    public void setColoured(boolean coloured) {
        this.coloured = coloured;
    }

    public boolean isColoured() {
        return this.coloured;
    }

    public void setColour(ReadableColor c) {
        this.setColoured(true);
        this.bottomColour = c;
        this.topColour = c;
    }

    public void setBottomColour(ReadableColor c) {
        this.setColoured(true);
        this.bottomColour = c;
    }

    public void setTopColour(ReadableColor c) {
        this.setColoured(true);
        this.topColour = c;
    }

    public void tick() {
        if (this.editing) {
            this.flashCursor();
            this.processKeyboard();
        }
    }

    private void flashCursor() {
        ++this.flashTick;
        if (this.flashTick > 6) {
            this.flashTick = 0;
            this.cursorVisible = !this.cursorVisible;
        }
    }

    private void processKeyboard() {
        int oldCursorPos = this.cursorPos;
        block10: while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            int key = Keyboard.getEventKey();
            switch (key) {
                case 207: 
                case 208: {
                    this.cursorPos = this.text.length();
                    break;
                }
                case 199: 
                case 200: {
                    this.cursorPos = 0;
                    break;
                }
                case 203: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.cursorPos = 0;
                        break;
                    }
                    if (this.cursorPos <= 0) continue block10;
                    --this.cursorPos;
                    break;
                }
                case 205: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.cursorPos = this.text.length();
                        break;
                    }
                    if (this.cursorPos >= this.text.length()) continue block10;
                    ++this.cursorPos;
                    break;
                }
                case 211: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.text.setLength(0);
                        this.cursorPos = 0;
                        this.changed = true;
                    } else if (this.cursorPos < this.text.length()) {
                        this.text.deleteCharAt(this.cursorPos);
                        this.changed = true;
                    }
                    this.onEdited();
                    break;
                }
                case 14: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.text.setLength(0);
                        this.cursorPos = 0;
                        this.changed = true;
                    } else if (this.cursorPos > 0) {
                        this.text.deleteCharAt(--this.cursorPos);
                        this.changed = true;
                    }
                    this.onEdited();
                    break;
                }
                case 15: 
                case 28: {
                    this.changeFocus();
                    return;
                }
                case 1: {
                    this.cancel();
                    return;
                }
                default: {
                    char c = Keyboard.getEventCharacter();
                    if (c == '\u0016' || key == 210 && Keyboard.isKeyDown((int)42)) {
                        String paste = Sys.getClipboard();
                        if (paste == null) continue block10;
                        int i = 0;
                        while (i < paste.length()) {
                            c = Character.toLowerCase(paste.charAt(i));
                            if (this.text.length() >= this.text.capacity() || !this.acceptChar(c)) continue block10;
                            this.text.insert(this.cursorPos++, c);
                            this.changed = true;
                            this.onEdited();
                            ++i;
                        }
                        continue block10;
                    }
                    if (c == '\u001a' && Keyboard.isKeyDown((int)29)) {
                        this.undo();
                        break;
                    }
                    if (c < ' ' || c >= '\u007f' || !this.acceptChar(c)) continue block10;
                    this.text.insert(this.cursorPos++, c);
                    this.changed = true;
                    this.onEdited();
                }
            }
        }
        if (oldCursorPos != this.cursorPos) {
            this.cursorVisible = true;
            this.flashTick = 0;
        }
    }

    public boolean acceptChar(char c) {
        return true;
    }

    public final void changeFocus() {
        this.editing = false;
        this.cursorVisible = false;
        this.flashTick = 0;
        this.onChangeFocus();
    }

    protected void onChangeFocus() {
    }

    protected void onEdited() {
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
        if (editing) {
            this.oldText = this.text.toString();
            this.changed = true;
        }
    }

    public void undo() {
        if (this.editing) {
            this.setText(this.oldText);
        }
    }

    public void cancel() {
        this.undo();
        this.setEditing(false);
        this.onCancelled();
    }

    protected void onCancelled() {
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public static abstract class VerticalAlignment
    implements Serializable,
    Decodeable {
        public static final long serialVersionUID = 1L;
        private final String display;

        private VerticalAlignment(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        public static Object decode(String in) throws Exception {
            if (in.equalsIgnoreCase(GLTextArea.TOP.display)) {
                return TOP;
            }
            if (in.equalsIgnoreCase(GLTextArea.BOTTOM.display)) {
                return BOTTOM;
            }
            if (in.equalsIgnoreCase(GLTextArea.BASELINE.display)) {
                return BASELINE;
            }
            if (in.equalsIgnoreCase(GLTextArea.CENTERED.display)) {
                return CENTERED;
            }
            throw new Exception("Unknown vertical alignment '" + in + "'");
        }
    }
}

