/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.opengl;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLGlyph;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.SimpleRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.util.Decodeable;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class GLStyledText
implements SimpleRenderable,
GLRenderable {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = true;
    private String text;
    private final List strings = new ArrayList();
    private final List lines = new ArrayList();
    private final Rectangle bounds = new Rectangle();
    private int textHeight;
    private int numGlyphs;
    private HorizontalAlignment horizontalAlignment = LEFT;
    private VerticalAlignment verticalAlignment = TOP;
    private boolean justified;
    private boolean changed = true;
    private ReadableColor color = Color.WHITE;
    private int alpha = 255;
    private int leading;
    private StyledTextFactory factory;
    private int penY;
    private StyledWord currentWord = null;
    private final ArrayList currentWords = new ArrayList();
    private StyledLine currentLine = null;
    private StyledText currentStyle = null;
    public static final HorizontalAlignment LEFT = new HorizontalAlignment("Left"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return LEFT;
        }
    };
    public static final HorizontalAlignment RIGHT = new HorizontalAlignment("Right"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return RIGHT;
        }
    };
    public static final HorizontalAlignment CENTERED = new HorizontalAlignment("Centered"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return CENTERED;
        }
    };
    public static final VerticalAlignment TOP = new VerticalAlignment("Top"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return TOP;
        }
    };
    public static final VerticalAlignment BOTTOM = new VerticalAlignment("Bottom"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return BOTTOM;
        }
    };
    public static final VerticalAlignment VCENTERED = new VerticalAlignment("Centered"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return VCENTERED;
        }
    };

    public void setLeading(int leading) {
        this.leading = leading;
        this.changed = true;
    }

    public int getLeading() {
        return this.leading;
    }

    private void endWord(boolean nextLine, boolean wordBreak) {
        if (this.currentStyle == null) {
            return;
        }
        if (this.currentWord != null) {
            this.currentStyle.add(this.currentWord);
        }
        if (this.currentLine == null) {
            this.currentLine = new StyledLine(this.currentStyle.getFont());
        }
        if (!this.currentLine.fits(this.currentWords)) {
            this.lines.add(this.currentLine);
            this.currentLine = new StyledLine(this.currentStyle.getFont());
        }
        if ((wordBreak || nextLine) && this.currentWords.size() != 0) {
            this.currentLine.addWords(this.currentWords);
            this.currentWords.clear();
        }
        this.currentWord = null;
        if (nextLine) {
            this.lines.add(this.currentLine);
            this.currentLine = new StyledLine(this.currentStyle.getFont());
        }
    }

    private void layout() {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        this.textHeight = 0;
        this.numGlyphs = 0;
        this.strings.clear();
        this.lines.clear();
        if (this.factory == null) {
            System.out.println("GLStyledText has no factory! " + this.text);
            return;
        }
        if (this.text == null) {
            return;
        }
        this.factory.parse(this.text, this.strings);
        int numStrings = this.strings.size();
        this.penY = 0;
        int i = 0;
        while (i < numStrings) {
            this.currentStyle = (StyledText)this.strings.get(i);
            int length = this.currentStyle.getText().length();
            int j = 0;
            while (j < length) {
                char c = this.currentStyle.getText().charAt(j);
                if (c == '\n') {
                    this.endWord(true, true);
                } else if (c == ' ') {
                    this.endWord(false, true);
                } else {
                    if (this.currentWord == null) {
                        this.currentWord = new StyledWord(this.currentStyle);
                        this.currentWords.add(this.currentWord);
                    }
                    this.currentWord.addGlyph(this.currentStyle.getFont().map(c));
                }
                ++j;
            }
            this.endWord(false, false);
            ++i;
        }
        this.endWord(true, true);
        this.currentWord = null;
        this.currentLine = null;
        this.currentStyle = null;
        this.currentWords.clear();
        int numLines = this.lines.size();
        if (numLines == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < numLines) {
            StyledLine line = (StyledLine)this.lines.get(i2);
            if (line.lastWord == null) {
                line.ascent = line.currentFont.getAscent();
                line.descent = line.currentFont.getDescent();
            }
            this.textHeight += line.ascent + line.descent;
            if (i2 < numLines - 1) {
                this.textHeight += this.leading;
            }
            ++i2;
        }
        int firstLineAscent = ((StyledLine)this.lines.get(0)).ascent;
        int ty = this.verticalAlignment == TOP ? this.bounds.getHeight() - firstLineAscent : (this.verticalAlignment == VCENTERED ? this.textHeight + (this.bounds.getHeight() - this.textHeight) / 2 - firstLineAscent : this.textHeight - firstLineAscent);
        this.penY = 0;
        int i3 = 0;
        while (i3 < numLines) {
            StyledLine line = (StyledLine)this.lines.get(i3);
            line.layout(this.bounds.getY() + ty - this.penY);
            this.penY += line.descent + this.leading;
            if (i3 < numLines - 1) {
                StyledLine nextLine = (StyledLine)this.lines.get(i3 + 1);
                this.penY += nextLine.ascent;
            }
            ++i3;
        }
    }

    public void render(SimpleRenderer renderer) {
        this.layout();
        if (this.strings.size() == 0) {
            return;
        }
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            }
        });
        int n = this.strings.size();
        int i = 0;
        while (i < n) {
            SimpleRenderable renderable = (SimpleRenderable)this.strings.get(i);
            renderable.render(renderer);
            ++i;
        }
    }

    public void render() {
        this.render(SimpleRenderer.GL_RENDERER);
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    public void setHorizontalAlignment(HorizontalAlignment alignment) {
        if (this.horizontalAlignment == alignment) {
            return;
        }
        this.horizontalAlignment = alignment;
        this.changed = true;
    }

    public void setVerticalAlignment(VerticalAlignment valignment) {
        if (this.verticalAlignment == valignment) {
            return;
        }
        this.verticalAlignment = valignment;
        this.changed = true;
    }

    public int getTextHeight() {
        this.layout();
        return this.textHeight;
    }

    public int getX() {
        return this.bounds.getX();
    }

    public int getY() {
        return this.bounds.getY();
    }

    public void setLocation(int x, int y) {
        if (this.bounds.getX() == x && this.bounds.getY() == y) {
            return;
        }
        this.bounds.setLocation(x, y);
        this.changed = true;
    }

    public void setLocation(ReadablePoint p) {
        this.setLocation(p.getX(), p.getY());
    }

    public void setX(int x) {
        if (this.bounds.getX() == x) {
            return;
        }
        this.bounds.setX(x);
        this.changed = true;
    }

    public void setY(int y) {
        if (this.bounds.getY() == y) {
            return;
        }
        this.bounds.setY(y);
        this.changed = true;
    }

    public int getHeight() {
        return this.bounds.getHeight();
    }

    public int getWidth() {
        return this.bounds.getWidth();
    }

    public void setHeight(int height) {
        if (this.bounds.getHeight() == height) {
            return;
        }
        this.changed = true;
        this.bounds.setHeight(height);
    }

    public void setWidth(int width) {
        if (this.bounds.getWidth() == width) {
            return;
        }
        this.changed = true;
        this.bounds.setWidth(width);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.setLocation(x, y);
        this.setSize(w, h);
    }

    public void setBounds(ReadableRectangle r) {
        this.setLocation((ReadablePoint)r);
        this.setSize((ReadableDimension)r);
    }

    public void setSize(int w, int h) {
        if (this.bounds.getWidth() == w && this.bounds.getHeight() == h) {
            return;
        }
        this.changed = true;
        this.bounds.setSize(w, h);
    }

    public void setSize(ReadableDimension d) {
        this.setSize(d.getWidth(), d.getHeight());
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setText(String newText) {
        if (newText != this.text) {
            this.text = newText;
            this.changed = true;
        }
    }

    public String getText() {
        return this.text;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setFactory(StyledTextFactory factory) {
        if (this.factory != factory) {
            this.factory = factory;
            this.changed = true;
        }
    }

    public StyledTextFactory getFactory() {
        return this.factory;
    }

    public void setJustified(boolean justified) {
        if (this.justified != justified) {
            this.justified = justified;
            this.changed = true;
        }
    }

    public boolean isJustified() {
        return this.justified;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public int getNumLines() {
        this.layout();
        return this.lines.size();
    }

    public void setColor(ReadableColor color) {
        this.color = color;
    }

    public ReadableColor getColor() {
        return this.color;
    }

    public static class DefaultStyledText
    implements StyledText {
        private final ReadableColor bottomColor;
        private final ReadableColor topColor;
        private final GLFont font;
        private final String text;
        private final ArrayList renderables = new ArrayList();

        public DefaultStyledText(String text, GLFont font, ReadableColor topColor, ReadableColor bottomColor) {
            this.text = text;
            this.font = font;
            this.topColor = topColor;
            this.bottomColor = bottomColor;
        }

        public ReadableColor getBottomColor() {
            return this.bottomColor;
        }

        public GLFont getFont() {
            return this.font;
        }

        public String getText() {
            return this.text;
        }

        public ReadableColor getTopColor() {
            return this.topColor;
        }

        public void add(SimpleRenderable renderable) {
            this.renderables.add(renderable);
        }

        public void render(SimpleRenderer renderer) {
            int n = this.renderables.size();
            if (n == 0) {
                return;
            }
            renderer.glRender(new GLRenderable(this){
                final /* synthetic */ DefaultStyledText this$1;
                {
                    this.this$1 = defaultStyledText;
                }

                public void render() {
                    DefaultStyledText.access$0(this.this$1).render();
                }
            });
            int i = 0;
            while (i < n) {
                SimpleRenderable renderable = (SimpleRenderable)this.renderables.get(i);
                renderable.render(renderer);
                ++i;
            }
        }

        static /* synthetic */ GLFont access$0(DefaultStyledText defaultStyledText) {
            return defaultStyledText.font;
        }
    }

    public static class DefaultStyledTextFactory
    implements StyledTextFactory {
        private ReadableColor topColor;
        private ReadableColor bottomColor;
        private GLFont font;

        public DefaultStyledTextFactory(ReadableColor topColor, ReadableColor bottomColor, GLFont font) {
            this.topColor = topColor;
            this.bottomColor = bottomColor;
            this.font = font;
        }

        public void parse(String text, List dest) {
            dest.clear();
            StringBuffer sb = new StringBuffer(text.length());
            int n = text.length();
            int i = 0;
            while (i < n) {
                char c = text.charAt(i);
                if (c == '{') {
                    if (sb.length() > 0) {
                        DefaultStyledText dst = new DefaultStyledText(sb.toString(), this.font, this.topColor, this.bottomColor);
                        dest.add(dst);
                        sb = new StringBuffer(text.length() - i);
                    }
                    i += this.parse(text, i + 1);
                    continue;
                }
                sb.append(c);
                ++i;
            }
            if (sb.length() > 0) {
                DefaultStyledText dst = new DefaultStyledText(sb.toString(), this.font, this.topColor, this.bottomColor);
                dest.add(dst);
            }
        }

        private int parse(String text, int pos) {
            int idx = text.indexOf(125, pos);
            String format = text.substring(pos, idx);
            StringTokenizer st = new StringTokenizer(format, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                int colon = token.indexOf(58);
                if (colon == -1) {
                    System.out.println("Bad token : " + token);
                    continue;
                }
                String key = token.substring(0, colon).toLowerCase();
                String value = token.substring(colon + 1);
                if (key.equals("top")) {
                    this.topColor = new MappedColor(value);
                    continue;
                }
                if (key.equals("bottom")) {
                    this.bottomColor = new MappedColor(value);
                    continue;
                }
                if (key.equals("color")) {
                    this.bottomColor = this.topColor = new MappedColor(value);
                    continue;
                }
                if (key.equals("font")) {
                    this.font = (GLFont)Resources.get(value);
                    continue;
                }
                System.out.println("Bad key : " + key);
            }
            return idx - pos + 2;
        }
    }

    public static abstract class HorizontalAlignment
    implements Serializable,
    Decodeable {
        public static final long serialVersionUID = 1L;
        private final String display;

        private HorizontalAlignment(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        public static Object decode(String in) throws Exception {
            if (in.equalsIgnoreCase(GLStyledText.LEFT.display)) {
                return LEFT;
            }
            if (in.equalsIgnoreCase(GLStyledText.RIGHT.display)) {
                return RIGHT;
            }
            if (in.equalsIgnoreCase(GLStyledText.CENTERED.display)) {
                return CENTERED;
            }
            throw new Exception("Unknown horizontal alignment '" + in + "'");
        }
    }

    public static class SimpleStyledTextFactory
    implements StyledTextFactory {
        private final ReadableColor color;
        private final GLFont font;

        public SimpleStyledTextFactory(ReadableColor color, GLFont font) {
            this.color = color;
            this.font = font;
        }

        public void parse(String text, List dest) {
            dest.clear();
            DefaultStyledText dst = new DefaultStyledText(text, this.font, this.color, this.color);
            dest.add(dst);
        }
    }

    private class StyledLine {
        private final ArrayList words = new ArrayList();
        private int ascent;
        private int descent;
        private int width;
        GLFont currentFont;
        private boolean paragraphBreak;
        private StyledWord lastWord;

        StyledLine(GLFont currentFont) {
            this.currentFont = currentFont;
        }

        boolean fits(ArrayList newWords) {
            if (this.lastWord == null) {
                return true;
            }
            int testWidth = this.width;
            int n = newWords.size();
            int i = 0;
            while (i < n) {
                testWidth += ((StyledWord)newWords.get(i)).width;
                ++i;
            }
            if (this.lastWord != null) {
                testWidth += this.lastWord.calcGap();
            }
            return testWidth <= GLStyledText.this.bounds.getWidth();
        }

        public String toString() {
            return "StyledLine[" + this.width + ", " + this.ascent + ", " + this.descent + ", " + this.paragraphBreak + ", words:" + this.words + "]";
        }

        void addWords(List newWords) {
            this.words.addAll(newWords);
            int n = newWords.size();
            int i = 0;
            while (i < n) {
                StyledWord word = (StyledWord)newWords.get(i);
                this.ascent = Math.max(this.ascent, word.ascent);
                this.descent = Math.max(this.descent, word.descent);
                this.width += word.width;
                ++i;
            }
            if (this.lastWord != null) {
                this.lastWord.addGap();
                this.width += this.lastWord.gap;
            }
            this.lastWord = (StyledWord)newWords.get(n - 1);
        }

        void layout(int y) {
            int n = this.words.size();
            if (n == 0) {
                return;
            }
            int x = GLStyledText.this.bounds.getX();
            if (GLStyledText.this.justified && !this.paragraphBreak && n != 1) {
                int availableWidth = GLStyledText.this.bounds.getWidth() - this.width;
                int spread = availableWidth / (this.words.size() - 1);
                int remainder = availableWidth % (this.words.size() - 1);
                int i = 0;
                while (i < n) {
                    StyledWord word;
                    StyledWord styledWord = word = (StyledWord)this.words.get(i);
                    styledWord.gap = styledWord.gap + spread;
                    if (i < remainder) {
                        StyledWord styledWord2 = word;
                        styledWord2.gap = styledWord2.gap + 1;
                    }
                    word.layout(x, y);
                    x += word.width + word.gap;
                    ++i;
                }
                return;
            }
            if (GLStyledText.this.horizontalAlignment == RIGHT) {
                x += GLStyledText.this.bounds.getWidth() - this.width;
            } else if (GLStyledText.this.horizontalAlignment == CENTERED) {
                x += GLStyledText.this.bounds.getWidth() - this.width >> 1;
            }
            int i = 0;
            while (i < n) {
                StyledWord word = (StyledWord)this.words.get(i);
                word.layout(x, y);
                x += word.width + word.gap;
                ++i;
            }
        }
    }

    public static interface StyledText
    extends SimpleRenderable {
        public ReadableColor getTopColor();

        public ReadableColor getBottomColor();

        public GLFont getFont();

        public String getText();

        public void add(SimpleRenderable var1);
    }

    public static interface StyledTextFactory {
        public void parse(String var1, List var2);
    }

    private class StyledWord
    implements SimpleRenderable {
        private final ArrayList glyphs = new ArrayList();
        private final StyledText style;
        private int ascent;
        private int descent;
        private int width;
        private int gap;
        private GLGlyph lastGlyph;
        private final Color topColor = new Color();
        private final Color bottomColor = new Color();

        StyledWord(StyledText style) {
            this.style = style;
            this.ascent = style.getFont().getAscent();
            this.descent = style.getFont().getDescent();
        }

        public void render(SimpleRenderer renderer) {
            int n = this.glyphs.size();
            if (n == 0) {
                return;
            }
            if (this.style.getTopColor() != null) {
                ColorUtil.blendColor(this.style.getTopColor(), GLStyledText.this.color, this.topColor);
                ColorUtil.blendColor(this.style.getBottomColor(), GLStyledText.this.color, this.bottomColor);
            }
            renderer.glBegin(7);
            int i = 0;
            while (i < n) {
                ((GLGlyph)this.glyphs.get(i)).render((ReadableColor)this.topColor, (ReadableColor)this.bottomColor, GLStyledText.this.alpha, renderer);
                ++i;
            }
            renderer.glEnd();
        }

        void addGlyph(GLGlyph glyph) {
            this.glyphs.add(glyph);
            glyph.setLocation(this.width + glyph.getBearingX(), glyph.getBearingY());
            this.width += glyph.getAdvance();
            if (this.lastGlyph != null) {
                this.width += glyph.getKerningAfter(this.lastGlyph);
            }
            this.lastGlyph = glyph;
        }

        void layout(int x, int y) {
            int n = this.glyphs.size();
            int i = 0;
            while (i < n) {
                GLGlyph glyph = (GLGlyph)this.glyphs.get(i);
                glyph.setLocation(glyph.getXpos() + x, glyph.getYpos() + y);
                ++i;
            }
        }

        int calcGap() {
            return this.style.getFont().map(' ').getAdvance();
        }

        void addGap() {
            this.gap = this.calcGap();
        }

        public String toString() {
            return "StyledWord[" + this.style + ", " + this.glyphs + "]";
        }
    }

    public static abstract class VerticalAlignment
    implements Serializable,
    Decodeable {
        public static final long serialVersionUID = 1L;
        private final String display;

        private VerticalAlignment(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        public static Object decode(String in) throws Exception {
            if (in.equalsIgnoreCase(GLStyledText.TOP.display)) {
                return TOP;
            }
            if (in.equalsIgnoreCase(GLStyledText.BOTTOM.display)) {
                return BOTTOM;
            }
            if (in.equalsIgnoreCase(GLStyledText.VCENTERED.display)) {
                return VCENTERED;
            }
            throw new Exception("Unknown vertical alignment '" + in + "'");
        }
    }
}

