/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Font;
import com.shavenpuppy.jglib.Glyph;
import com.shavenpuppy.jglib.util.Decodeable;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public class TextLayout {
    private final Font font;
    private final float scale;
    private final Glyph[] glyph;
    private int numGlyphs;
    private final Format format;
    private HorizontalAlignment alignment;
    public static final HorizontalAlignment LEFT = new HorizontalAlignment("Left"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return LEFT;
        }
    };
    public static final HorizontalAlignment RIGHT = new HorizontalAlignment("Right"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return RIGHT;
        }
    };
    public static final HorizontalAlignment CENTERED = new HorizontalAlignment("Centered"){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return CENTERED;
        }
    };
    private final int[] x;
    private final int[] y;
    private int leading;
    private int width;
    private int height;
    private int penX;
    private int penY;
    private static final Rectangle tempBounds = new Rectangle();
    private static final Point tempPoint = new Point();
    public static final Format NO_WRAP = new NoWrap();
    public static final Format WRAPPED = new Wrapped();
    public static final Format WORD_WRAP = new WordWrapped();
    public static final Format JUSTIFIED = new Justified();
    private boolean keepWhiteSpace;

    public TextLayout(Font font, float scale, int leading, String text, int width, Format format, HorizontalAlignment alignment) {
        this.font = font;
        this.scale = scale;
        this.leading = leading;
        this.width = width;
        this.format = format;
        this.alignment = alignment;
        this.glyph = new Glyph[text.length()];
        this.x = new int[this.glyph.length];
        this.y = new int[this.glyph.length];
        this.doLayout(text);
    }

    public void setKeepWhiteSpace(boolean keepWhiteSpace) {
        this.keepWhiteSpace = keepWhiteSpace;
    }

    public boolean getKeepWhiteSpace() {
        return this.keepWhiteSpace;
    }

    private void doLayout(String text) {
        if (!this.keepWhiteSpace) {
            while (text.endsWith("\n")) {
                text = text.substring(0, text.length() - 1);
            }
        }
        StringTokenizer st = new StringTokenizer(text, "\n", true);
        boolean lastTokenWasParagraph = true;
        while (st.hasMoreTokens()) {
            String paragraph = st.nextToken();
            if ("\n".equals(paragraph)) {
                if (lastTokenWasParagraph) {
                    this.penY -= (int)((float)(this.font.getAscent() + this.font.getDescent()) * this.scale) + this.leading;
                }
                lastTokenWasParagraph = true;
                continue;
            }
            lastTokenWasParagraph = false;
            this.format.format(this, paragraph, !st.hasMoreTokens());
        }
        this.height = -this.penY;
    }

    public void getGlyphs(Glyph[] glyph, int[] x, int[] y) {
        System.arraycopy(this.glyph, 0, glyph, 0, this.numGlyphs);
        System.arraycopy(this.x, 0, x, 0, this.numGlyphs);
        System.arraycopy(this.y, 0, y, 0, this.numGlyphs);
    }

    public Font getFont() {
        return this.font;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    private void nextLine(boolean isLastParagraph) {
        this.penY = (int)((float)this.penY - (float)this.font.getDescent() * this.scale);
        if (!isLastParagraph) {
            this.penY -= this.leading;
        }
        this.penX = 0;
    }

    public HorizontalAlignment getAlignment() {
        return this.alignment;
    }

    private void align(int startGlyph, int advance) {
        int dx = this.alignment == RIGHT ? this.width - advance : (this.alignment == CENTERED ? this.width - advance >> 1 : 0);
        int i = startGlyph;
        while (i < this.numGlyphs) {
            int n = i++;
            this.x[n] = this.x[n] + dx;
        }
    }

    public void apply(Target target) {
        target.setNumGlyphs(this.numGlyphs);
        int i = 0;
        while (i < this.numGlyphs) {
            target.setGlyph(i, this.glyph[i], this.x[i], this.y[i]);
            ++i;
        }
    }

    public static abstract class Format
    implements Serializable,
    Decodeable {
        private static final long serialVersionUID = 1L;
        private final String display;

        private Format(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        abstract void format(TextLayout var1, String var2, boolean var3);

        public static Object decode(String in) throws Exception {
            if (in.equalsIgnoreCase(TextLayout.NO_WRAP.display)) {
                return NO_WRAP;
            }
            if (in.equalsIgnoreCase(TextLayout.WRAPPED.display)) {
                return WRAPPED;
            }
            if (in.equalsIgnoreCase(TextLayout.JUSTIFIED.display)) {
                return JUSTIFIED;
            }
            if (in.equalsIgnoreCase(TextLayout.WORD_WRAP.display)) {
                return WORD_WRAP;
            }
            throw new Exception("Unknown text format '" + in + "'");
        }
    }

    public static abstract class HorizontalAlignment
    implements Serializable,
    Decodeable {
        public static final long serialVersionUID = 1L;
        private final String display;

        private HorizontalAlignment(String display) {
            this.display = display;
        }

        public String toString() {
            return this.display;
        }

        public static Object decode(String in) throws Exception {
            if (in.equalsIgnoreCase(TextLayout.LEFT.display)) {
                return LEFT;
            }
            if (in.equalsIgnoreCase(TextLayout.RIGHT.display)) {
                return RIGHT;
            }
            if (in.equalsIgnoreCase(TextLayout.CENTERED.display)) {
                return CENTERED;
            }
            throw new Exception("Unknown horizontal alignment '" + in + "'");
        }
    }

    private static final class Justified
    extends Format {
        public static final long serialVersionUID = 1L;

        Justified() {
            super("Justified");
        }

        void format(TextLayout layout, String paragraph, boolean lastParagraph) {
            TextLayout textLayout = layout;
            textLayout.penY = (int)((float)textLayout.penY - (float)layout.font.getDescent() * layout.scale);
            if (!lastParagraph) {
                TextLayout textLayout2 = layout;
                textLayout2.penY = textLayout2.penY - layout.leading;
            }
            layout.penX = 0;
        }

        private Object readResolve() throws ObjectStreamException {
            return JUSTIFIED;
        }
    }

    private static final class NoWrap
    extends Format {
        public static final long serialVersionUID = 1L;

        NoWrap() {
            super("None");
        }

        void format(TextLayout layout, String paragraph, boolean lastParagraph) {
            int n = paragraph.length();
            Glyph last = null;
            TextLayout textLayout = layout;
            textLayout.penY = (int)((float)textLayout.penY - (float)layout.font.getAscent() * layout.scale);
            int i = 0;
            while (i < n) {
                Glyph next = layout.font.map(paragraph.charAt(i));
                next.getBounds((WritableRectangle)tempBounds);
                next.getBearing((WritablePoint)tempPoint);
                tempBounds.setBounds((int)((float)tempBounds.getX() * layout.scale), (int)((float)tempBounds.getY() * layout.scale), (int)((float)tempBounds.getWidth() * layout.scale), (int)((float)tempBounds.getHeight() * layout.scale));
                tempPoint.setLocation((int)((float)tempPoint.getX() * layout.scale), (int)((float)tempPoint.getY() * layout.scale));
                int kerning = (int)((float)next.getKerningAfter(last) * layout.scale);
                ((TextLayout)layout).x[((TextLayout)layout).numGlyphs] = tempPoint.getX() + layout.penX - kerning;
                ((TextLayout)layout).y[((TextLayout)layout).numGlyphs] = layout.penY + tempPoint.getY();
                Glyph[] glyphArray = layout.glyph;
                TextLayout textLayout2 = layout;
                int n2 = textLayout2.numGlyphs;
                textLayout2.numGlyphs = n2 + 1;
                glyphArray[n2] = next;
                TextLayout textLayout3 = layout;
                textLayout3.penX = textLayout3.penX + ((int)((float)next.getAdvance() * layout.scale) + kerning);
                ++i;
            }
            if (lastParagraph) {
                layout.align(0, layout.penX);
                layout.nextLine(true);
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return NO_WRAP;
        }
    }

    public static interface Target {
        public void setNumGlyphs(int var1);

        public void setGlyph(int var1, Glyph var2, int var3, int var4);
    }

    private static final class WordWrapped
    extends Format {
        public static final long serialVersionUID = 1L;

        WordWrapped() {
            super("Word Wrap");
        }

        void format(TextLayout layout, String paragraph, boolean lastParagraph) {
            StringTokenizer st = new StringTokenizer(paragraph, " ", true);
            int lastGlyphWidth = 0;
            int lastAdvanceWidth = 0;
            int startGlyph = layout.numGlyphs;
            boolean firstWordDone = false;
            TextLayout textLayout = layout;
            textLayout.penY = (int)((float)textLayout.penY - (float)layout.font.getAscent() * layout.scale);
            while (st.hasMoreTokens()) {
                int kerning;
                Glyph next;
                String word = st.nextToken();
                Glyph last = null;
                int w = 0;
                int lastWidthOffset = 0;
                int lastAdvance = 0;
                int n = word.length();
                int i = 0;
                while (i < n) {
                    next = layout.font.map(word.charAt(i));
                    next.getBounds((WritableRectangle)tempBounds);
                    next.getBearing((WritablePoint)tempPoint);
                    tempBounds.setBounds((int)((float)tempBounds.getX() * layout.scale), (int)((float)tempBounds.getY() * layout.scale), (int)((float)tempBounds.getWidth() * layout.scale), (int)((float)tempBounds.getHeight() * layout.scale));
                    tempPoint.setLocation((int)((float)tempPoint.getX() * layout.scale), (int)((float)tempPoint.getY() * layout.scale));
                    kerning = (int)((float)next.getKerningAfter(last) * layout.scale);
                    lastAdvance = (int)((float)next.getAdvance() * layout.scale) + kerning;
                    lastWidthOffset = tempPoint.getX() + tempBounds.getWidth() - kerning;
                    w += lastAdvance;
                    last = next;
                    ++i;
                }
                w = w - lastAdvance + lastWidthOffset;
                if (firstWordDone && layout.penX + w > layout.width) {
                    layout.align(startGlyph, layout.penX + lastGlyphWidth - lastAdvanceWidth);
                    startGlyph = layout.numGlyphs;
                    layout.nextLine(false);
                    TextLayout textLayout2 = layout;
                    textLayout2.penY = (int)((float)textLayout2.penY - (float)layout.font.getAscent() * layout.scale);
                    firstWordDone = false;
                }
                last = null;
                i = 0;
                while (i < n) {
                    next = layout.font.map(word.charAt(i));
                    next.getBounds((WritableRectangle)tempBounds);
                    next.getBearing((WritablePoint)tempPoint);
                    tempBounds.setBounds((int)((float)tempBounds.getX() * layout.scale), (int)((float)tempBounds.getY() * layout.scale), (int)((float)tempBounds.getWidth() * layout.scale), (int)((float)tempBounds.getHeight() * layout.scale));
                    tempPoint.setLocation((int)((float)tempPoint.getX() * layout.scale), (int)((float)tempPoint.getY() * layout.scale));
                    kerning = (int)((float)next.getKerningAfter(last) * layout.scale);
                    ((TextLayout)layout).x[((TextLayout)layout).numGlyphs] = tempPoint.getX() + layout.penX - kerning;
                    ((TextLayout)layout).y[((TextLayout)layout).numGlyphs] = layout.penY + tempPoint.getY();
                    ((TextLayout)layout).glyph[((TextLayout)layout).numGlyphs] = next;
                    lastAdvance = (int)((float)next.getAdvance() * layout.scale) + kerning;
                    TextLayout textLayout3 = layout;
                    textLayout3.penX = textLayout3.penX + lastAdvance;
                    TextLayout textLayout4 = layout;
                    textLayout4.numGlyphs = textLayout4.numGlyphs + 1;
                    last = next;
                    ++i;
                }
                firstWordDone = true;
            }
            layout.align(startGlyph, layout.penX + lastGlyphWidth - lastAdvanceWidth);
            layout.nextLine(lastParagraph);
        }

        private Object readResolve() throws ObjectStreamException {
            return WORD_WRAP;
        }
    }

    private static final class Wrapped
    extends Format {
        public static final long serialVersionUID = 1L;

        Wrapped() {
            super("Character Wrap");
        }

        void format(TextLayout layout, String paragraph, boolean lastParagraph) {
            int n = paragraph.length();
            Glyph last = null;
            int lastWidth = 0;
            int lastAdvance = 0;
            int startGlyph = layout.numGlyphs;
            TextLayout textLayout = layout;
            textLayout.penY = (int)((float)textLayout.penY - (float)layout.font.getAscent() * layout.scale);
            int i = 0;
            while (i < n) {
                Glyph next = layout.font.map(paragraph.charAt(i));
                next.getBounds((WritableRectangle)tempBounds);
                next.getBearing((WritablePoint)tempPoint);
                tempBounds.setBounds((int)((float)tempBounds.getX() * layout.scale), (int)((float)tempBounds.getY() * layout.scale), (int)((float)tempBounds.getWidth() * layout.scale), (int)((float)tempBounds.getHeight() * layout.scale));
                tempPoint.setLocation((int)((float)tempPoint.getX() * layout.scale), (int)((float)tempPoint.getY() * layout.scale));
                int kerning = (int)((float)next.getKerningAfter(last) * layout.scale);
                if (layout.penX + tempPoint.getX() + tempBounds.getWidth() - kerning > layout.width) {
                    layout.align(startGlyph, layout.penX + lastWidth - lastAdvance);
                    startGlyph = layout.numGlyphs;
                    layout.nextLine(false);
                    TextLayout textLayout2 = layout;
                    textLayout2.penY = (int)((float)textLayout2.penY - ((float)(layout.font.getAscent() + layout.font.getDescent()) * layout.scale + (float)layout.leading));
                    last = null;
                } else {
                    last = next;
                }
                ((TextLayout)layout).x[((TextLayout)layout).numGlyphs] = tempPoint.getX() + layout.penX - kerning;
                ((TextLayout)layout).y[((TextLayout)layout).numGlyphs] = layout.penY + tempPoint.getY();
                ((TextLayout)layout).glyph[((TextLayout)layout).numGlyphs] = next;
                lastAdvance = (int)((float)next.getAdvance() * layout.scale) + kerning;
                TextLayout textLayout3 = layout;
                textLayout3.penX = textLayout3.penX + lastAdvance;
                lastWidth = layout.x[layout.numGlyphs] - tempPoint.getX();
                TextLayout textLayout4 = layout;
                textLayout4.numGlyphs = textLayout4.numGlyphs + 1;
                ++i;
            }
            layout.align(startGlyph, layout.penX + lastWidth - lastAdvance);
            layout.nextLine(lastParagraph);
        }

        private Object readResolve() throws ObjectStreamException {
            return WRAPPED;
        }
    }
}

