/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Bus;
import com.fluendo.jst.Clock;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Object;
import com.fluendo.jst.Pad;
import com.fluendo.jst.PadListener;
import com.fluendo.jst.Query;
import com.fluendo.utils.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class Element
extends Object {
    public static final int FLAG_IS_SINK = 32;
    public static final int ELEMENT_FLAG_LAST = 0x100000;
    protected List pads = new ArrayList();
    protected java.lang.Object stateLock = new java.lang.Object();
    private List padListeners = new ArrayList();
    protected Clock clock;
    protected Bus bus;
    protected long baseTime;
    public static final int NONE = 0;
    public static final int STOP = 1;
    public static final int PAUSE = 2;
    public static final int PLAY = 3;
    protected static String[] stateNames = new String[]{"none", "stop", "pause", "play"};
    private static final int SHIFT = 4;
    private static final int MASK = 15;
    public static final int STOP_PAUSE = 18;
    public static final int PAUSE_PLAY = 35;
    public static final int PLAY_PAUSE = 50;
    public static final int PAUSE_STOP = 33;
    public static final int FAILURE = 0;
    public static final int SUCCESS = 1;
    public static final int ASYNC = 2;
    public static final int NO_PREROLL = 3;
    public static String[] stateReturnNames = new String[]{"FAILURE", "SUCCESS", "ASYNC", "NO_PREROLL"};
    protected int currentState = 1;
    protected int nextState = 0;
    protected int pendingState = 0;
    protected int lastReturn = 1;

    public static String getStateName(int state) {
        return stateNames[state];
    }

    public static String getStateReturnName(int ret) {
        return stateReturnNames[ret];
    }

    public String getMime() {
        return null;
    }

    public abstract String getFactoryName();

    public int typeFind(byte[] data, int offset, int length) {
        return -1;
    }

    public Element() {
        this(null);
    }

    public Element(String name) {
        super(name);
    }

    public String toString() {
        return "Element: [" + this.getName() + "]";
    }

    public synchronized void setClock(Clock newClock) {
        Debug.debug(this + ".setClock(" + newClock + ")");
        this.clock = newClock;
    }

    public synchronized Clock getClock() {
        return this.clock;
    }

    public synchronized void setBus(Bus newBus) {
        this.bus = newBus;
    }

    public synchronized Bus getBus() {
        return this.bus;
    }

    public synchronized void addPadListener(PadListener listener) {
        this.padListeners.add(listener);
    }

    public synchronized void removePadListener(PadListener listener) {
        this.padListeners.remove(listener);
    }

    private synchronized void doPadListeners(int method, Pad pad) {
        Iterator e = this.padListeners.iterator();
        while (e.hasNext()) {
            PadListener listener = (PadListener)e.next();
            switch (method) {
                case 0: {
                    listener.padAdded(pad);
                    break;
                }
                case 1: {
                    listener.padRemoved(pad);
                    break;
                }
                case 2: {
                    listener.noMorePads();
                }
            }
        }
    }

    public synchronized Pad getPad(String name) {
        Iterator e = this.pads.iterator();
        while (e.hasNext()) {
            Pad pad = (Pad)e.next();
            if (!name.equals(pad.getName())) continue;
            return pad;
        }
        return null;
    }

    public synchronized boolean addPad(Pad newPad) {
        if (!newPad.setParent(this)) {
            return false;
        }
        this.pads.add(newPad);
        this.doPadListeners(0, newPad);
        return true;
    }

    public synchronized boolean removePad(Pad aPad) {
        if (aPad.getParent() != this) {
            return false;
        }
        aPad.unParent();
        this.pads.remove(aPad);
        this.doPadListeners(1, aPad);
        return true;
    }

    public synchronized void noMorePads() {
        this.doPadListeners(2, null);
    }

    public Iterator enumPads() {
        return this.pads.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessage(Message message) {
        Bus myBus;
        Element element = this;
        synchronized (element) {
            myBus = this.bus;
        }
        if (myBus != null) {
            myBus.post(message);
        }
    }

    public synchronized int getState(int[] resState, int[] resPending, long timeout) {
        if (this.lastReturn == 2 && this.pendingState != 0) {
            long t = timeout == 0L ? 0L : (timeout < 1000L ? 1L : timeout / 1000L);
            try {
                this.wait(t);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (resState != null) {
            resState[0] = this.currentState;
        }
        if (resPending != null) {
            resPending[0] = this.pendingState;
        }
        return this.lastReturn;
    }

    private boolean padsActivate(boolean active) {
        int mode = active ? 1 : 0;
        boolean res = true;
        Iterator e = this.pads.iterator();
        while (e.hasNext()) {
            Pad pad = (Pad)e.next();
            if (res &= pad.activate(mode)) continue;
            return res;
        }
        return res;
    }

    public int getStateNext(int current, int pending) {
        int sign = pending - current;
        sign = sign > 0 ? 1 : (sign < 0 ? -1 : 0);
        return current + sign;
    }

    public int getTransition(int current, int next) {
        return current << 4 | next;
    }

    public int getTransitionCurrent(int transition) {
        return transition >> 4;
    }

    public int getTransitionNext(int transition) {
        return transition & 0xF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int continueState(int result) {
        Message message = null;
        int transition = 0;
        Element element = this;
        synchronized (element) {
            int oldRet = this.lastReturn;
            this.lastReturn = result;
            int pending = this.pendingState;
            if (pending == 0) {
                return result;
            }
            int oldState = this.currentState;
            int oldNext = this.nextState;
            this.currentState = oldNext;
            int current = this.currentState;
            if (pending == current) {
                this.pendingState = 0;
                this.nextState = 0;
                transition = 0;
                if (oldState != oldNext || oldRet == 2) {
                    message = Message.newStateChanged(this, oldState, oldNext, pending);
                }
            } else {
                int next = this.getStateNext(current, pending);
                transition = this.getTransition(current, next);
                this.nextState = next;
                this.lastReturn = 2;
                message = Message.newStateChanged(this, oldState, oldNext, pending);
            }
        }
        if (message != null) {
            this.postMessage(message);
        }
        if (transition != 0) {
            result = this.doChangeState(transition);
        } else {
            element = this;
            synchronized (element) {
                this.notifyAll();
            }
        }
        return result;
    }

    public synchronized void abortState() {
        if (this.pendingState != 0 && this.lastReturn != 0) {
            this.lastReturn = 0;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostState() {
        boolean post = false;
        int current = 0;
        Element element = this;
        synchronized (element) {
            if (this.pendingState == 0 && this.lastReturn != 0) {
                current = this.currentState;
                this.pendingState = this.nextState = this.currentState;
                this.lastReturn = 2;
                post = true;
            }
        }
        if (post) {
            this.postMessage(Message.newStateChanged(this, current, current, current));
            this.postMessage(Message.newStateDirty(this));
        }
    }

    protected int changeState(int transition) {
        boolean res;
        int current = this.getTransitionCurrent(transition);
        int next = this.getTransitionNext(transition);
        if (next == 0 || current == next) {
            return this.lastReturn;
        }
        switch (transition) {
            case 18: {
                res = this.padsActivate(true);
                break;
            }
            case 35: {
                res = true;
                break;
            }
            case 50: {
                res = true;
                break;
            }
            case 33: {
                res = this.padsActivate(false);
                break;
            }
            default: {
                res = false;
            }
        }
        if (res) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doChangeState(int transition) {
        int current = this.getTransitionCurrent(transition);
        int next = this.getTransitionNext(transition);
        int result = this.changeState(transition);
        switch (result) {
            case 0: {
                this.abortState();
                break;
            }
            case 1: 
            case 3: {
                result = this.continueState(result);
                break;
            }
            case 2: {
                if (current < next) {
                    Element element = this;
                    synchronized (element) {
                        if (this.pendingState != 0) {
                            this.lastReturn = result;
                        }
                        break;
                    }
                }
                result = this.continueState(1);
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public final int setState(int newState) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean sendEvent(Event event) {
        return false;
    }

    public boolean query(Query query) {
        return false;
    }

    public Pad requestSinkPad(Pad peer) {
        return null;
    }
}

