/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

public class YUVBuffer {
    public int y_width;
    public int y_height;
    public int y_stride;
    public int uv_width;
    public int uv_height;
    public int uv_stride;
    public short[] data;
    public int y_offset;
    public int u_offset;
    public int v_offset;
    private int[] pixels;
    private int pix_size;
    private boolean newPixels = true;

    public int[] getRGB() {
        this.prepareRGBData(0, 0, this.y_width, this.y_height);
        return this.pixels;
    }

    private synchronized void prepareRGBData(int x, int y, int width, int height) {
        if (!this.newPixels) {
            return;
        }
        int size = width * height;
        try {
            if (size != this.pix_size) {
                this.pixels = new int[size];
                this.pix_size = size;
            }
            this.YUVtoRGB(x, y, width, height);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.newPixels = false;
    }

    public synchronized void newPixels() {
        this.newPixels = true;
    }

    public Object getObject(int x, int y, int width, int height) {
        if (x == 0 && y == 0 && width == this.y_width && height == this.y_height) {
            return this;
        }
        throw new RuntimeException("Can't crop YUV buffer to " + x + "," + y + "," + width + "," + height);
    }

    private void YUVtoRGB(int x, int y, int width, int height) {
        int YPtr = this.y_offset + x + y * this.y_stride;
        int YPtr2 = YPtr + this.y_stride;
        int UPtr = this.u_offset + x / 2 + y / 2 * this.uv_stride;
        int VPtr = this.v_offset + x / 2 + y / 2 * this.uv_stride;
        int RGBPtr = 0;
        int RGBPtr2 = width;
        int width2 = width / 2;
        int height2 = height / 2;
        int YStep = this.y_stride * 2 - width2 * 2;
        int UVStep = this.uv_stride - width2;
        int RGBStep = width;
        int i = 0;
        while (i < height2) {
            int j = 0;
            while (j < width2) {
                int D = this.data[UPtr++] - 128;
                int E = this.data[VPtr++] - 128;
                int t1 = 298 * (this.data[YPtr] - 16);
                int t2 = 409 * E + 128;
                int t3 = 100 * D + 208 * E - 128;
                int t4 = 516 * D + 128;
                int r = t1 + t2 >> 8;
                int g = t1 - t3 >> 8;
                int b = t1 + t4 >> 8;
                t1 = 298 * (this.data[YPtr + 1] - 16);
                this.pixels[RGBPtr] = (YUVBuffer.clamp255(r) << 16) + (YUVBuffer.clamp255(g) << 8) + YUVBuffer.clamp255(b) | 0xFF000000;
                r = t1 + t2 >> 8;
                g = t1 - t3 >> 8;
                b = t1 + t4 >> 8;
                t1 = 298 * (this.data[YPtr2] - 16);
                this.pixels[RGBPtr + 1] = (YUVBuffer.clamp255(r) << 16) + (YUVBuffer.clamp255(g) << 8) + YUVBuffer.clamp255(b) | 0xFF000000;
                r = t1 + t2 >> 8;
                g = t1 - t3 >> 8;
                b = t1 + t4 >> 8;
                t1 = 298 * (this.data[YPtr2 + 1] - 16);
                this.pixels[RGBPtr2] = (YUVBuffer.clamp255(r) << 16) + (YUVBuffer.clamp255(g) << 8) + YUVBuffer.clamp255(b) | 0xFF000000;
                r = t1 + t2 >> 8;
                g = t1 - t3 >> 8;
                b = t1 + t4 >> 8;
                this.pixels[RGBPtr2 + 1] = (YUVBuffer.clamp255(r) << 16) + (YUVBuffer.clamp255(g) << 8) + YUVBuffer.clamp255(b) | 0xFF000000;
                YPtr += 2;
                YPtr2 += 2;
                RGBPtr += 2;
                RGBPtr2 += 2;
                ++j;
            }
            YPtr += YStep;
            YPtr2 += YStep;
            UPtr += UVStep;
            VPtr += UVStep;
            RGBPtr += RGBStep;
            RGBPtr2 += RGBStep;
            ++i;
        }
    }

    private static final short clamp255(int val) {
        val -= 255;
        val = -(255 + (val >> 31 & val));
        return (short)(-(val >> 31 & val));
    }
}

