/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Info;
import com.fluendo.jheora.Playback;
import com.fluendo.utils.MemUtils;

public final class Filter {
    private static final byte[] LoopFilterLimitValuesV1;
    private byte[] LoopFilterLimits = new byte[64];
    private int[] FiltBoundingValue = new int[512];

    static {
        byte[] byArray = new byte[64];
        byArray[0] = 30;
        byArray[1] = 25;
        byArray[2] = 20;
        byArray[3] = 20;
        byArray[4] = 15;
        byArray[5] = 15;
        byArray[6] = 14;
        byArray[7] = 14;
        byArray[8] = 13;
        byArray[9] = 13;
        byArray[10] = 12;
        byArray[11] = 12;
        byArray[12] = 11;
        byArray[13] = 11;
        byArray[14] = 10;
        byArray[15] = 10;
        byArray[16] = 9;
        byArray[17] = 9;
        byArray[18] = 8;
        byArray[19] = 8;
        byArray[20] = 7;
        byArray[21] = 7;
        byArray[22] = 7;
        byArray[23] = 7;
        byArray[24] = 6;
        byArray[25] = 6;
        byArray[26] = 6;
        byArray[27] = 6;
        byArray[28] = 5;
        byArray[29] = 5;
        byArray[30] = 5;
        byArray[31] = 5;
        byArray[32] = 4;
        byArray[33] = 4;
        byArray[34] = 4;
        byArray[35] = 4;
        byArray[36] = 3;
        byArray[37] = 3;
        byArray[38] = 3;
        byArray[39] = 3;
        byArray[40] = 2;
        byArray[41] = 2;
        byArray[42] = 2;
        byArray[43] = 2;
        byArray[44] = 2;
        byArray[45] = 2;
        byArray[46] = 2;
        byArray[47] = 2;
        LoopFilterLimitValuesV1 = byArray;
    }

    private void SetupBoundingValueArray_Generic(int FLimit) {
        MemUtils.set(this.FiltBoundingValue, 0, 0, 512);
        int i = 0;
        while (i < FLimit) {
            this.FiltBoundingValue[256 - i - FLimit] = -FLimit + i;
            this.FiltBoundingValue[256 - i] = -i;
            this.FiltBoundingValue[256 + i] = i;
            this.FiltBoundingValue[256 + i + FLimit] = FLimit - i;
            ++i;
        }
    }

    public void copyFilterTables(Info ci) {
        System.arraycopy(ci.LoopFilterLimitValues, 0, this.LoopFilterLimits, 0, 64);
    }

    public void InitFilterTables() {
        System.arraycopy(LoopFilterLimitValuesV1, 0, this.LoopFilterLimits, 0, 64);
    }

    public void SetupLoopFilter(int FrameQIndex) {
        byte FLimit = this.LoopFilterLimits[FrameQIndex];
        this.SetupBoundingValueArray_Generic(FLimit);
    }

    private static final short clamp255(int val) {
        val -= 255;
        val = -(255 + (val >> 31 & val));
        return (short)(-(val >> 31 & val));
    }

    private void FilterHoriz(short[] PixelPtr, int idx, int LineLength, int[] BoundingValuePtr) {
        int j = 0;
        while (j < 8) {
            int FiltVal = PixelPtr[0 + idx] - PixelPtr[1 + idx] * 3 + PixelPtr[2 + idx] * 3 - PixelPtr[3 + idx];
            FiltVal = BoundingValuePtr[256 + (FiltVal + 4 >> 3)];
            PixelPtr[1 + idx] = Filter.clamp255(PixelPtr[1 + idx] + FiltVal);
            PixelPtr[2 + idx] = Filter.clamp255(PixelPtr[2 + idx] - FiltVal);
            idx += LineLength;
            ++j;
        }
    }

    private void FilterVert(short[] PixelPtr, int idx, int LineLength, int[] BoundingValuePtr) {
        idx -= 2 * LineLength;
        int j = 0;
        while (j < 8) {
            int FiltVal = PixelPtr[idx + 0] - PixelPtr[idx + LineLength] * 3 + PixelPtr[idx + 2 * LineLength] * 3 - PixelPtr[idx + 3 * LineLength];
            FiltVal = BoundingValuePtr[256 + (FiltVal + 4 >> 3)];
            PixelPtr[idx + LineLength] = Filter.clamp255(PixelPtr[idx + LineLength] + FiltVal);
            PixelPtr[idx + 2 * LineLength] = Filter.clamp255(PixelPtr[idx + 2 * LineLength] - FiltVal);
            ++idx;
            ++j;
        }
    }

    public void LoopFilter(Playback pbi) {
        int FragsAcross = pbi.HFragments;
        int FragsDown = pbi.VFragments;
        int QIndex = pbi.frameQIS[0];
        byte FLimit = this.LoopFilterLimits[QIndex];
        if (FLimit == 0) {
            return;
        }
        this.SetupBoundingValueArray_Generic(FLimit);
        int j = 0;
        while (j < 3) {
            int index;
            int LineFragments;
            int LineLength;
            int FromFragment;
            switch (j) {
                case 0: {
                    FromFragment = 0;
                    FragsAcross = pbi.HFragments;
                    FragsDown = pbi.VFragments;
                    LineLength = pbi.YStride;
                    LineFragments = pbi.HFragments;
                    break;
                }
                case 1: {
                    FromFragment = pbi.YPlaneFragments;
                    FragsAcross = pbi.HFragments >> 1;
                    FragsDown = pbi.VFragments >> 1;
                    LineLength = pbi.UVStride;
                    LineFragments = pbi.HFragments / 2;
                    break;
                }
                default: {
                    FromFragment = pbi.YPlaneFragments + pbi.UVPlaneFragments;
                    FragsAcross = pbi.HFragments >> 1;
                    FragsDown = pbi.VFragments >> 1;
                    LineLength = pbi.UVStride;
                    LineFragments = pbi.HFragments / 2;
                }
            }
            int i = FromFragment;
            if (pbi.display_fragments[i] != 0) {
                if (pbi.display_fragments[i + 1] == 0) {
                    this.FilterHoriz(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i] + 6, LineLength, this.FiltBoundingValue);
                }
                if (pbi.display_fragments[i + LineFragments] == 0) {
                    this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                }
            }
            ++i;
            int n = 1;
            while (n < FragsAcross - 1) {
                if (pbi.display_fragments[i] != 0) {
                    index = pbi.recon_pixel_index_table[i];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                    if (pbi.display_fragments[i + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i;
                ++n;
            }
            if (pbi.display_fragments[i] != 0) {
                this.FilterHoriz(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i] - 2, LineLength, this.FiltBoundingValue);
                if (pbi.display_fragments[i + LineFragments] == 0) {
                    this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                }
            }
            ++i;
            int m = 1;
            while (m < FragsDown - 1) {
                if (pbi.display_fragments[i] != 0) {
                    index = pbi.recon_pixel_index_table[i];
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                    if (pbi.display_fragments[i + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i;
                n = 1;
                while (n < FragsAcross - 1) {
                    if (pbi.display_fragments[i] != 0) {
                        index = pbi.recon_pixel_index_table[i];
                        this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                        this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                        if (pbi.display_fragments[i + 1] == 0) {
                            this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                        }
                        if (pbi.display_fragments[i + LineFragments] == 0) {
                            this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                        }
                    }
                    ++n;
                    ++i;
                }
                if (pbi.display_fragments[i] != 0) {
                    index = pbi.recon_pixel_index_table[i];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i;
                ++m;
            }
            if (pbi.display_fragments[i] != 0) {
                index = pbi.recon_pixel_index_table[i];
                this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                if (pbi.display_fragments[i + 1] == 0) {
                    this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                }
            }
            ++i;
            n = 1;
            while (n < FragsAcross - 1) {
                if (pbi.display_fragments[i] != 0) {
                    index = pbi.recon_pixel_index_table[i];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                }
                ++n;
                ++i;
            }
            if (pbi.display_fragments[i] != 0) {
                index = pbi.recon_pixel_index_table[i];
                this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
            }
            ++j;
        }
    }
}

