/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.SimpleBaseEffect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.Rectangle;

public class LabelEffect
extends SimpleBaseEffect {
    private static final int DEFAULT_LAYER = 100;
    private GLString label;
    private int layer = 100;
    private TickableObject tickableObject;

    public LabelEffect(GLFont font, String text, ReadableColor startColor, ReadableColor endColor, int duration, int fadeDuration) {
        super(startColor, endColor, duration, fadeDuration);
        this.label = new GLString(text, font);
        this.centre();
    }

    protected void doSpawn() {
        this.tickableObject = new TickableObject(){

            protected void render() {
                if (!LabelEffect.this.isStarted() || !this.isVisible()) {
                    return;
                }
                this.glRender(new GLRenderable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void render() {
                        GL11.glEnable((int)3553);
                        GL11.glEnable((int)3042);
                        GL11.glBlendFunc((int)770, (int)771);
                        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                    }
                });
                LabelEffect.this.label.setColour((ReadableColor)LabelEffect.this.getCachedColor());
                LabelEffect.this.label.render((SimpleRenderer)this);
            }
        };
        this.tickableObject.setLayer(this.layer);
        this.tickableObject.setVisible(this.isVisible());
        this.tickableObject.spawn(this.getScreen());
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
        if (this.tickableObject != null) {
            this.tickableObject.setLayer(layer);
        }
    }

    protected void onSetVisible() {
        if (this.tickableObject != null) {
            this.tickableObject.setVisible(this.isVisible());
        }
    }

    protected void doRemove() {
        if (this.tickableObject != null) {
            this.tickableObject.remove();
            this.tickableObject = null;
        }
    }

    public void setText(String newText) {
        this.label.setText(newText);
        this.centre();
    }

    private void centre() {
        Rectangle bounds = this.label.getBounds(null);
        this.setSize(bounds.getWidth(), bounds.getHeight());
    }

    protected void doSetLocation() {
    }

    protected void doUpdate() {
        int x = (int)this.getX() - this.getWidth() / 2;
        int y = (int)this.getY() - this.getHeight() / 2;
        ReadablePoint offset = this.getOffset();
        if (offset != null) {
            x += offset.getX();
            y += offset.getY();
        }
        this.label.setLocation(x, y);
    }

    protected void doEffectRender() {
    }
}

