/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Attenuator;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import java.util.WeakHashMap;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import org.lwjgl.util.ReadablePoint;

public abstract class Effect
implements Tickable {
    private static final WeakHashMap DEFAULT_OFFSETS = new WeakHashMap();
    private static final WeakHashMap DEFAULT_ATTENUATORS = new WeakHashMap();
    private int delay = 1;
    private boolean paused;
    private Screen screen;
    private ALBuffer sound;
    private boolean visible = true;
    private ReadablePoint offset;
    private boolean spawned;
    private Attenuator attenuator;
    private transient SoundEffect soundEffect;

    public static void setDefaultOffset(SpriteAllocator screen, ReadablePoint defaultOffset) {
        DEFAULT_OFFSETS.put(screen, defaultOffset);
    }

    public void setOffset(ReadablePoint offset) {
        this.offset = offset;
    }

    public ReadablePoint getOffset() {
        return this.offset;
    }

    public static void setDefaultAttenuator(SpriteAllocator screen, Attenuator defaultAttenuator) {
        DEFAULT_ATTENUATORS.put(screen, defaultAttenuator);
    }

    public void setAttenuator(Attenuator attenuator) {
        this.attenuator = attenuator;
    }

    public Attenuator getAttenuator() {
        return this.attenuator;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
        this.onSetVisible();
    }

    protected void onSetVisible() {
    }

    public boolean isStarted() {
        return this.delay == 0;
    }

    public final void setPaused(boolean paused) {
        if (this.paused != paused) {
            this.paused = paused;
            this.onPausedChanged();
        }
    }

    protected void onPausedChanged() {
    }

    public final boolean isPaused() {
        return this.paused;
    }

    public void start() {
        this.delay = 0;
        if (this.sound != null) {
            this.playSound(this.sound);
        }
        this.init();
    }

    protected void playSound(ALBuffer sound) {
        this.soundEffect = Game.allocateSound(sound, 1.0f, 1.0f, this);
    }

    public final void spawn(Screen screen) {
        if (this.spawned) {
            return;
        }
        this.screen = screen;
        if (this.isBackgroundEffect()) {
            screen.addBackgroundEffect(this);
        } else {
            screen.addForegroundEffect(this);
            if (this.offset == null) {
                this.setOffset((ReadablePoint)DEFAULT_OFFSETS.get((Object)screen));
            }
            if (this.attenuator == null) {
                this.setAttenuator((Attenuator)DEFAULT_ATTENUATORS.get((Object)screen));
            }
        }
        this.doSpawn();
        this.spawned = true;
    }

    protected Screen getScreen() {
        return this.screen;
    }

    protected void doSpawn() {
    }

    public final void setDelay(int delay) {
        this.delay = Math.max(1, delay + 1);
    }

    public final void tick() {
        if (this.paused) {
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            if (this.delay == 0) {
                this.start();
            }
        }
        if (this.delay == 0) {
            this.doTick();
        }
    }

    public void update() {
        if (this.delay == 0) {
            this.doUpdate();
            if (this.soundEffect != null && this.attenuator != null) {
                this.updateSound(this.sound.getGain(), this.soundEffect);
            }
        }
    }

    protected void updateSound(float gain, SoundEffect effect) {
    }

    protected void doUpdate() {
    }

    public final void setSound(ALBuffer sound) {
        this.sound = sound;
    }

    public final ALBuffer getSound() {
        return this.sound;
    }

    protected void init() {
    }

    protected abstract void doTick();

    public final void render() {
        if (this.delay == 0 && this.visible) {
            this.doRender();
        }
    }

    protected abstract void doRender();

    public void finish() {
        this.remove();
    }

    public boolean isFinished() {
        return !this.isActive();
    }

    public final void remove() {
        if (!this.spawned) {
            return;
        }
        if (this.isBackgroundEffect()) {
            this.screen.removeBackgroundEffect(this);
        } else {
            this.screen.removeForegroundEffect(this);
            if (this.soundEffect != null) {
                this.soundEffect.stop((Object)this);
                this.soundEffect = null;
            }
        }
        this.doRemove();
        this.spawned = false;
    }

    protected void doRemove() {
    }

    public boolean isBackgroundEffect() {
        return false;
    }
}

