/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.puppygames.applet.Game;

public class PlayerSlot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;

    public PlayerSlot(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof PlayerSlot && ((PlayerSlot)obj).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        block3: {
            try {
                if (Game.getPreferences().nodeExists("slots/" + this.name)) break block3;
                return false;
            }
            catch (BackingStoreException e) {
                e.printStackTrace(System.err);
                return false;
            }
        }
        return this.getPreferences().getBoolean("active", false);
    }

    public void delete() {
        if (this.exists()) {
            try {
                this.getPreferences().removeNode();
                this.getPreferences().flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace(System.err);
            }
            String slotDir = String.valueOf(Game.getSlotDirectoryPrefix()) + this.name;
            File slotDirF = new File(slotDir);
            PlayerSlot.delTree(slotDirF);
        }
    }

    private static void delTree(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                PlayerSlot.delTree(files[i]);
            } else if (!files[i].delete()) {
                System.out.println("Failed to delete " + files[i]);
            } else {
                System.out.println("Deleted " + files[i]);
            }
            ++i;
        }
        if (!dir.delete()) {
            System.out.println("Failed to delete " + dir);
        } else {
            System.out.println("Deleted " + dir);
        }
    }

    public Preferences getPreferences() {
        return Game.getPreferences().node("slots/" + this.name);
    }

    public void create() throws BackingStoreException {
        if (!this.exists()) {
            this.getPreferences().putBoolean("active", true);
            this.getPreferences().flush();
        }
    }

    public static List getSlots() {
        Preferences dir = Game.getPreferences().node("slots");
        try {
            String[] name = dir.childrenNames();
            ArrayList<PlayerSlot> ret = new ArrayList<PlayerSlot>(name.length);
            int i = 0;
            while (i < name.length) {
                if (dir.node(name[i]).getBoolean("active", false)) {
                    ret.add(new PlayerSlot(name[i]));
                }
                ++i;
            }
            return ret;
        }
        catch (BackingStoreException e) {
            return new ArrayList(0);
        }
    }
}

