/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

import com.shavenpuppy.jglib.util.PriorityPooled;
import org.lwjgl.Sys;

public class PriorityPool {
    private final PoolWrapper[] pool;
    private final PoolWrapper[] poolCopy;
    private int inUse;

    public PriorityPool(PriorityPooled[] pooled) {
        this.pool = new PoolWrapper[pooled.length];
        this.poolCopy = new PoolWrapper[pooled.length];
        int i = 0;
        while (i < pooled.length) {
            this.pool[i] = new PoolWrapper(pooled[i]);
            this.pool[i].index = i;
            ++i;
        }
    }

    public PriorityPooled allocate(int priority, Object owner) {
        PoolWrapper pw;
        PriorityPooled ret = null;
        if (this.inUse < this.pool.length) {
            this.pool[this.inUse].allocate(priority, owner);
            return this.pool[this.inUse++].pooled;
        }
        int lowestPriority = 999999;
        long oldestAge = Long.MAX_VALUE;
        int oldestIndex = -1;
        int i = 0;
        while (i < this.inUse) {
            if (!this.pool[i].isLocked()) {
                if (this.pool[i].getPriority() == lowestPriority) {
                    if (this.pool[i].age < oldestAge) {
                        oldestAge = this.pool[i].age;
                        oldestIndex = i;
                    }
                } else if (this.pool[i].getPriority() < lowestPriority) {
                    lowestPriority = this.pool[i].getPriority();
                    oldestAge = this.pool[i].age;
                    oldestIndex = i;
                }
            }
            ++i;
        }
        if (oldestIndex >= 0 && (pw = this.pool[oldestIndex]).getPriority() <= priority) {
            pw.deactivate();
            ++this.inUse;
            pw.allocate(priority, owner);
            ret = pw.pooled;
        }
        return ret;
    }

    private void returnToPool(PoolWrapper item) {
        this.pool[((PoolWrapper)item).index] = this.pool[this.inUse - 1];
        this.pool[item.index].index = item.index;
        this.pool[this.inUse - 1] = item;
        item.index = --this.inUse;
    }

    public void tick() {
        int n = this.inUse;
        System.arraycopy(this.pool, 0, this.poolCopy, 0, this.inUse);
        int i = 0;
        while (i < n) {
            this.poolCopy[i].tick();
            ++i;
        }
    }

    public void reset() {
        int i = this.inUse;
        while (--i >= 0) {
            this.pool[i].reset();
        }
    }

    private final class PoolWrapper {
        private int index;
        private Object owner;
        private long age;
        private final PriorityPooled pooled;

        PoolWrapper(PriorityPooled pooled) {
            this.pooled = pooled;
        }

        int getPriority() {
            return this.pooled.getPriority();
        }

        boolean isLocked() {
            return this.pooled.isLocked();
        }

        boolean isActive() {
            return this.owner != null;
        }

        void deactivate() {
            if (this.isActive()) {
                this.pooled.deactivate();
                this.owner = null;
                PriorityPool.this.returnToPool(this);
            }
        }

        void allocate(int priority, Object owner) {
            this.owner = owner;
            this.age = Sys.getTime();
            this.pooled.allocate(owner);
            this.pooled.setPriority(priority);
        }

        void tick() {
            if (this.isActive()) {
                this.pooled.tick();
                if (!this.pooled.isActive()) {
                    this.deactivate();
                }
            }
        }

        void reset() {
            this.deactivate();
        }
    }
}

