/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.util;

public final class FPMath {
    private static final float INV = 1.5258789E-5f;
    private static final double INVD = 1.52587890625E-5;
    public static final int SIXTEEN = FPMath.fpValue(16);
    public static final int EIGHT = FPMath.fpValue(8);
    public static final int FOUR = FPMath.fpValue(4);
    public static final int TWO = FPMath.fpValue(2);
    public static final int ONE = FPMath.fpValue(1);
    public static final int MINUSONE = FPMath.fpValue(-1);
    public static final int HALF = FPMath.fpValue(0.5);
    public static final int QUARTER = FPMath.fpValue(0.25);
    public static final int EIGHTH = FPMath.fpValue(0.125);
    public static final int SIXTEENTH = FPMath.fpValue(0.0625);
    public static final int THIRTYTWOTH = FPMath.fpValue(0.03125);
    public static final int PI = FPMath.fpValue(Math.PI);
    public static final int PIBY2 = FPMath.fpValue(1.5707963267948966);
    public static final int PITIMES2 = FPMath.fpValue(Math.PI * 2);
    private static final int[] cos = new int[65536];

    static {
        int i = 0;
        while (i < 65536) {
            FPMath.cos[i] = FPMath.fpValue(Math.cos((double)i * Math.PI / 32768.0));
            ++i;
        }
    }

    private FPMath() {
    }

    public static int parse(String in) throws NumberFormatException {
        if (in.endsWith("fp")) {
            return FPMath.fpValue(Float.parseFloat(in.substring(0, in.length() - 2)));
        }
        return FPMath.fpValue(Float.parseFloat(in));
    }

    public static final int sqrt(int len) {
        return FPMath.fpValue(Math.sqrt(FPMath.doubleValue(len)));
    }

    public static final int sqrt(long len) {
        return FPMath.fpValue(Math.sqrt(FPMath.doubleValue(len)));
    }

    public static int mul(int a, int b) {
        long aa = a;
        long bb = b;
        long cc = aa * bb;
        return (int)(cc >> 16);
    }

    public static long lmul(int a, int b) {
        long aa = a;
        long bb = b;
        long cc = aa * bb;
        return cc >> 16;
    }

    public static int div(int num, int den) {
        if (den == 0) {
            return 0;
        }
        return (int)(((long)num << 32) / (long)den >> 16);
    }

    public static int intValue(int fp) {
        return fp >> 16;
    }

    public static int intValue(long fp) {
        return (int)(fp >> 16);
    }

    public static int fpValue(float f) {
        return (int)(f * 65536.0f);
    }

    public static int fpValue(double f) {
        return (int)(f * 65536.0);
    }

    public static float floatValue(int fp) {
        return (float)fp * 1.5258789E-5f;
    }

    public static double doubleValue(long fp) {
        return (double)fp * 1.52587890625E-5;
    }

    public static int fpValue(int i) {
        return i << 16;
    }

    public static int cos(int theta) {
        return cos[theta & 0xFFFF];
    }

    public static int sin(int theta) {
        return cos[theta - 16384 & 0xFFFF];
    }

    public static int fpYaklyDegrees(float theta) {
        int yakTheta = (int)((double)(theta * 32768.0f) / Math.PI) & 0xFFFF;
        return yakTheta;
    }

    public static int fpYaklyDegrees(double theta) {
        return (int)(theta * 32768.0 / Math.PI) & 0xFFFF;
    }
}

